/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.encoders;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import org.neo4j.gis.spatial.AbstractGeometryEncoder;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.gis.spatial.encoders.Configurable;
import org.neo4j.graphdb.PropertyContainer;

public class SimplePointEncoder
extends AbstractGeometryEncoder
implements Configurable {
    protected GeometryFactory geometryFactory;
    protected String xProperty = "longitude";
    protected String yProperty = "latitude";

    protected GeometryFactory getGeometryFactory() {
        if (this.geometryFactory == null) {
            this.geometryFactory = new GeometryFactory();
        }
        return this.geometryFactory;
    }

    @Override
    protected void encodeGeometryShape(Geometry geometry, PropertyContainer container) {
        container.setProperty("gtype", (Object)SpatialDatabaseService.convertJtsClassToGeometryType(geometry.getClass()));
        Coordinate[] coords = geometry.getCoordinates();
        container.setProperty(this.xProperty, (Object)coords[0].x);
        container.setProperty(this.yProperty, (Object)coords[0].y);
    }

    @Override
    public Geometry decodeGeometry(PropertyContainer container) {
        double x = ((Number)container.getProperty(this.xProperty)).doubleValue();
        double y = ((Number)container.getProperty(this.yProperty)).doubleValue();
        Coordinate coordinate = new Coordinate(x, y);
        return this.getGeometryFactory().createPoint(coordinate);
    }

    @Override
    public String getConfiguration() {
        return this.xProperty + ":" + this.yProperty;
    }

    @Override
    public void setConfiguration(String configuration) {
        if (configuration != null) {
            String[] fields = configuration.split(":");
            if (fields.length > 0) {
                this.xProperty = fields[0];
            }
            if (fields.length > 1) {
                this.yProperty = fields[1];
            }
        }
    }
}

