/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.encoders;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import org.neo4j.gis.spatial.AbstractGeometryEncoder;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.graphdb.PropertyContainer;

public class SimplePropertyEncoder
extends AbstractGeometryEncoder {
    protected GeometryFactory geometryFactory;

    protected GeometryFactory getGeometryFactory() {
        if (this.geometryFactory == null) {
            this.geometryFactory = new GeometryFactory();
        }
        return this.geometryFactory;
    }

    @Override
    protected void encodeGeometryShape(Geometry geometry, PropertyContainer container) {
        container.setProperty("gtype", (Object)SpatialDatabaseService.convertJtsClassToGeometryType(geometry.getClass()));
        Coordinate[] coords = geometry.getCoordinates();
        float[] data = new float[coords.length * 2];
        for (int i = 0; i < coords.length; ++i) {
            data[i * 2 + 0] = (float)coords[i].x;
            data[i * 2 + 1] = (float)coords[i].y;
        }
        container.setProperty("data", (Object)data);
    }

    @Override
    public Geometry decodeGeometry(PropertyContainer container) {
        float[] data = (float[])container.getProperty("data");
        Coordinate[] coordinates = new Coordinate[data.length / 2];
        for (int i = 0; i < data.length / 2; ++i) {
            coordinates[i] = new Coordinate((double)data[2 * i + 0], (double)data[2 * i + 1]);
        }
        return this.getGeometryFactory().createLineString(coordinates);
    }
}

