/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.filter;

import org.geotools.data.neo4j.Neo4jFeatureBuilder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.neo4j.collections.rtree.Envelope;
import org.neo4j.collections.rtree.filter.SearchFilter;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.SpatialDatabaseException;
import org.neo4j.gis.spatial.SpatialDatabaseRecord;
import org.neo4j.gis.spatial.Utilities;
import org.neo4j.graphdb.Node;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class SearchCQL
implements SearchFilter {
    private Neo4jFeatureBuilder featureBuilder;
    private Layer layer;
    private Filter filter;
    private Envelope filterEnvelope;

    public SearchCQL(Layer layer, Filter filter) {
        this.layer = layer;
        this.featureBuilder = new Neo4jFeatureBuilder(layer);
        this.filter = filter;
        this.filterEnvelope = Utilities.extractEnvelopeFromFilter(filter);
    }

    public SearchCQL(Layer layer, String cql) {
        this.layer = layer;
        this.featureBuilder = new Neo4jFeatureBuilder(layer);
        try {
            this.filter = ECQL.toFilter((String)cql);
            this.filterEnvelope = Utilities.extractEnvelopeFromFilter(this.filter);
        }
        catch (CQLException e) {
            throw new SpatialDatabaseException("CQLException: " + e.getMessage());
        }
    }

    public boolean needsToVisit(Envelope envelope) {
        return this.filterEnvelope == null || this.filterEnvelope.intersects(envelope);
    }

    public boolean geometryMatches(Node geomNode) {
        SimpleFeature feature = this.featureBuilder.buildFeature(new SpatialDatabaseRecord(this.layer, geomNode));
        return this.filter.evaluate((Object)feature);
    }
}

