/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.indexfilter;

import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.neo4j.collections.rtree.Envelope;
import org.neo4j.collections.rtree.SpatialIndexRecordCounter;
import org.neo4j.collections.rtree.SpatialIndexVisitor;
import org.neo4j.collections.rtree.filter.SearchFilter;
import org.neo4j.collections.rtree.filter.SearchResults;
import org.neo4j.gis.spatial.LayerTreeIndexReader;
import org.neo4j.gis.spatial.filter.SearchRecords;
import org.neo4j.gis.spatial.indexfilter.LayerIndexReaderWrapper;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class DynamicIndexReader
extends LayerIndexReaderWrapper {
    private JSONObject query;

    public DynamicIndexReader(LayerTreeIndexReader index, String query) {
        super(index);
        this.query = (JSONObject)JSONValue.parse((String)query);
    }

    private boolean queryIndexNode(Envelope indexNodeEnvelope) {
        return true;
    }

    private boolean queryLeafNode(Node geomNode) {
        JSONObject properties = (JSONObject)this.query.get((Object)"properties");
        JSONObject step = (JSONObject)this.query.get((Object)"step");
        return this.queryNodeProperties(geomNode, properties) && this.stepAndQuery(geomNode, step);
    }

    private boolean stepAndQuery(Node source, JSONObject step) {
        if (step != null) {
            JSONObject properties = (JSONObject)step.get((Object)"properties");
            Relationship rel = source.getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)step.get((Object)"type").toString()), Direction.valueOf((String)step.get((Object)"direction").toString()));
            if (rel != null) {
                Node node = rel.getOtherNode(source);
                step = (JSONObject)step.get((Object)"step");
                return this.queryNodeProperties(node, properties) && this.stepAndQuery(node, step);
            }
            return false;
        }
        return true;
    }

    private boolean queryNodeProperties(Node node, JSONObject properties) {
        if (properties != null) {
            if (properties.containsKey((Object)"geometry")) {
                System.out.println("Unexpected 'geometry' in query string");
                properties.remove((Object)"geometry");
            }
            for (Object key : properties.keySet()) {
                Object value = node.getProperty(key.toString(), null);
                Object match = properties.get(key);
                if (value != null && (match == null || value.equals(match) || value.toString().equals(match.toString()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int count() {
        DynamicRecordCounter counter = new DynamicRecordCounter();
        this.index.visit((SpatialIndexVisitor)counter, this.index.getIndexRoot());
        return counter.getResult();
    }

    private SearchFilter wrapSearchFilter(final SearchFilter filter) {
        return new SearchFilter(){

            public boolean needsToVisit(Envelope envelope) {
                return DynamicIndexReader.this.queryIndexNode(envelope) && filter.needsToVisit(envelope);
            }

            public boolean geometryMatches(Node geomNode) {
                return DynamicIndexReader.this.queryLeafNode(geomNode) && filter.geometryMatches(geomNode);
            }
        };
    }

    @Override
    public SearchResults searchIndex(SearchFilter filter) {
        return this.index.searchIndex(this.wrapSearchFilter(filter));
    }

    @Override
    public SearchRecords search(SearchFilter filter) {
        return this.index.search(this.wrapSearchFilter(filter));
    }

    private class DynamicRecordCounter
    extends SpatialIndexRecordCounter {
        private DynamicRecordCounter() {
        }

        public boolean needsToVisit(Envelope indexNodeEnvelope) {
            return DynamicIndexReader.this.queryIndexNode(indexNodeEnvelope);
        }

        public void onIndexReference(Node geomNode) {
            if (DynamicIndexReader.this.queryLeafNode(geomNode)) {
                super.onIndexReference(geomNode);
            }
        }
    }
}

