/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.osm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.gis.spatial.GeometryEncoder;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.SpatialDatabaseException;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.gis.spatial.SpatialDataset;
import org.neo4j.gis.spatial.SpatialRelationshipTypes;
import org.neo4j.gis.spatial.osm.OSMLayer;
import org.neo4j.gis.spatial.osm.OSMRelation;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TraversalPosition;
import org.neo4j.graphdb.Traverser;

public class OSMDataset
implements SpatialDataset,
Iterable<Way>,
Iterator<Way> {
    private OSMLayer layer;
    private Node datasetNode;
    private Iterator<Node> wayNodeIterator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSMDataset(SpatialDatabaseService spatialDatabase, OSMLayer osmLayer, Node layerNode, long datasetId) {
        this.layer = osmLayer;
        this.datasetNode = spatialDatabase.getDatabase().getNodeById(datasetId);
        Relationship rel = layerNode.getSingleRelationship((RelationshipType)SpatialRelationshipTypes.LAYERS, Direction.INCOMING);
        if (rel == null) {
            Transaction tx = spatialDatabase.getDatabase().beginTx();
            try {
                this.datasetNode.createRelationshipTo(layerNode, (RelationshipType)SpatialRelationshipTypes.LAYERS);
                tx.success();
            }
            finally {
                tx.finish();
            }
        } else {
            Node node = rel.getStartNode();
            if (!node.equals(this.datasetNode)) {
                throw new SpatialDatabaseException("Layer '" + osmLayer + "' already belongs to another dataset: " + node);
            }
        }
    }

    public OSMDataset(SpatialDatabaseService spatialDatabase, OSMLayer osmLayer, Node layerNode) {
        this.layer = osmLayer;
        Relationship rel = layerNode.getSingleRelationship((RelationshipType)SpatialRelationshipTypes.LAYERS, Direction.INCOMING);
        if (rel == null) {
            throw new SpatialDatabaseException("Layer '" + osmLayer + "' does not have an associated dataset");
        }
        this.datasetNode = rel.getStartNode();
    }

    public Iterable<Node> getAllUserNodes() {
        return this.datasetNode.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, new ReturnableEvaluator(){

            public boolean isReturnableNode(TraversalPosition current) {
                Relationship rel = current.lastRelationshipTraversed();
                return rel != null && rel.isType((RelationshipType)OSMRelation.OSM_USER);
            }
        }, (RelationshipType)OSMRelation.USERS, Direction.OUTGOING, (RelationshipType)OSMRelation.OSM_USER, Direction.OUTGOING);
    }

    public Iterable<Node> getAllChangesetNodes() {
        return this.datasetNode.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, new ReturnableEvaluator(){

            public boolean isReturnableNode(TraversalPosition current) {
                Relationship rel = current.lastRelationshipTraversed();
                return rel != null && rel.isType((RelationshipType)OSMRelation.USER);
            }
        }, new Object[]{OSMRelation.USERS, Direction.OUTGOING, OSMRelation.OSM_USER, Direction.OUTGOING, OSMRelation.USER, Direction.INCOMING});
    }

    public Iterable<Node> getAllWayNodes() {
        return this.datasetNode.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL_BUT_START_NODE, (RelationshipType)OSMRelation.WAYS, Direction.OUTGOING, (RelationshipType)OSMRelation.NEXT, Direction.OUTGOING);
    }

    public Iterable<Node> getAllPointNodes() {
        return this.datasetNode.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, new ReturnableEvaluator(){

            public boolean isReturnableNode(TraversalPosition current) {
                return current.lastRelationshipTraversed().isType((RelationshipType)OSMRelation.NODE);
            }
        }, new Object[]{OSMRelation.WAYS, Direction.OUTGOING, OSMRelation.NEXT, Direction.OUTGOING, OSMRelation.FIRST_NODE, Direction.OUTGOING, OSMRelation.NODE, Direction.OUTGOING});
    }

    public Iterable<Node> getWayNodes(Node way) {
        return way.getSingleRelationship((RelationshipType)OSMRelation.FIRST_NODE, Direction.OUTGOING).getEndNode().traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, new ReturnableEvaluator(){

            public boolean isReturnableNode(TraversalPosition current) {
                Relationship lastRelationship = current.lastRelationshipTraversed();
                return lastRelationship != null && lastRelationship.isType((RelationshipType)OSMRelation.NODE);
            }
        }, (RelationshipType)OSMRelation.NEXT, Direction.OUTGOING, (RelationshipType)OSMRelation.NODE, Direction.OUTGOING);
    }

    public Node getChangeset(Node way) {
        try {
            return way.getSingleRelationship((RelationshipType)OSMRelation.CHANGESET, Direction.OUTGOING).getEndNode();
        }
        catch (Exception e) {
            System.out.println("Node has no changeset: " + e.getMessage());
            return null;
        }
    }

    public Node getUser(Node nodeWayOrChangeset) {
        Iterator results = nodeWayOrChangeset.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, new ReturnableEvaluator(){

            public boolean isReturnableNode(TraversalPosition current) {
                Relationship lastRelationship = current.lastRelationshipTraversed();
                return lastRelationship != null && lastRelationship.isType((RelationshipType)OSMRelation.USER);
            }
        }, (RelationshipType)OSMRelation.CHANGESET, Direction.OUTGOING, (RelationshipType)OSMRelation.USER, Direction.OUTGOING).iterator();
        return results.hasNext() ? (Node)results.next() : null;
    }

    public Way getWayFromId(long id) {
        return this.getWayFrom(this.datasetNode.getGraphDatabase().getNodeById(id));
    }

    public Way getWayFrom(Node osmNodeOrWayNodeOrGeomNode) {
        Iterator results = osmNodeOrWayNodeOrGeomNode.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, new ReturnableEvaluator(){

            public boolean isReturnableNode(TraversalPosition current) {
                return current.currentNode().hasProperty("way_osm_id");
            }
        }, new Object[]{OSMRelation.NODE, Direction.INCOMING, OSMRelation.NEXT, Direction.INCOMING, OSMRelation.FIRST_NODE, Direction.INCOMING, OSMRelation.GEOM, Direction.INCOMING}).iterator();
        return results.hasNext() ? new Way((Node)results.next()) : null;
    }

    @Override
    public Iterable<? extends Geometry> getAllGeometries() {
        return this.layer.getAllGeometries();
    }

    @Override
    public Iterable<Node> getAllGeometryNodes() {
        return this.layer.getAllGeometryNodes();
    }

    @Override
    public GeometryEncoder getGeometryEncoder() {
        return this.layer.getGeometryEncoder();
    }

    @Override
    public Iterable<? extends Layer> getLayers() {
        return Arrays.asList(this.layer);
    }

    public Iterable<Way> getWays() {
        return this;
    }

    @Override
    public Iterator<Way> iterator() {
        if (this.wayNodeIterator == null || !this.wayNodeIterator.hasNext()) {
            this.wayNodeIterator = this.getAllWayNodes().iterator();
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.wayNodeIterator.hasNext();
    }

    @Override
    public Way next() {
        return new Way(this.wayNodeIterator.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot modify way collection");
    }

    public int getPoiCount() {
        return (Integer)this.datasetNode.getProperty("poiCount", (Object)0);
    }

    public int getNodeCount() {
        return (Integer)this.datasetNode.getProperty("nodeCount", (Object)0);
    }

    public int getWayCount() {
        return (Integer)this.datasetNode.getProperty("wayCount", (Object)0);
    }

    public int getRelationCount() {
        return (Integer)this.datasetNode.getProperty("relationCount", (Object)0);
    }

    public int getChangesetCount() {
        return (Integer)this.datasetNode.getProperty("changesetCount", (Object)0);
    }

    public int getUserCount() {
        return (Integer)this.datasetNode.getProperty("userCount", (Object)0);
    }

    public class WayPoint
    extends OSMNode {
        public WayPoint(Node node) {
            super(node);
        }

        public boolean isAt(Coordinate coord) {
            return this.getCoordinate().equals((Object)coord);
        }

        public Coordinate getCoordinate() {
            return new Coordinate(this.getX(), this.getY());
        }

        private double getY() {
            return (Double)this.node.getProperty("latitude", (Object)0.0);
        }

        private double getX() {
            return (Double)this.node.getProperty("longitude", (Object)0.0);
        }
    }

    public class Way
    extends OSMNode
    implements Iterable<WayPoint>,
    Iterator<WayPoint> {
        private Iterator<Node> wayPointNodeIterator;

        public Way(Node node) {
            super(node);
        }

        public Iterable<Node> getWayNodes() {
            return OSMDataset.this.getWayNodes(this.node);
        }

        public Iterable<WayPoint> getWayPoints() {
            return this;
        }

        @Override
        public Iterator<WayPoint> iterator() {
            if (this.wayPointNodeIterator == null || !this.wayPointNodeIterator.hasNext()) {
                this.wayPointNodeIterator = this.getWayNodes().iterator();
            }
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.wayPointNodeIterator.hasNext();
        }

        @Override
        public WayPoint next() {
            return new WayPoint(this.wayPointNodeIterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot modify way-point collection");
        }

        public WayPoint getPointAt(Coordinate coordinate) {
            for (WayPoint wayPoint : this.getWayPoints()) {
                if (!wayPoint.isAt(coordinate)) continue;
                return wayPoint;
            }
            return null;
        }
    }

    public class OSMNode {
        protected Node node;
        protected Node geomNode;
        protected Geometry geometry;

        public OSMNode(Node node) {
            this.node = node;
            Relationship geomRel = this.node.getSingleRelationship((RelationshipType)OSMRelation.GEOM, Direction.OUTGOING);
            if (geomRel != null) {
                this.geomNode = geomRel.getEndNode();
            }
        }

        public Way getWay() {
            return OSMDataset.this.getWayFrom(this.node);
        }

        public Node getGeometryNode() {
            return this.geomNode;
        }

        public Geometry getGeometry() {
            if (this.geometry == null && this.geomNode != null) {
                this.geometry = OSMDataset.this.layer.getGeometryEncoder().decodeGeometry((PropertyContainer)this.geomNode);
            }
            return this.geometry;
        }

        public Envelope getEnvelope() {
            return this.getGeometry().getEnvelopeInternal();
        }

        public boolean equals(OSMNode other) {
            return this.node.getId() == other.node.getId();
        }

        public Node getNode() {
            return this.node;
        }

        public String toString() {
            if (this.node.hasProperty("name")) {
                return this.node.getProperty("name").toString();
            }
            if (this.getGeometry() != null) {
                return this.getGeometry().getGeometryType();
            }
            return this.node.toString();
        }
    }
}

