/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.osm;

import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.neo4j.collections.rtree.Envelope;
import org.neo4j.gis.spatial.AbstractGeometryEncoder;
import org.neo4j.gis.spatial.SpatialDatabaseException;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.gis.spatial.osm.OSMRelation;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.impl.traversal.TraversalDescriptionImpl;

public class OSMGeometryEncoder
extends AbstractGeometryEncoder {
    private static int decodedCount = 0;
    private static int overrunCount = 0;
    private static int nodeId = 0;
    private static int wayId = 0;
    private static int relationId = 0;
    private DateFormat dateTimeFormatter;
    private int vertices;
    private int vertexMistmaches = 0;
    private Node lastGeom = null;
    private CombinedAttributes lastAttr = null;
    private long missingTags = 0L;

    private static Node testIsNode(PropertyContainer container) {
        if (!(container instanceof Node)) {
            throw new OSMGraphException("Cannot decode non-node geometry: " + container);
        }
        return (Node)container;
    }

    @Override
    public Envelope decodeEnvelope(PropertyContainer container) {
        Node geomNode = OSMGeometryEncoder.testIsNode(container);
        double[] bbox = (double[])geomNode.getProperty("bbox");
        return new Envelope(bbox[0], bbox[1], bbox[2], bbox[3]);
    }

    @Override
    public void encodeEnvelope(Envelope mbb, PropertyContainer container) {
        container.setProperty("bbox", (Object)new double[]{mbb.getMinX(), mbb.getMaxX(), mbb.getMinY(), mbb.getMaxY()});
    }

    public static Node getOSMNodeFromGeometryNode(Node geomNode) {
        return geomNode.getSingleRelationship((RelationshipType)OSMRelation.GEOM, Direction.INCOMING).getStartNode();
    }

    public static Node getGeometryNodeFromOSMNode(Node osmNode) {
        return osmNode.getSingleRelationship((RelationshipType)OSMRelation.GEOM, Direction.OUTGOING).getEndNode();
    }

    public Iterable<Node> getPointNodesFromWayNode(Node wayNode) {
        Node firstNode = wayNode.getSingleRelationship((RelationshipType)OSMRelation.FIRST_NODE, Direction.OUTGOING).getEndNode();
        final NodeProxyIterator iterator = new NodeProxyIterator(firstNode);
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return iterator;
            }
        };
    }

    @Override
    public Geometry decodeGeometry(PropertyContainer container) {
        Node geomNode = OSMGeometryEncoder.testIsNode(container);
        try {
            GeometryFactory geomFactory = this.layer.getGeometryFactory();
            Node osmNode = OSMGeometryEncoder.getOSMNodeFromGeometryNode(geomNode);
            if (osmNode.hasProperty("node_osm_id")) {
                return geomFactory.createPoint(new Coordinate(((Double)osmNode.getProperty("lon", (Object)0.0)).doubleValue(), ((Double)osmNode.getProperty("lat", (Object)0.0)).doubleValue()));
            }
            if (osmNode.hasProperty("way_osm_id")) {
                int vertices = (Integer)geomNode.getProperty("vertices");
                int gtype = (Integer)geomNode.getProperty("gtype");
                return this.decodeGeometryFromWay(osmNode, gtype, vertices, geomFactory);
            }
            int gtype = (Integer)geomNode.getProperty("gtype");
            return this.decodeGeometryFromRelation(osmNode, gtype, geomFactory);
        }
        catch (Exception e) {
            throw new OSMGraphException("Failed to decode OSM geometry: " + e.getMessage(), e);
        }
    }

    private Geometry decodeGeometryFromRelation(Node osmNode, int gtype, GeometryFactory geomFactory) {
        switch (gtype) {
            case 3: {
                LinearRing outer = null;
                ArrayList<LinearRing> inner = new ArrayList<LinearRing>();
                for (Relationship rel : osmNode.getRelationships((RelationshipType)OSMRelation.MEMBER, Direction.OUTGOING)) {
                    Node wayNode = rel.getEndNode();
                    String role = (String)rel.getProperty("role", null);
                    if (role == null) continue;
                    LinearRing ring = this.getOuterLinearRingFromGeometry(this.decodeGeometryFromWay(wayNode, 3, -1, geomFactory));
                    if (role.equals("outer")) {
                        outer = ring;
                        continue;
                    }
                    if (!role.equals("inner")) continue;
                    inner.add(ring);
                }
                if (outer != null) {
                    return geomFactory.createPolygon(outer, inner.toArray(new LinearRing[inner.size()]));
                }
                return null;
            }
            case 6: {
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                for (Relationship rel : osmNode.getRelationships((RelationshipType)OSMRelation.MEMBER, Direction.OUTGOING)) {
                    Node member = rel.getEndNode();
                    Geometry geometry = null;
                    if (member.hasProperty("way_osm_id")) {
                        geometry = this.decodeGeometryFromWay(member, 3, -1, geomFactory);
                    } else if (!member.hasProperty("node_osm_id")) {
                        geometry = this.decodeGeometryFromRelation(member, 3, geomFactory);
                    }
                    if (geometry == null || !(geometry instanceof Polygon)) continue;
                    polygons.add((Polygon)geometry);
                }
                if (polygons.size() > 0) {
                    return geomFactory.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
                }
                return null;
            }
        }
        return null;
    }

    private LinearRing getOuterLinearRingFromGeometry(Geometry geometry) {
        if (geometry instanceof LineString) {
            LinearRing ring;
            LineString line = (LineString)geometry;
            if (line.getCoordinates().length < 3) {
                return null;
            }
            Coordinate[] coords = line.getCoordinates();
            if (!line.isClosed()) {
                coords = this.closeCoords(coords);
            }
            if ((ring = geometry.getFactory().createLinearRing(coords)).isValid()) {
                return ring;
            }
            return this.getConvexHull((Geometry)ring);
        }
        if (geometry instanceof LinearRing) {
            return (LinearRing)geometry;
        }
        if (geometry instanceof Polygon) {
            return (LinearRing)((Polygon)geometry).getExteriorRing();
        }
        return this.getConvexHull(geometry);
    }

    private Coordinate[] closeCoords(Coordinate[] coords) {
        Coordinate[] nc = new Coordinate[coords.length + 1];
        for (int i = 0; i < coords.length; ++i) {
            nc[i] = coords[i];
        }
        nc[coords.length] = coords[0];
        coords = nc;
        return coords;
    }

    private LinearRing getConvexHull(Geometry geometry) {
        return this.getOuterLinearRingFromGeometry(new ConvexHull(geometry).getConvexHull());
    }

    private Geometry decodeGeometryFromWay(Node wayNode, int gtype, int vertices, GeometryFactory geomFactory) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        boolean overrun = false;
        for (Node node : this.getPointNodesFromWayNode(wayNode)) {
            if (coordinates.size() >= vertices) {
                overrun = true;
                ++overrunCount;
                break;
            }
            coordinates.add(new Coordinate(((Double)node.getProperty("lon")).doubleValue(), ((Double)node.getProperty("lat")).doubleValue()));
        }
        ++decodedCount;
        if (overrun) {
            System.out.println("Overran expected number of way nodes: " + wayNode + " (" + overrunCount + "/" + decodedCount + ")");
        }
        if (coordinates.size() != vertices) {
            if (this.vertexMistmaches++ < 10) {
                System.err.println("Mismatching vertices size for " + SpatialDatabaseService.convertGeometryTypeToName(gtype) + ":" + wayNode + ": " + coordinates.size() + " != " + vertices);
            } else if (this.vertexMistmaches % 100 == 0) {
                System.err.println("Mismatching vertices found " + this.vertexMistmaches + " times");
            }
        }
        switch (coordinates.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return geomFactory.createPoint((Coordinate)coordinates.get(0));
            }
        }
        switch (gtype) {
            case 2: {
                return geomFactory.createLineString(coordinates.toArray(new Coordinate[coordinates.size()]));
            }
            case 3: {
                return geomFactory.createPolygon(geomFactory.createLinearRing(coordinates.toArray(new Coordinate[coordinates.size()])), new LinearRing[0]);
            }
        }
        return geomFactory.createMultiPoint(coordinates.toArray(new Coordinate[coordinates.size()]));
    }

    @Override
    protected void encodeGeometryShape(Geometry geometry, PropertyContainer container) {
        Node geomNode = OSMGeometryEncoder.testIsNode(container);
        this.vertices = 0;
        int gtype = SpatialDatabaseService.convertJtsClassToGeometryType(geometry.getClass());
        switch (gtype) {
            case 1: {
                this.makeOSMNode(geometry, geomNode);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.makeOSMWay(geometry, geomNode, gtype);
                break;
            }
            case 5: 
            case 6: {
                int gsubtype = gtype == 6 ? 3 : 2;
                Node relationNode = this.makeOSMRelation(geometry, geomNode);
                int num = geometry.getNumGeometries();
                for (int i = 0; i < num; ++i) {
                    Geometry geom = geometry.getGeometryN(i);
                    Node wayNode = this.makeOSMWay(geom, geomNode.getGraphDatabase().createNode(), gsubtype);
                    relationNode.createRelationshipTo(wayNode, (RelationshipType)OSMRelation.MEMBER);
                }
                break;
            }
            default: {
                throw new SpatialDatabaseException("Unsupported geometry: " + geometry.getClass());
            }
        }
        geomNode.setProperty("vertices", (Object)this.vertices);
    }

    private Node makeOSMNode(Geometry geometry, Node geomNode) {
        Node node = this.makeOSMNode(geometry.getCoordinate(), geomNode.getGraphDatabase());
        node.createRelationshipTo(geomNode, (RelationshipType)OSMRelation.GEOM);
        return node;
    }

    private Node makeOSMNode(Coordinate coordinate, GraphDatabaseService db) {
        ++this.vertices;
        Node node = db.createNode();
        node.setProperty(OSMId.NODE.toString(), (Object)(++nodeId));
        node.setProperty("lat", (Object)coordinate.y);
        node.setProperty("lon", (Object)coordinate.x);
        node.setProperty("timestamp", (Object)this.getTimestamp());
        return node;
    }

    private Node makeOSMWay(Geometry geometry, Node geomNode, int gtype) {
        GraphDatabaseService db = geomNode.getGraphDatabase();
        Node way = db.createNode();
        way.setProperty(OSMId.WAY.toString(), (Object)(++wayId));
        way.setProperty("timestamp", (Object)this.getTimestamp());
        way.createRelationshipTo(geomNode, (RelationshipType)OSMRelation.GEOM);
        geomNode.setProperty("gtype", (Object)gtype);
        Node prev = null;
        for (Coordinate coord : geometry.getCoordinates()) {
            Node node = this.makeOSMNode(coord, db);
            Node proxyNode = db.createNode();
            proxyNode.createRelationshipTo(node, (RelationshipType)OSMRelation.NODE);
            if (prev == null) {
                way.createRelationshipTo(proxyNode, (RelationshipType)OSMRelation.FIRST_NODE);
            } else {
                prev.createRelationshipTo(proxyNode, (RelationshipType)OSMRelation.NEXT);
            }
            prev = proxyNode;
        }
        return way;
    }

    private Node makeOSMRelation(Geometry geometry, Node geomNode) {
        ++relationId;
        throw new SpatialDatabaseException("Unimplemented: makeOSMRelation()");
    }

    private String getTimestamp() {
        if (this.dateTimeFormatter == null) {
            this.dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        }
        return this.dateTimeFormatter.format(new Date(System.currentTimeMillis()));
    }

    private CombinedAttributes getProperties(Node geomNode) {
        if (geomNode != this.lastGeom) {
            this.lastGeom = geomNode;
            this.lastAttr = new CombinedAttributes(geomNode);
        }
        return this.lastAttr;
    }

    @Override
    public boolean hasAttribute(Node geomNode, String name) {
        return this.getProperties(geomNode).hasProperty(name);
    }

    @Override
    public Object getAttribute(Node geomNode, String name) {
        return this.getProperties(geomNode).getProperty(name);
    }

    public static enum OSMId {
        NODE("node_osm_id"),
        WAY("way_osm_id"),
        RELATION("relation_osm_id");

        private String name;

        private OSMId(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class CombinedAttributes {
        private Node node;
        private PropertyContainer properties;
        private HashMap<String, Object> extra = new HashMap();

        CombinedAttributes(Node geomNode) {
            try {
                this.node = geomNode.getSingleRelationship((RelationshipType)OSMRelation.GEOM, Direction.INCOMING).getStartNode();
                this.properties = this.node.getSingleRelationship((RelationshipType)OSMRelation.TAGS, Direction.OUTGOING).getEndNode();
                Node changeset = this.node.getSingleRelationship((RelationshipType)OSMRelation.CHANGESET, Direction.OUTGOING).getEndNode();
                if (changeset != null) {
                    this.extra.put("changeset", changeset.getProperty("changeset", null));
                    Node user = changeset.getSingleRelationship((RelationshipType)OSMRelation.USER, Direction.OUTGOING).getEndNode();
                    if (user != null) {
                        this.extra.put("user", user.getProperty("name", null));
                        this.extra.put("user_id", user.getProperty("uid", null));
                    }
                }
            }
            catch (NullPointerException e) {
                if (OSMGeometryEncoder.this.missingTags++ < 10L) {
                    System.err.println("Geometry has no related tags node: " + geomNode);
                } else if (OSMGeometryEncoder.this.missingTags % 100L == 0L) {
                    System.err.println("Geometries without tags found " + OSMGeometryEncoder.this.missingTags + " times");
                }
                this.properties = new NullProperties();
            }
        }

        public boolean hasProperty(String key) {
            return this.extra.containsKey(key) || this.node.hasProperty(key) || this.properties.hasProperty(key);
        }

        public Object getProperty(String key) {
            return this.extra.containsKey(key) ? this.extra.get(key) : (this.node.hasProperty(key) ? this.node.getProperty(key, null) : this.properties.getProperty(key, null));
        }
    }

    private class NodeProxyIterator
    implements Iterator<Node> {
        Iterator<Path> traverser;

        NodeProxyIterator(Node first) {
            this.traverser = new TraversalDescriptionImpl().relationships((RelationshipType)OSMRelation.NEXT, Direction.OUTGOING).traverse(first).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.traverser.hasNext();
        }

        @Override
        public Node next() {
            return this.traverser.next().endNode().getSingleRelationship((RelationshipType)OSMRelation.NODE, Direction.OUTGOING).getEndNode();
        }

        @Override
        public void remove() {
        }
    }

    public static class OSMGraphException
    extends SpatialDatabaseException {
        private static final long serialVersionUID = -6892234738075001044L;

        public OSMGraphException(String message) {
            super(message);
        }

        public OSMGraphException(String message, Exception cause) {
            super(message, cause);
        }
    }

    private final class NullProperties
    implements PropertyContainer {
        private NullProperties() {
        }

        public GraphDatabaseService getGraphDatabase() {
            return null;
        }

        public Object getProperty(String key) {
            return null;
        }

        public Object getProperty(String key, Object defaultValue) {
            return null;
        }

        public Iterable<String> getPropertyKeys() {
            return null;
        }

        public Iterable<Object> getPropertyValues() {
            return null;
        }

        public boolean hasProperty(String key) {
            return false;
        }

        public Object removeProperty(String key) {
            return null;
        }

        public void setProperty(String key, Object value) {
        }
    }
}

