/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.pipes;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.gis.spatial.SpatialDatabaseRecord;
import org.neo4j.gis.spatial.SpatialRecord;

public class GeoPipeFlow
implements SpatialRecord {
    private String id;
    private List<SpatialDatabaseRecord> records = new ArrayList<SpatialDatabaseRecord>();
    private Geometry geometry;
    private Envelope geometryEnvelope;
    private Map<String, Object> properties = new HashMap<String, Object>();

    private GeoPipeFlow(String id) {
        this.id = id;
    }

    public GeoPipeFlow(SpatialDatabaseRecord record) {
        this.id = Long.toString(record.getNodeId());
        this.records.add(record);
        this.geometry = record.getGeometry();
    }

    public SpatialDatabaseRecord getRecord() {
        return this.records.get(0);
    }

    public int countRecords() {
        return this.records.size();
    }

    public List<SpatialDatabaseRecord> getRecords() {
        return this.records;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Geometry getGeometry() {
        return this.geometry;
    }

    public Envelope getEnvelope() {
        if (this.geometryEnvelope == null) {
            this.geometryEnvelope = this.geometry.getEnvelopeInternal();
        }
        return this.geometryEnvelope;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
        this.geometryEnvelope = null;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[0]);
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void merge(GeoPipeFlow other) {
        this.records.addAll(other.records);
    }

    public GeoPipeFlow makeClone(String idSuffix) {
        GeoPipeFlow clone = new GeoPipeFlow(this.id + "-" + idSuffix);
        clone.records.addAll(this.records);
        clone.geometry = this.geometry;
        clone.getProperties().putAll(this.getProperties());
        return clone;
    }
}

