/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.pipes.filtering;

import com.vividsolutions.jts.geom.Geometry;
import org.neo4j.gis.spatial.pipes.AbstractFilterGeoPipe;
import org.neo4j.gis.spatial.pipes.GeoPipeFlow;

public class FilterEqualNorm
extends AbstractFilterGeoPipe {
    private Geometry other;
    private double tolerance;

    public FilterEqualNorm(Geometry other) {
        this(other, 0.0);
    }

    public FilterEqualNorm(Geometry other, double tolerance) {
        this.other = other.norm();
        this.tolerance = tolerance;
    }

    @Override
    protected boolean validate(GeoPipeFlow flow) {
        Geometry current = flow.getGeometry().norm();
        return this.other.equalsExact(current, this.tolerance);
    }
}

