/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.pipes.osm.filtering;

import com.tinkerpop.pipes.filter.FilterPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import org.neo4j.gis.spatial.osm.OSMRelation;
import org.neo4j.gis.spatial.pipes.AbstractGeoPipe;
import org.neo4j.gis.spatial.pipes.GeoPipeFlow;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;

public class FilterOSMAttributes
extends AbstractGeoPipe {
    private String key;
    private Object value;
    private FilterPipe.Filter comparison;

    public FilterOSMAttributes(String key, Object value) {
        this(key, value, FilterPipe.Filter.EQUAL);
    }

    public FilterOSMAttributes(String key, Object value, FilterPipe.Filter comparison) {
        this.key = key;
        this.value = value;
        this.comparison = comparison;
    }

    @Override
    protected GeoPipeFlow process(GeoPipeFlow flow) {
        Node geomNode = flow.getRecord().getGeomNode();
        Node waysNode = geomNode.getSingleRelationship((RelationshipType)OSMRelation.GEOM, Direction.INCOMING).getStartNode();
        Node tagNode = waysNode.getSingleRelationship((RelationshipType)OSMRelation.TAGS, Direction.OUTGOING).getEndNode();
        if (tagNode.hasProperty(this.key) && PipeHelper.compareObjects((FilterPipe.Filter)this.comparison, (Object)tagNode.getProperty(this.key), (Object)this.value)) {
            return flow;
        }
        return null;
    }
}

