/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.pipes.processing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import org.neo4j.gis.spatial.pipes.AbstractGeoPipe;
import org.neo4j.gis.spatial.pipes.GeoPipeFlow;

public class OrthodromicDistance
extends AbstractGeoPipe {
    private Coordinate reference;
    public static final double earthRadiusInKm = 6371.0;

    public OrthodromicDistance(Coordinate reference) {
        this.reference = reference;
    }

    public OrthodromicDistance(Coordinate reference, String resultPropertyName) {
        super(resultPropertyName);
        this.reference = reference;
    }

    @Override
    protected GeoPipeFlow process(GeoPipeFlow flow) {
        Coordinate point = flow.getGeometry().getCoordinate();
        double distanceInKm = OrthodromicDistance.calculateDistance(this.reference, point);
        this.setProperty(flow, distanceInKm);
        return flow;
    }

    public static Envelope suggestSearchWindow(Coordinate reference, double maxDistanceInKm) {
        double lat = reference.y;
        double lon = reference.x;
        double maxLat = lat + Math.toDegrees(maxDistanceInKm / 6371.0);
        double minLat = lat - Math.toDegrees(maxDistanceInKm / 6371.0);
        double maxLon = lon + Math.toDegrees(maxDistanceInKm / 6371.0 / Math.cos(Math.toRadians(lat)));
        double minLon = lon - Math.toDegrees(maxDistanceInKm / 6371.0 / Math.cos(Math.toRadians(lat)));
        return new Envelope(minLon, maxLon, minLat, maxLat);
    }

    public static double calculateDistance(Coordinate reference, Coordinate point) {
        double distanceInKm = Math.acos(Math.sin(Math.toRadians(reference.y)) * Math.sin(Math.toRadians(point.y)) + Math.cos(Math.toRadians(reference.y)) * Math.cos(Math.toRadians(point.y)) * Math.cos(Math.toRadians(point.x) - Math.toRadians(reference.x))) * 6371.0;
        return distanceInKm;
    }
}

