/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.pipes.processing;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import org.geotools.referencing.GeodeticCalculator;
import org.neo4j.gis.spatial.pipes.AbstractGeoPipe;
import org.neo4j.gis.spatial.pipes.GeoPipeFlow;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OrthodromicLength
extends AbstractGeoPipe {
    protected CoordinateReferenceSystem crs;

    public OrthodromicLength(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public OrthodromicLength(CoordinateReferenceSystem crs, String resultPropertyName) {
        super(resultPropertyName);
        this.crs = crs;
    }

    @Override
    protected GeoPipeFlow process(GeoPipeFlow flow) {
        this.setProperty(flow, this.calculateLength(flow.getGeometry(), this.crs));
        return flow;
    }

    protected double calculateLength(Geometry geometry, CoordinateReferenceSystem crs) {
        GeodeticCalculator geodeticCalculator = new GeodeticCalculator(crs);
        Coordinate[] coords = geometry.getCoordinates();
        double totalLength = 0.0;
        for (int i = 0; i < coords.length - 1; ++i) {
            Coordinate c1 = coords[i];
            Coordinate c2 = coords[i + 1];
            geodeticCalculator.setStartingGeographicPoint(c1.x, c1.y);
            geodeticCalculator.setDestinationGeographicPoint(c2.x, c2.y);
            totalLength += geodeticCalculator.getOrthodromicDistance();
        }
        return totalLength;
    }
}

