/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.pipes.processing;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import org.neo4j.gis.spatial.pipes.AbstractGeoPipe;
import org.neo4j.gis.spatial.pipes.GeoPipeFlow;

public class SimplifyPreservingTopology
extends AbstractGeoPipe {
    private double distanceTolerance;

    public SimplifyPreservingTopology(double distanceTolerance) {
        this.distanceTolerance = distanceTolerance;
    }

    public SimplifyPreservingTopology(double distanceTolerance, String resultPropertyName) {
        super(resultPropertyName);
        this.distanceTolerance = distanceTolerance;
    }

    @Override
    protected GeoPipeFlow process(GeoPipeFlow flow) {
        this.setGeometry(flow, TopologyPreservingSimplifier.simplify((Geometry)flow.getGeometry(), (double)this.distanceTolerance));
        return flow;
    }
}

