/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.pipes.processing;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import org.neo4j.gis.spatial.pipes.AbstractGeoPipe;
import org.neo4j.gis.spatial.pipes.GeoPipeFlow;

public class SimplifyWithDouglasPeucker
extends AbstractGeoPipe {
    private double distanceTolerance;

    public SimplifyWithDouglasPeucker(double distanceTolerance) {
        this.distanceTolerance = distanceTolerance;
    }

    public SimplifyWithDouglasPeucker(double distanceTolerance, String resultPropertyName) {
        super(resultPropertyName);
        this.distanceTolerance = distanceTolerance;
    }

    @Override
    protected GeoPipeFlow process(GeoPipeFlow flow) {
        this.setGeometry(flow, DouglasPeuckerSimplifier.simplify((Geometry)flow.getGeometry(), (double)this.distanceTolerance));
        return flow;
    }
}

