/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.pipes.processing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.neo4j.gis.spatial.pipes.AbstractGeoPipe;
import org.neo4j.gis.spatial.pipes.GeoPipeFlow;

public class Sort
extends AbstractGeoPipe {
    private List<GeoPipeFlow> sortedFlow = new ArrayList<GeoPipeFlow>();
    private Comparator<GeoPipeFlow> comparator;
    private Iterator<GeoPipeFlow> flowIterator;

    public Sort(final String property, final Comparator<Object> propertyComparator) {
        this.comparator = new Comparator<GeoPipeFlow>(){

            @Override
            public int compare(GeoPipeFlow o1, GeoPipeFlow o2) {
                Object p1 = o1.getProperties().get(property);
                Object p2 = o2.getProperties().get(property);
                if (p1 == null && p2 == null) {
                    return 0;
                }
                if (p1 == null) {
                    return -1;
                }
                if (p2 == null) {
                    return 1;
                }
                return propertyComparator.compare(p1, p2);
            }
        };
    }

    public Sort(String property, final boolean asc) {
        this(property, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int result = ((Comparable)o1).compareTo(o2);
                if (!asc) {
                    result *= -1;
                }
                return result;
            }
        });
    }

    @Override
    public GeoPipeFlow processNextStart() {
        if (this.flowIterator == null) {
            try {
                while (true) {
                    this.sortedFlow.add((GeoPipeFlow)this.starts.next());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                Collections.sort(this.sortedFlow, this.comparator);
                this.flowIterator = this.sortedFlow.iterator();
            }
        }
        return this.flowIterator.next();
    }
}

