/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.util.FileUtils;

public class TestDefaultSettings {
    private static final File DB_PATH = new File("target", "defaults");
    private EmbeddedGraphDatabase db;

    @After
    public void shutdownDb() {
        if (this.db != null) {
            this.db.shutdown();
        }
        this.db = null;
    }

    @BeforeClass
    public static void deleteDb() throws Exception {
        FileUtils.deleteRecursively((File)DB_PATH);
    }

    @Test
    public void testDefaults() {
        this.db = new EmbeddedGraphDatabase(DB_PATH.getAbsolutePath());
        Config config = this.db.getConfig();
        Assert.assertTrue((boolean)config.getInputParams().entrySet().isEmpty());
        Map params = config.getParams();
        boolean mmaped = Boolean.parseBoolean((String)params.get("use_memory_mapped_buffers"));
        boolean isWin = Config.osIsWindows();
        if (isWin) {
            Assert.assertFalse((boolean)mmaped);
        }
        if (!isWin) {
            Assert.assertTrue((boolean)mmaped);
        }
        Assert.assertEquals((Object)"20M", params.get("neostore.nodestore.db.mapped_memory"));
        Assert.assertEquals((Object)"90M", params.get("neostore.propertystore.db.mapped_memory"));
        Assert.assertEquals((Object)"1M", params.get("neostore.propertystore.db.index.mapped_memory"));
        Assert.assertEquals((Object)"1M", params.get("neostore.propertystore.db.index.keys.mapped_memory"));
        Assert.assertEquals((Object)"130M", params.get("neostore.propertystore.db.strings.mapped_memory"));
        Assert.assertEquals((Object)"130M", params.get("neostore.propertystore.db.arrays.mapped_memory"));
        Assert.assertEquals((Object)"100M", params.get("neostore.relationshipstore.db.mapped_memory"));
    }

    @Test
    public void testOverrides() {
        HashMap<String, String> overrides = new HashMap<String, String>();
        if (Config.osIsWindows()) {
            overrides.put("use_memory_mapped_buffers", "true");
        } else {
            overrides.put("use_memory_mapped_buffers", "false");
        }
        overrides.put("neostore.nodestore.db.mapped_memory", "10M");
        overrides.put("neostore.propertystore.db.mapped_memory", "10M");
        overrides.put("neostore.propertystore.db.index.mapped_memory", "10M");
        overrides.put("neostore.propertystore.db.index.keys.mapped_memory", "10M");
        overrides.put("neostore.propertystore.db.strings.mapped_memory", "10M");
        overrides.put("neostore.propertystore.db.arrays.mapped_memory", "10M");
        overrides.put("neostore.relationshipstore.db.mapped_memory", "10M");
        overrides.put("allow_store_upgrade", "true");
        overrides.put("dump_configuration", "true");
        this.db = new EmbeddedGraphDatabase(DB_PATH.getAbsolutePath(), overrides);
        Config config = this.db.getConfig();
        Assert.assertEquals((long)10L, (long)config.getInputParams().entrySet().size());
        Map params = config.getParams();
        boolean mmaped = Boolean.parseBoolean((String)params.get("use_memory_mapped_buffers"));
        boolean isWin = Config.osIsWindows();
        if (isWin) {
            Assert.assertTrue((boolean)mmaped);
        }
        if (!isWin) {
            Assert.assertFalse((boolean)mmaped);
        }
        Assert.assertEquals((Object)"10M", params.get("neostore.nodestore.db.mapped_memory"));
        Assert.assertEquals((Object)"10M", params.get("neostore.propertystore.db.mapped_memory"));
        Assert.assertEquals((Object)"10M", params.get("neostore.propertystore.db.index.mapped_memory"));
        Assert.assertEquals((Object)"10M", params.get("neostore.propertystore.db.index.keys.mapped_memory"));
        Assert.assertEquals((Object)"10M", params.get("neostore.propertystore.db.strings.mapped_memory"));
        Assert.assertEquals((Object)"10M", params.get("neostore.propertystore.db.arrays.mapped_memory"));
        Assert.assertEquals((Object)"10M", params.get("neostore.relationshipstore.db.mapped_memory"));
        Assert.assertEquals((Object)"true", params.get("allow_store_upgrade"));
        Assert.assertEquals((Object)"true", params.get("dump_configuration"));
    }
}

