/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.test.TargetDirectory;

public class TransactionLifecycleTest {
    public TargetDirectory target = TargetDirectory.forTest(this.getClass());
    private EmbeddedGraphDatabase graphdb;

    @Before
    public void startGraphdb() {
        this.graphdb = new EmbeddedGraphDatabase(this.target.graphDbDir(true).getPath());
    }

    @After
    public void stopGraphdb() {
        if (this.graphdb != null) {
            this.graphdb.shutdown();
        }
        this.graphdb = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=NotFoundException.class)
    public void givenACallToFailATransactionSubsequentSuccessCallsShouldBeSwallowedSilently() {
        Transaction tx = this.graphdb.beginTx();
        Node someNode = null;
        try {
            someNode = this.graphdb.createNode();
            tx.failure();
            tx.success();
        }
        finally {
            tx.finish();
        }
        Assert.assertNull((Object)this.graphdb.getNodeById(someNode.getId()));
    }
}

