/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;

public class TestProperties
extends AbstractNeo4jTestCase {
    @Test
    public void addAndRemovePropertiesWithinOneTransaction() throws Exception {
        Node node = this.getGraphDb().createNode();
        node.setProperty("name", (Object)"oscar");
        node.setProperty("favourite_numbers", (Object)new Long[]{1L, 2L, 3L});
        node.setProperty("favourite_colors", (Object)new String[]{"blue", "red"});
        node.removeProperty("favourite_colors");
        this.newTransaction();
        Assert.assertNotNull((Object)node.getProperty("favourite_numbers", null));
    }

    @Test
    public void addAndRemovePropertiesWithinOneTransaction2() throws Exception {
        Node node = this.getGraphDb().createNode();
        node.setProperty("foo", (Object)"bar");
        this.newTransaction();
        node.setProperty("foo2", (Object)"bar");
        node.removeProperty("foo");
        this.newTransaction();
        try {
            node.getProperty("foo");
            Assert.fail((String)"property should not exist");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void removeAndAddSameProperty() throws Exception {
        Node node = this.getGraphDb().createNode();
        node.setProperty("foo", (Object)"bar");
        this.newTransaction();
        node.removeProperty("foo");
        node.setProperty("foo", (Object)"bar");
        this.newTransaction();
        Assert.assertEquals((Object)"bar", (Object)node.getProperty("foo"));
        node.setProperty("foo", (Object)"bar");
        node.removeProperty("foo");
        this.newTransaction();
        Assert.assertNull((Object)node.getProperty("foo", null));
    }

    @Test
    public void removeSomeAndSetSome() throws Exception {
        Node node = this.getGraphDb().createNode();
        node.setProperty("remove me", (Object)"trash");
        this.newTransaction();
        node.removeProperty("remove me");
        node.setProperty("foo", (Object)"bar");
        node.setProperty("baz", (Object)17);
        this.newTransaction();
        Assert.assertEquals((Object)"bar", (Object)node.getProperty("foo"));
        Assert.assertEquals((Object)17, (Object)node.getProperty("baz"));
        Assert.assertNull((Object)node.getProperty("remove me", null));
    }

    @Test
    public void removeOneOfThree() throws Exception {
        Node node = this.getGraphDb().createNode();
        node.setProperty("1", (Object)1);
        node.setProperty("2", (Object)2);
        node.setProperty("3", (Object)3);
        this.newTransaction();
        node.removeProperty("2");
        this.newTransaction();
        Assert.assertNull((Object)node.getProperty("2", null));
    }

    @Test
    public void testLongPropertyValues() throws Exception {
        Node n = this.getGraphDb().createNode();
        this.setPropertyAndAssertIt(n, -134217728L);
        this.setPropertyAndAssertIt(n, -134217729L);
    }

    @Test
    public void testIntPropertyValues() throws Exception {
        Node n = this.getGraphDb().createNode();
        this.setPropertyAndAssertIt(n, -134217728);
        this.setPropertyAndAssertIt(n, -134217729);
    }

    @Test
    public void booleanRange() throws Exception {
        Node node = this.getGraphDb().createNode();
        this.setPropertyAndAssertIt(node, false);
        this.setPropertyAndAssertIt(node, true);
    }

    @Test
    public void byteRange() throws Exception {
        Node node = this.getGraphDb().createNode();
        for (byte i = -128; i < 127; i = (byte)(i + 1)) {
            this.setPropertyAndAssertIt(node, i);
        }
    }

    @Test
    public void charRange() throws Exception {
        Node node = this.getGraphDb().createNode();
        for (char i = '\u0000'; i < '\uffff'; i = (char)(i + '\u0001')) {
            this.setPropertyAndAssertIt(node, Character.valueOf(i));
        }
    }

    @Test
    public void shortRange() throws Exception {
        Node node = this.getGraphDb().createNode();
        for (short i = Short.MIN_VALUE; i < Short.MAX_VALUE; i = (short)(i + 1)) {
            this.setPropertyAndAssertIt(node, i);
        }
    }

    @Test
    public void intRange() throws Exception {
        int step = 30001;
        Node node = this.getGraphDb().createNode();
        for (int i = Integer.MIN_VALUE; i < Integer.MAX_VALUE - step; i += step) {
            this.setPropertyAndAssertIt(node, i);
        }
    }

    @Test
    public void longRange() throws Exception {
        long step = 120000000000001L;
        Node node = this.getGraphDb().createNode();
        for (long i = Long.MIN_VALUE; i < Long.MAX_VALUE - step; i += step) {
            this.setPropertyAndAssertIt(node, i);
        }
    }

    @Test
    public void floatRange() throws Exception {
        float step = 1.2345679E33f;
        Node node = this.getGraphDb().createNode();
        for (float i = Float.MIN_VALUE; i < Float.MAX_VALUE - step; i += step) {
            this.setPropertyAndAssertIt(node, Float.valueOf(i));
        }
    }

    @Test
    public void doubleRange() throws Exception {
        double step = 12.345;
        Node node = this.getGraphDb().createNode();
        double i = Double.MIN_VALUE;
        while (i < Double.MAX_VALUE) {
            this.setPropertyAndAssertIt(node, i);
            i += step;
            step *= 1.004;
        }
    }

    private void setPropertyAndAssertIt(Node node, Object value) {
        node.setProperty("key", value);
        Assert.assertEquals((Object)value, (Object)node.getProperty("key"));
    }
}

