/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.EmbeddedReadOnlyGraphDatabase;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.test.DbRepresentation;

public class TestReadOnlyNeo4j {
    private static final String PATH = AbstractNeo4jTestCase.getStorePath("read-only");

    @BeforeClass
    public static void doBefore() {
        AbstractNeo4jTestCase.deleteFileOrDirectory(PATH);
    }

    @Test
    public void testSimple() {
        DbRepresentation someData = this.createSomeData();
        EmbeddedReadOnlyGraphDatabase readGraphDb = new EmbeddedReadOnlyGraphDatabase(PATH);
        Assert.assertEquals((Object)someData, (Object)DbRepresentation.of((GraphDatabaseService)readGraphDb));
        Transaction tx = readGraphDb.beginTx();
        try {
            readGraphDb.createNode();
        }
        catch (ReadOnlyDbException e) {
            // empty catch block
        }
        tx.finish();
        readGraphDb.shutdown();
    }

    private DbRepresentation createSomeData() {
        DynamicRelationshipType type = DynamicRelationshipType.withName((String)"KNOWS");
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(PATH);
        Transaction tx = db.beginTx();
        Node prevNode = db.getReferenceNode();
        for (int i = 0; i < 100; ++i) {
            Node node = db.createNode();
            Relationship rel = prevNode.createRelationshipTo(node, (RelationshipType)type);
            node.setProperty("someKey" + i % 10, (Object)(i % 15));
            rel.setProperty("since", (Object)System.currentTimeMillis());
        }
        tx.success();
        tx.finish();
        DbRepresentation result = DbRepresentation.of((GraphDatabaseService)db);
        db.shutdown();
        return result;
    }

    @Test
    public void testReadOnlyOperationsAndNoTransaction() {
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(PATH);
        Transaction tx = db.beginTx();
        Node node1 = db.createNode();
        Node node2 = db.createNode();
        Relationship rel = node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"TEST"));
        node1.setProperty("key1", (Object)"value1");
        rel.setProperty("key1", (Object)"value1");
        tx.success();
        tx.finish();
        try {
            db.createNode();
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"TEST2"));
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            node1.setProperty("key1", (Object)"value2");
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        try {
            rel.removeProperty("key1");
            Assert.fail((String)"Write operation and no transaction should throw exception");
        }
        catch (NotInTransactionException e) {
            // empty catch block
        }
        ((AbstractGraphDatabase)db).getConfig().getGraphDbModule().getNodeManager().clearCache();
        Assert.assertEquals((Object)node1, (Object)db.getNodeById(node1.getId()));
        Assert.assertEquals((Object)node2, (Object)db.getNodeById(node2.getId()));
        Assert.assertEquals((Object)rel, (Object)db.getRelationshipById(rel.getId()));
        ((AbstractGraphDatabase)db).getConfig().getGraphDbModule().getNodeManager().clearCache();
        Assert.assertEquals((Object)"value1", (Object)node1.getProperty("key1"));
        Relationship loadedRel = node1.getSingleRelationship((RelationshipType)DynamicRelationshipType.withName((String)"TEST"), Direction.OUTGOING);
        Assert.assertEquals((Object)rel, (Object)loadedRel);
        Assert.assertEquals((Object)"value1", (Object)loadedRel.getProperty("key1"));
        db.shutdown();
    }
}

