/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.util.FileUtils;

public class TestShutdownSequence {
    private EmbeddedGraphDatabase graphDb;

    @BeforeClass
    public static void deleteDb() throws Exception {
        FileUtils.deleteRecursively((File)new File(AbstractNeo4jTestCase.getStorePath("shutdown")));
    }

    @Before
    public void createGraphDb() {
        this.graphDb = new EmbeddedGraphDatabase(AbstractNeo4jTestCase.getStorePath("shutdown"));
    }

    @Test
    public void canInvokeShutdownMultipleTimes() {
        this.graphDb.shutdown();
        this.graphDb.shutdown();
    }

    @Test
    public void eventHandlersAreOnlyInvokedOnceDuringShutdown() {
        final AtomicInteger counter = new AtomicInteger();
        this.graphDb.registerKernelEventHandler(new KernelEventHandler(){

            public void beforeShutdown() {
                counter.incrementAndGet();
            }

            public Object getResource() {
                return null;
            }

            public void kernelPanic(ErrorState error) {
            }

            public KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
                return KernelEventHandler.ExecutionOrder.DOESNT_MATTER;
            }
        });
        this.graphDb.shutdown();
        this.graphDb.shutdown();
        Assert.assertEquals((long)1L, (long)counter.get());
    }

    @Test
    public void canRemoveFilesAndReinvokeShutdown() {
        this.graphDb.shutdown();
        AbstractNeo4jTestCase.deleteFileOrDirectory(new File(AbstractNeo4jTestCase.getStorePath("shutdown")));
        this.graphDb.shutdown();
    }

    @Test
    public void canInvokeShutdownFromShutdownHandler() {
        this.graphDb.registerKernelEventHandler(new KernelEventHandler(){

            public void beforeShutdown() {
                TestShutdownSequence.this.graphDb.shutdown();
            }

            public Object getResource() {
                return null;
            }

            public void kernelPanic(ErrorState error) {
            }

            public KernelEventHandler.ExecutionOrder orderComparedTo(KernelEventHandler other) {
                return KernelEventHandler.ExecutionOrder.DOESNT_MATTER;
            }
        });
        this.graphDb.shutdown();
    }
}

