/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicArrayStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.util.StringLogger;

public class TestDynamicStore {
    public static IdGeneratorFactory ID_GENERATOR_FACTORY = CommonFactories.defaultIdGeneratorFactory();
    public static FileSystemAbstraction FILE_SYSTEM = CommonFactories.defaultFileSystemAbstraction();

    private String path() {
        String path = AbstractNeo4jTestCase.getStorePath("dynamicstore");
        new File(path).mkdirs();
        return path;
    }

    private String file(String name) {
        return this.path() + File.separator + name;
    }

    private String dynamicStoreFile() {
        return this.file("testDynamicStore.db");
    }

    private String dynamicStoreIdFile() {
        return this.file("testDynamicStore.db.id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateStore() {
        try {
            try {
                this.createEmptyStore(null, 1);
                Assert.fail((String)"Null fileName should throw exception");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                this.createEmptyStore(this.dynamicStoreFile(), 0);
                Assert.fail((String)"Illegal blocksize should throw exception");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            this.createEmptyStore(this.dynamicStoreFile(), 15);
            try {
                this.createEmptyStore(this.dynamicStoreFile(), 15);
                Assert.fail((String)"Creating existing store should throw exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        finally {
            this.deleteBothFiles();
        }
    }

    private void createEmptyStore(String fileName, int blockSize) {
        DynamicArrayStore.createEmptyStore((String)fileName, (int)blockSize, (String)"ArrayPropertyStore v0.A.0", (IdGeneratorFactory)ID_GENERATOR_FACTORY, (FileSystemAbstraction)FILE_SYSTEM, (IdType)IdType.ARRAY_BLOCK);
    }

    private DynamicArrayStore newStore() {
        return new DynamicArrayStore(this.dynamicStoreFile(), this.config(), IdType.ARRAY_BLOCK);
    }

    private void deleteBothFiles() {
        File file = new File(this.dynamicStoreFile());
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        if ((file = new File(this.dynamicStoreIdFile())).exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStickyStore() throws IOException {
        Logger log = Logger.getLogger(CommonAbstractStore.class.getName());
        Level level = log.getLevel();
        try {
            log.setLevel(Level.OFF);
            this.createEmptyStore(this.dynamicStoreFile(), 30);
            FileChannel fileChannel = new RandomAccessFile(this.dynamicStoreFile(), "rw").getChannel();
            fileChannel.truncate(fileChannel.size() - 2L);
            fileChannel.close();
            DynamicArrayStore store = this.newStore();
            store.makeStoreOk();
            store.close();
        }
        finally {
            log.setLevel(level);
            this.deleteBothFiles();
        }
    }

    private Map<?, ?> config() {
        return MapUtil.map((Object[])new Object[]{"neo_store", this.dynamicStoreFile(), IdGeneratorFactory.class, ID_GENERATOR_FACTORY, StringLogger.class, StringLogger.DEV_NULL, "store_dir", this.path(), FileSystemAbstraction.class, CommonFactories.defaultFileSystemAbstraction()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClose() {
        try {
            this.createEmptyStore(this.dynamicStoreFile(), 30);
            DynamicArrayStore store = this.newStore();
            long blockId = store.nextBlockId();
            Collection records = store.allocateRecords(blockId, new byte[10]);
            for (DynamicRecord record : records) {
                store.updateRecord(record);
            }
            store.close();
            try {
                PropertyStore.getArrayFor((long)blockId, (Iterable)store.getRecords(blockId), (DynamicArrayStore)store);
                Assert.fail((String)"Closed store should throw exception");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            try {
                store.getLightRecords(0L);
                Assert.fail((String)"Closed store should throw exception");
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        finally {
            this.deleteBothFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStoreGetCharsFromString() {
        try {
            String STR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            this.createEmptyStore(this.dynamicStoreFile(), 30);
            DynamicArrayStore store = this.newStore();
            long blockId = store.nextBlockId();
            char[] chars = new char["abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length()];
            "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getChars(0, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length(), chars, 0);
            Collection records = store.allocateRecords(blockId, (Object)chars);
            for (DynamicRecord record : records) {
                store.updateRecord(record);
            }
            store.close();
        }
        finally {
            this.deleteBothFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomTest() {
        Random random = new Random(System.currentTimeMillis());
        this.createEmptyStore(this.dynamicStoreFile(), 30);
        DynamicArrayStore store = this.newStore();
        ArrayList<Long> idsTaken = new ArrayList<Long>();
        HashMap<Long, byte[]> byteData = new HashMap<Long, byte[]>();
        float deleteIndex = 0.2f;
        float closeIndex = 0.1f;
        int currentCount = 0;
        int maxCount = 128;
        HashSet<Long> set = new HashSet<Long>();
        try {
            while (currentCount < maxCount) {
                Collection records;
                float rIndex = random.nextFloat();
                if (rIndex < deleteIndex && currentCount > 0) {
                    long blockId = (Long)idsTaken.remove(random.nextInt(currentCount));
                    store.getLightRecords(blockId);
                    byte[] bytes = (byte[])PropertyStore.getArrayFor((long)blockId, (Iterable)store.getRecords(blockId), (DynamicArrayStore)store);
                    this.validateData(bytes, (byte[])byteData.remove(blockId));
                    records = store.getLightRecords(blockId);
                    for (DynamicRecord record : records) {
                        record.setInUse(false);
                        store.updateRecord(record);
                        set.remove(record.getId());
                    }
                    --currentCount;
                } else {
                    byte[] bytes = this.createRandomBytes(random);
                    long blockId = store.nextBlockId();
                    records = store.allocateRecords(blockId, (Object)bytes);
                    for (DynamicRecord record : records) {
                        assert (!set.contains(record.getId()));
                        store.updateRecord(record);
                        set.add(record.getId());
                    }
                    idsTaken.add(blockId);
                    byteData.put(blockId, bytes);
                    ++currentCount;
                }
                if (!(rIndex > 1.0f - closeIndex) && !(rIndex < closeIndex)) continue;
                store.close();
                store = this.newStore();
            }
        }
        finally {
            store.close();
            this.deleteBothFiles();
        }
    }

    private byte[] createBytes(int length) {
        return new byte[length];
    }

    private byte[] createRandomBytes(Random r) {
        return new byte[r.nextInt(1024)];
    }

    private void validateData(byte[] data1, byte[] data2) {
        Assert.assertEquals((long)data1.length, (long)data2.length);
        for (int i = 0; i < data1.length; ++i) {
            Assert.assertEquals((long)data1[i], (long)data2[i]);
        }
    }

    private long create(DynamicArrayStore store, Object arrayToStore) {
        long blockId = store.nextBlockId();
        Collection records = store.allocateRecords(blockId, arrayToStore);
        for (DynamicRecord record : records) {
            store.updateRecord(record);
        }
        return blockId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddDeleteSequenceEmptyNumberArray() {
        this.createEmptyStore(this.dynamicStoreFile(), 30);
        DynamicArrayStore store = this.newStore();
        try {
            byte[] emptyToWrite = this.createBytes(0);
            long blockId = this.create(store, emptyToWrite);
            store.getLightRecords(blockId);
            byte[] bytes = (byte[])PropertyStore.getArrayFor((long)blockId, (Iterable)store.getRecords(blockId), (DynamicArrayStore)store);
            Assert.assertEquals((long)0L, (long)bytes.length);
            Collection records = store.getLightRecords(blockId);
            for (DynamicRecord record : records) {
                record.setInUse(false);
                store.updateRecord(record);
            }
        }
        finally {
            store.close();
            this.deleteBothFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddDeleteSequenceEmptyStringArray() {
        this.createEmptyStore(this.dynamicStoreFile(), 30);
        DynamicArrayStore store = this.newStore();
        try {
            long blockId = this.create(store, new String[0]);
            store.getLightRecords(blockId);
            String[] readBack = (String[])PropertyStore.getArrayFor((long)blockId, (Iterable)store.getRecords(blockId), (DynamicArrayStore)store);
            Assert.assertEquals((long)0L, (long)readBack.length);
            Collection records = store.getLightRecords(blockId);
            for (DynamicRecord record : records) {
                record.setInUse(false);
                store.updateRecord(record);
            }
        }
        finally {
            store.close();
            this.deleteBothFiles();
        }
    }
}

