/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.ProduceUncleanStore;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TargetDirectory;

public class TestGraphProperties {
    private AbstractGraphDatabase db;
    private Transaction tx;

    @Before
    public void doBefore() throws Exception {
        this.db = new ImpermanentGraphDatabase();
    }

    @After
    public void doAfter() throws Exception {
        this.db.shutdown();
    }

    @Test
    public void basicProperties() throws Exception {
        Assert.assertNull((Object)this.properties().getProperty("test", null));
        this.beginTx();
        this.properties().setProperty("test", (Object)"yo");
        Assert.assertEquals((Object)"yo", (Object)this.properties().getProperty("test"));
        this.finishTx(true);
        Assert.assertEquals((Object)"yo", (Object)this.properties().getProperty("test"));
        this.beginTx();
        Assert.assertNull((Object)this.properties().removeProperty("something non existent"));
        Assert.assertEquals((Object)"yo", (Object)this.properties().removeProperty("test"));
        Assert.assertNull((Object)this.properties().getProperty("test", null));
        this.properties().setProperty("other", (Object)10);
        Assert.assertEquals((Object)10, (Object)this.properties().getProperty("other"));
        this.properties().setProperty("new", (Object)"third");
        this.finishTx(true);
        Assert.assertNull((Object)this.properties().getProperty("test", null));
        Assert.assertEquals((Object)10, (Object)this.properties().getProperty("other"));
        Assert.assertEquals(this.asSet(IteratorUtil.asCollection((Iterable)this.properties().getPropertyKeys())), this.asSet(Arrays.asList("other", "new")));
        this.beginTx();
        this.properties().setProperty("rollback", (Object)true);
        Assert.assertEquals((Object)true, (Object)this.properties().getProperty("rollback"));
        this.finishTx(false);
        Assert.assertNull((Object)this.properties().getProperty("rollback", null));
    }

    @Test
    public void setManyGraphProperties() throws Exception {
        int i;
        this.beginTx();
        Object[] values = new Object[]{10, "A string value", new float[]{1234.567f, 7654.321f}, "A rather longer string which wouldn't fit inlined #!)(&\u00a4"};
        int count = 200;
        for (i = 0; i < count; ++i) {
            this.properties().setProperty("key" + i, values[i % values.length]);
        }
        this.finishTx(true);
        for (i = 0; i < count; ++i) {
            this.assertPropertyEquals(values[i % values.length], this.properties().getProperty("key" + i));
        }
        this.db.getConfig().getGraphDbModule().getNodeManager().clearCache();
        for (i = 0; i < count; ++i) {
            this.assertPropertyEquals(values[i % values.length], this.properties().getProperty("key" + i));
        }
    }

    private void assertPropertyEquals(Object expected, Object readValue) {
        if (expected.getClass().isArray()) {
            Assert.assertEquals((Object)IoPrimitiveUtils.arrayAsCollection((Object)expected), (Object)IoPrimitiveUtils.arrayAsCollection((Object)readValue));
        } else {
            Assert.assertEquals((Object)expected, (Object)readValue);
        }
    }

    @Test
    public void setBigArrayGraphProperty() throws Exception {
        long[] array = new long[1000];
        for (int i = 0; i < 10; ++i) {
            array[array.length / 10 * i] = i;
        }
        String key = "big long array";
        this.beginTx();
        this.properties().setProperty(key, (Object)array);
        this.assertPropertyEquals(array, this.properties().getProperty(key));
        this.finishTx(true);
        this.assertPropertyEquals(array, this.properties().getProperty(key));
        this.db.getConfig().getGraphDbModule().getNodeManager().clearCache();
        this.assertPropertyEquals(array, this.properties().getProperty(key));
    }

    private <T> Set<T> asSet(Collection<T> asCollection) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(asCollection);
        return set;
    }

    private void finishTx(boolean success) {
        if (this.tx == null) {
            throw new IllegalStateException("Transaction not started");
        }
        if (success) {
            this.tx.success();
        }
        this.tx.finish();
        this.tx = null;
    }

    private void beginTx() {
        if (this.tx != null) {
            throw new IllegalStateException("Transaction already started");
        }
        this.tx = this.db.beginTx();
    }

    private PropertyContainer properties() {
        return this.db.getConfig().getGraphDbModule().getNodeManager().getGraphProperties();
    }

    @Test
    public void firstRecordOtherThanZeroIfNotFirst() throws Exception {
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(TargetDirectory.forTest(this.getClass()).directory("zero", true).getAbsolutePath());
        String storeDir = db.getStoreDir();
        Transaction tx = db.beginTx();
        Node node = db.createNode();
        node.setProperty("name", (Object)"Yo");
        tx.success();
        tx.finish();
        db.shutdown();
        db = new EmbeddedGraphDatabase(TargetDirectory.forTest(this.getClass()).directory("zero", false).getAbsolutePath());
        tx = db.beginTx();
        db.getConfig().getGraphDbModule().getNodeManager().getGraphProperties().setProperty("test", (Object)"something");
        tx.success();
        tx.finish();
        db.shutdown();
        NeoStore neoStore = new NeoStore(MapUtil.genericMap((Object[])new Object[]{FileSystemAbstraction.class, CommonFactories.defaultFileSystemAbstraction(), "neo_store", new File(storeDir, "neostore").getAbsolutePath(), IdGeneratorFactory.class, CommonFactories.defaultIdGeneratorFactory()}));
        long prop = neoStore.getGraphNextProp();
        Assert.assertTrue((prop != 0L ? 1 : 0) != 0);
        neoStore.close();
    }

    @Test
    public void graphPropertiesAreLockedPerTx() throws Exception {
        Worker worker1 = new Worker(new State(this.db));
        Worker worker2 = new Worker(new State(this.db));
        GraphProperties properties = TestGraphProperties.getGraphProperties(this.db);
        worker1.beginTx();
        worker2.beginTx();
        String key1 = "name";
        String value1 = "Value 1";
        String key2 = "some other property";
        String value2 = "Value 2";
        String key3 = "say";
        String value3 = "hello";
        worker1.setProperty(key1, value1).get();
        Assert.assertFalse((boolean)properties.hasProperty(key1));
        Assert.assertFalse((boolean)worker2.hasProperty(key1));
        Future<Void> blockedSetProperty = worker2.setProperty(key2, value2);
        Assert.assertFalse((boolean)properties.hasProperty(key1));
        Assert.assertFalse((boolean)properties.hasProperty(key2));
        worker1.setProperty(key3, value3).get();
        Assert.assertFalse((boolean)blockedSetProperty.isDone());
        Assert.assertFalse((boolean)properties.hasProperty(key1));
        Assert.assertFalse((boolean)properties.hasProperty(key2));
        Assert.assertFalse((boolean)properties.hasProperty(key3));
        worker1.commitTx();
        Assert.assertTrue((boolean)properties.hasProperty(key1));
        Assert.assertFalse((boolean)properties.hasProperty(key2));
        Assert.assertTrue((boolean)properties.hasProperty(key3));
        blockedSetProperty.get();
        Assert.assertTrue((boolean)blockedSetProperty.isDone());
        worker2.commitTx();
        Assert.assertTrue((boolean)properties.hasProperty(key1));
        Assert.assertTrue((boolean)properties.hasProperty(key2));
        Assert.assertTrue((boolean)properties.hasProperty(key3));
        Assert.assertEquals((Object)value1, (Object)properties.getProperty(key1));
        Assert.assertEquals((Object)value3, (Object)properties.getProperty(key3));
        Assert.assertEquals((Object)value2, (Object)properties.getProperty(key2));
    }

    @Test
    public void upgradeDoesntAccidentallyAssignPropertyChainZero() throws Exception {
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(TargetDirectory.forTest(TestGraphProperties.class).directory("upgrade", true).getAbsolutePath());
        String storeDir = db.getStoreDir();
        Transaction tx = db.beginTx();
        Node node = db.createNode();
        node.setProperty("name", (Object)"Something");
        tx.success();
        tx.finish();
        db.shutdown();
        this.removeLastNeoStoreRecord(storeDir);
        db = new EmbeddedGraphDatabase(storeDir);
        GraphProperties properties = db.getConfig().getGraphDbModule().getNodeManager().getGraphProperties();
        Assert.assertFalse((boolean)properties.getPropertyKeys().iterator().hasNext());
        tx = db.beginTx();
        properties.setProperty("a property", (Object)"a value");
        tx.success();
        tx.finish();
        db.getConfig().getGraphDbModule().getNodeManager().clearCache();
        Assert.assertEquals((Object)"a value", (Object)properties.getProperty("a property"));
        db.shutdown();
        db = new EmbeddedGraphDatabase(storeDir);
        properties = db.getConfig().getGraphDbModule().getNodeManager().getGraphProperties();
        Assert.assertEquals((Object)"a value", (Object)properties.getProperty("a property"));
        db.shutdown();
    }

    private void removeLastNeoStoreRecord(String storeDir) throws IOException {
        File neoStoreFile = new File(storeDir, "neostore");
        RandomAccessFile raFile = new RandomAccessFile(neoStoreFile, "rw");
        FileChannel channel = raFile.getChannel();
        channel.position(54L);
        int trail = (int)(channel.size() - channel.position());
        ByteBuffer trailBuffer = null;
        if (trail > 0) {
            trailBuffer = ByteBuffer.allocate(trail);
            channel.read(trailBuffer);
            trailBuffer.flip();
        }
        channel.position(45L);
        if (trail > 0) {
            channel.write(trailBuffer);
        }
        channel.truncate(channel.position());
        raFile.close();
    }

    @Test
    public void upgradeWorksEvenOnUncleanShutdown() throws Exception {
        String storeDir = TargetDirectory.forTest(TestGraphProperties.class).directory("nonclean", true).getAbsolutePath();
        Assert.assertEquals((long)0L, (long)Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), ProduceUncleanStore.class.getName(), storeDir}).waitFor());
        this.removeLastNeoStoreRecord(storeDir);
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(storeDir);
        GraphProperties properties = db.getConfig().getGraphDbModule().getNodeManager().getGraphProperties();
        Assert.assertFalse((boolean)properties.getPropertyKeys().iterator().hasNext());
        Transaction tx = db.beginTx();
        properties.setProperty("a property", (Object)"a value");
        tx.success();
        tx.finish();
        db.getConfig().getGraphDbModule().getNodeManager().clearCache();
        Assert.assertEquals((Object)"a value", (Object)properties.getProperty("a property"));
        db.shutdown();
    }

    @Test
    public void twoUncleanInARow() throws Exception {
        String storeDir = TargetDirectory.forTest(TestGraphProperties.class).directory("nonclean", true).getAbsolutePath();
        Assert.assertEquals((long)0L, (long)Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), ProduceUncleanStore.class.getName(), storeDir, "true"}).waitFor());
        Assert.assertEquals((long)0L, (long)Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), ProduceUncleanStore.class.getName(), storeDir, "true"}).waitFor());
        Assert.assertEquals((long)0L, (long)Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), ProduceUncleanStore.class.getName(), storeDir, "true"}).waitFor());
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(storeDir);
        Assert.assertEquals((Object)"Some value", (Object)db.getConfig().getGraphDbModule().getNodeManager().getGraphProperties().getProperty("prop"));
        db.shutdown();
    }

    private static GraphProperties getGraphProperties(AbstractGraphDatabase db) {
        return db.getConfig().getGraphDbModule().getNodeManager().getGraphProperties();
    }

    private static class Worker
    extends OtherThreadExecutor<State> {
        public Worker(State initialState) {
            super(initialState);
        }

        public boolean hasProperty(final String key) throws Exception {
            return this.execute(new OtherThreadExecutor.WorkerCommand<State, Boolean>(){

                @Override
                public Boolean doWork(State state) {
                    return state.properties.hasProperty(key);
                }
            });
        }

        public void commitTx() throws Exception {
            this.execute(new OtherThreadExecutor.WorkerCommand<State, Void>(){

                @Override
                public Void doWork(State state) {
                    state.tx.success();
                    state.tx.finish();
                    return null;
                }
            });
        }

        void beginTx() throws Exception {
            this.execute(new OtherThreadExecutor.WorkerCommand<State, Void>(){

                @Override
                public Void doWork(State state) {
                    state.tx = state.db.beginTx();
                    return null;
                }
            });
        }

        Future<Void> setProperty(final String key, final Object value) throws Exception {
            return this.executeDontWait(new OtherThreadExecutor.WorkerCommand<State, Void>(){

                @Override
                public Void doWork(State state) {
                    state.properties.setProperty(key, value);
                    return null;
                }
            });
        }
    }

    private static class State {
        private final AbstractGraphDatabase db;
        private final PropertyContainer properties;
        private Transaction tx;

        State(AbstractGraphDatabase db) {
            this.db = db;
            this.properties = TestGraphProperties.getGraphProperties(db);
        }
    }
}

