/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.lang.reflect.Array;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.ShortArray;

public class TestShortArray {
    private static final int DEFAULT_PAYLOAD_SIZE = PropertyType.getPayloadSize();

    @Test
    public void canEncodeSomeSampleArraysWithDefaultPayloadSize() throws Exception {
        this.assertCanEncodeAndDecodeToSameValue(new boolean[]{true, false, true, true, true, true, true, true, true, true, false, true});
        this.assertCanEncodeAndDecodeToSameValue(new byte[]{-1, -10, 43, 127, 0, 4, 2, 3, 56, 47, 67, 43});
        this.assertCanEncodeAndDecodeToSameValue(new short[]{1, 2, 3, 45, 5, 6, 7});
        this.assertCanEncodeAndDecodeToSameValue(new int[]{1, 2, 3, 4, 5, 6, 7});
        this.assertCanEncodeAndDecodeToSameValue(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L});
        this.assertCanEncodeAndDecodeToSameValue(new float[]{0.34f, 0.21f});
        this.assertCanEncodeAndDecodeToSameValue(new long[]{Integer.MIN_VALUE, Integer.MIN_VALUE});
        this.assertCanEncodeAndDecodeToSameValue(new long[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE});
        this.assertCanEncodeAndDecodeToSameValue(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        this.assertCanEncodeAndDecodeToSameValue(new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L});
    }

    @Test
    public void testCannotEncodeMarginal() throws Exception {
        this.assertCanNotEncode(new long[]{32768L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L});
    }

    @Test
    public void canEncodeBiggerArraysWithBiggerPayloadSize() throws Exception {
        int[] intArray = this.intArray(10, 2600);
        this.assertCanEncodeAndDecodeToSameValue(intArray, 32);
    }

    private void assertCanNotEncode(Object intArray) {
        this.assertCanNotEncode(intArray, DEFAULT_PAYLOAD_SIZE);
    }

    private void assertCanNotEncode(Object intArray, int payloadSize) {
        Assert.assertFalse((boolean)ShortArray.encode((int)0, (Object)intArray, (PropertyBlock)new PropertyBlock(), (int)payloadSize));
    }

    private int[] intArray(int count, int stride) {
        int[] result = new int[count];
        for (int i = 0; i < count; ++i) {
            result[i] = i * stride;
        }
        return result;
    }

    private void assertCanEncodeAndDecodeToSameValue(Object value) {
        this.assertCanEncodeAndDecodeToSameValue(value, PropertyType.getPayloadSize());
    }

    private void assertCanEncodeAndDecodeToSameValue(Object value, int payloadSize) {
        PropertyBlock target = new PropertyBlock();
        boolean encoded = ShortArray.encode((int)0, (Object)value, (PropertyBlock)target, (int)payloadSize);
        Assert.assertTrue((boolean)encoded);
        this.assertArraysEquals(value, ShortArray.decode((PropertyBlock)target));
    }

    private void assertArraysEquals(Object value1, Object value2) {
        Assert.assertEquals(value1.getClass().getComponentType(), value2.getClass().getComponentType());
        int length1 = Array.getLength(value1);
        int length2 = Array.getLength(value2);
        Assert.assertEquals((long)length1, (long)length2);
        for (int i = 0; i < length1; ++i) {
            Object item1 = Array.get(value1, i);
            Object item2 = Array.get(value2, i);
            Assert.assertEquals((Object)item1, (Object)item2);
        }
    }
}

