/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.Random;
import java.util.Stack;
import javax.transaction.TransactionManager;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.PlaceboTm;

public class TestRWLock {
    private LockManager lm = new LockManager((TransactionManager)new PlaceboTm());
    private static boolean go = false;

    @Test
    public void testSingleThread() throws Exception {
        int i;
        try {
            this.lm.getReadLock(null);
            Assert.fail((String)"Null parameter should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.lm.getWriteLock(null);
            Assert.fail((String)"Null parameter should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.lm.releaseReadLock(null, null);
            Assert.fail((String)"Null parameter should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.lm.releaseWriteLock(null, null);
            Assert.fail((String)"Null parameter should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        Object entity = new Object();
        try {
            this.lm.releaseWriteLock(entity, null);
            Assert.fail((String)"Invalid release should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.lm.releaseReadLock(entity, null);
            Assert.fail((String)"Invalid release should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.lm.getReadLock(entity);
        try {
            this.lm.releaseWriteLock(entity, null);
            Assert.fail((String)"Invalid release should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.lm.releaseReadLock(entity, null);
        this.lm.getWriteLock(entity);
        try {
            this.lm.releaseReadLock(entity, null);
            Assert.fail((String)"Invalid release should throw exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.lm.releaseWriteLock(entity, null);
        this.lm.getReadLock(entity);
        this.lm.getWriteLock(entity);
        this.lm.releaseWriteLock(entity, null);
        this.lm.releaseReadLock(entity, null);
        this.lm.getWriteLock(entity);
        this.lm.getReadLock(entity);
        this.lm.releaseReadLock(entity, null);
        this.lm.releaseWriteLock(entity, null);
        for (i = 0; i < 10; ++i) {
            if (i % 2 == 0) {
                this.lm.getWriteLock(entity);
                continue;
            }
            this.lm.getReadLock(entity);
        }
        for (i = 9; i >= 0; --i) {
            if (i % 2 == 0) {
                this.lm.releaseWriteLock(entity, null);
                continue;
            }
            this.lm.releaseReadLock(entity, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleThreads() {
        HelperThread t1 = new HelperThread("T1");
        HelperThread t2 = new HelperThread("T2");
        HelperThread t3 = new HelperThread("T3");
        HelperThread t4 = new HelperThread("T4");
        ResourceObject r1 = new ResourceObject("R1");
        try {
            t1.start();
            t2.start();
            t3.start();
            t4.start();
            t1.getReadLock(r1);
            t1.waitForCompletionOfTask();
            t2.getReadLock(r1);
            t2.waitForCompletionOfTask();
            t3.getReadLock(r1);
            t3.waitForCompletionOfTask();
            t4.getWriteLock(r1);
            t3.releaseReadLock(r1);
            t3.waitForCompletionOfTask();
            t2.releaseReadLock(r1);
            t2.waitForCompletionOfTask();
            Assert.assertTrue((!t4.isTaskCompleted() ? 1 : 0) != 0);
            t1.releaseReadLock(r1);
            t1.waitForCompletionOfTask();
            t4.waitForCompletionOfTask();
            t4.getReadLock(r1);
            t4.waitForCompletionOfTask();
            t4.getReadLock(r1);
            t4.waitForCompletionOfTask();
            t1.getReadLock(r1);
            t4.getReadLock(r1);
            t4.waitForCompletionOfTask();
            t4.releaseReadLock(r1);
            t4.waitForCompletionOfTask();
            t4.getWriteLock(r1);
            t4.waitForCompletionOfTask();
            t4.releaseWriteLock(r1);
            t4.waitForCompletionOfTask();
            Assert.assertTrue((!t1.isTaskCompleted() ? 1 : 0) != 0);
            t4.releaseWriteLock(r1);
            t4.waitForCompletionOfTask();
            t1.waitForCompletionOfTask();
            t4.releaseReadLock(r1);
            t4.waitForCompletionOfTask();
            t4.getWriteLock(r1);
            t1.releaseReadLock(r1);
            t1.waitForCompletionOfTask();
            t4.waitForCompletionOfTask();
            t4.releaseReadLock(r1);
            t4.waitForCompletionOfTask();
            t4.releaseWriteLock(r1);
            t4.waitForCompletionOfTask();
            t4.getWriteLock(r1);
            t4.waitForCompletionOfTask();
            t1.getReadLock(r1);
            t2.getReadLock(r1);
            t3.getReadLock(r1);
            t4.getReadLock(r1);
            t4.waitForCompletionOfTask();
            t4.releaseWriteLock(r1);
            t4.waitForCompletionOfTask();
            t1.waitForCompletionOfTask();
            t2.waitForCompletionOfTask();
            t3.waitForCompletionOfTask();
            t1.getWriteLock(r1);
            t2.releaseReadLock(r1);
            t2.waitForCompletionOfTask();
            t4.releaseReadLock(r1);
            t4.waitForCompletionOfTask();
            t3.releaseReadLock(r1);
            t3.waitForCompletionOfTask();
            t1.waitForCompletionOfTask();
            t1.releaseWriteLock(r1);
            t1.waitForCompletionOfTask();
            t2.getReadLock(r1);
            t2.waitForCompletionOfTask();
            t1.releaseReadLock(r1);
            t1.waitForCompletionOfTask();
            t2.getWriteLock(r1);
            t2.waitForCompletionOfTask();
            t2.releaseWriteLock(r1);
            t2.waitForCompletionOfTask();
            t2.releaseReadLock(r1);
            t2.waitForCompletionOfTask();
        }
        catch (Exception e) {
            this.lm.dumpLocksOnResource((Object)r1);
            e.printStackTrace();
            Assert.fail((String)("Multiple thread rw lock test failed, " + e));
        }
        finally {
            t1.quit();
            t2.quit();
            t3.quit();
            t4.quit();
        }
    }

    @Test
    public void testStressMultipleThreads() {
        int i;
        ResourceObject r1 = new ResourceObject("R1");
        Thread[] stressThreads = new Thread[100];
        go = false;
        for (i = 0; i < 100; ++i) {
            stressThreads[i] = new StressThread("Thread" + i, 100, 9, 0.5f, r1);
        }
        for (i = 0; i < 100; ++i) {
            stressThreads[i].start();
        }
        go = true;
    }

    public class StressThread
    extends Thread {
        private Random rand = new Random(System.currentTimeMillis());
        private final Object READ = new Object();
        private final Object WRITE = new Object();
        private String name;
        private int numberOfIterations;
        private int depthCount;
        private float readWriteRatio;
        private Object resource;

        StressThread(String name, int numberOfIterations, int depthCount, float readWriteRatio, Object resource) {
            this.name = name;
            this.numberOfIterations = numberOfIterations;
            this.depthCount = depthCount;
            this.readWriteRatio = readWriteRatio;
            this.resource = resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!go) {
                    try {
                        StressThread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                }
                Stack<Object> lockStack = new Stack<Object>();
                try {
                    for (int i = 0; i < this.numberOfIterations; ++i) {
                        int depth = this.depthCount;
                        do {
                            float f;
                            if ((f = this.rand.nextFloat()) < this.readWriteRatio) {
                                TestRWLock.this.lm.getReadLock(this.resource);
                                lockStack.push(this.READ);
                                continue;
                            }
                            TestRWLock.this.lm.getWriteLock(this.resource);
                            lockStack.push(this.WRITE);
                        } while (--depth > 0);
                        while (!lockStack.isEmpty()) {
                            if (lockStack.pop() == this.READ) {
                                TestRWLock.this.lm.releaseReadLock(this.resource, null);
                                continue;
                            }
                            TestRWLock.this.lm.releaseWriteLock(this.resource, null);
                        }
                    }
                }
                catch (DeadlockDetectedException deadlockDetectedException) {
                    while (!lockStack.isEmpty()) {
                        if (lockStack.pop() == this.READ) {
                            TestRWLock.this.lm.releaseReadLock(this.resource, null);
                            continue;
                        }
                        TestRWLock.this.lm.releaseWriteLock(this.resource, null);
                    }
                }
                finally {
                    while (!lockStack.isEmpty()) {
                        if (lockStack.pop() == this.READ) {
                            TestRWLock.this.lm.releaseReadLock(this.resource, null);
                            continue;
                        }
                        TestRWLock.this.lm.releaseWriteLock(this.resource, null);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private static class ResourceObject {
        private String name = null;

        ResourceObject(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class HelperThread
    extends Thread {
        private static final long MAX_WAIT_LOOPS = 40L;
        private static final int DO_NOTHING_TASK = 0;
        private static final int GET_READLOCK_TASK = 1;
        private static final int GET_WRITELOCK_TASK = 2;
        private static final int RELEASE_READLOCK_TASK = 3;
        private static final int RELEASE_WRITELOCK_TASK = 4;
        private static final int QUIT_TASK = 5;
        private String name = null;
        private int nextTask = 0;
        private boolean taskCompleted = true;
        private Object resource = null;

        HelperThread(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                block12: while (this.nextTask != 5) {
                    switch (this.nextTask) {
                        case 0: {
                            HelperThread helperThread = this;
                            synchronized (helperThread) {
                                this.wait(15L);
                                continue block12;
                            }
                        }
                        case 1: {
                            TestRWLock.this.lm.getReadLock(this.resource);
                            this.taskCompleted = true;
                            this.nextTask = 0;
                            continue block12;
                        }
                        case 3: {
                            TestRWLock.this.lm.releaseReadLock(this.resource, null);
                            this.taskCompleted = true;
                            this.nextTask = 0;
                            continue block12;
                        }
                        case 2: {
                            TestRWLock.this.lm.getWriteLock(this.resource);
                            this.taskCompleted = true;
                            this.nextTask = 0;
                            continue block12;
                        }
                        case 4: {
                            TestRWLock.this.lm.releaseWriteLock(this.resource, null);
                            this.taskCompleted = true;
                            this.nextTask = 0;
                            continue block12;
                        }
                    }
                    throw new RuntimeException("Argh");
                }
            }
            catch (Exception e) {
                this.taskCompleted = true;
                System.out.println("" + this + " unable to execute task, " + e);
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        synchronized void waitForCompletionOfTask() {
            int count = 0;
            while (!this.taskCompleted) {
                if ((long)count > 40L) {
                    throw new RuntimeException("Task timed out");
                }
                try {
                    this.wait(25L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++count;
            }
        }

        boolean isTaskCompleted() {
            return this.taskCompleted;
        }

        synchronized void getReadLock(Object resource) {
            if (!this.taskCompleted) {
                throw new RuntimeException("Task not completed");
            }
            this.taskCompleted = false;
            this.resource = resource;
            this.nextTask = 1;
        }

        synchronized void releaseReadLock(Object resource) {
            if (!this.taskCompleted) {
                throw new RuntimeException("Task not completed");
            }
            this.taskCompleted = false;
            this.resource = resource;
            this.nextTask = 3;
        }

        synchronized void getWriteLock(Object resource) {
            if (!this.taskCompleted) {
                throw new RuntimeException("Task not completed");
            }
            this.taskCompleted = false;
            this.resource = resource;
            this.nextTask = 2;
        }

        synchronized void releaseWriteLock(Object resource) {
            if (!this.taskCompleted) {
                throw new RuntimeException("Task not completed");
            }
            this.taskCompleted = false;
            this.resource = resource;
            this.nextTask = 4;
        }

        void quit() {
            this.taskCompleted = false;
            this.nextTask = 5;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

