/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.nioneo.xa.Command;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogIoUtils;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommandFactory;
import org.neo4j.kernel.impl.util.FileUtils;

public class TestTxTimestamps {
    private EmbeddedGraphDatabase db;

    @Before
    public void doBefore() throws Exception {
        File storeDir = new File("target/test-data/timestamp");
        FileUtils.deleteRecursively((File)storeDir);
        this.db = new EmbeddedGraphDatabase(storeDir.getAbsolutePath(), MapUtil.stringMap((String[])new String[]{"keep_logical_logs", "true"}));
    }

    @After
    public void doAfter() throws Exception {
        this.db.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void doIt() throws Exception {
        long[] expectedStartTimestamps = new long[10];
        long[] expectedCommitTimestamps = new long[expectedStartTimestamps.length];
        for (int i = 0; i < expectedStartTimestamps.length; ++i) {
            Transaction tx = this.db.beginTx();
            expectedStartTimestamps[i] = System.currentTimeMillis();
            Node node = this.db.createNode();
            node.setProperty("name", (Object)("Mattias " + i));
            tx.success();
            tx.finish();
            expectedCommitTimestamps[i] = System.currentTimeMillis();
        }
        this.db.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb").rotateLogicalLog();
        ByteBuffer buffer = ByteBuffer.allocate(512000);
        RandomAccessFile file = new RandomAccessFile(new File(this.db.getStoreDir(), "nioneo_logical.log.v0"), "r");
        try {
            CommandFactory commandFactory = new CommandFactory();
            FileChannel channel = file.getChannel();
            LogIoUtils.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)channel, (boolean)true);
            LogEntry entry = null;
            int foundTxCount = 0;
            while ((entry = LogIoUtils.readEntry((ByteBuffer)buffer, (ReadableByteChannel)channel, (XaCommandFactory)commandFactory)) != null) {
                long exp;
                long diff;
                if (entry instanceof LogEntry.Start) {
                    diff = ((LogEntry.Start)entry).getTimeWritten() - expectedStartTimestamps[foundTxCount];
                    exp = expectedCommitTimestamps[foundTxCount] - expectedStartTimestamps[foundTxCount];
                    Assert.assertTrue((String)(diff + " <= " + exp), (diff <= exp ? 1 : 0) != 0);
                    continue;
                }
                if (!(entry instanceof LogEntry.Commit)) continue;
                diff = ((LogEntry.Commit)entry).getTimeWritten() - expectedCommitTimestamps[foundTxCount];
                exp = expectedCommitTimestamps[foundTxCount] - expectedStartTimestamps[foundTxCount];
                Assert.assertTrue((String)(diff + " <= " + exp), (diff <= exp ? 1 : 0) != 0);
                ++foundTxCount;
            }
            Assert.assertEquals((long)expectedCommitTimestamps.length, (long)foundTxCount);
        }
        finally {
            file.close();
        }
    }

    private static class CommandFactory
    extends XaCommandFactory {
        private CommandFactory() {
        }

        public XaCommand readCommand(ReadableByteChannel byteChannel, ByteBuffer buffer) throws IOException {
            return Command.readCommand(null, (ReadableByteChannel)byteChannel, (ByteBuffer)buffer);
        }
    }
}

