/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.kernel.impl.traversal.AbstractTestBase;

public class SmallestGraphEverTest
extends AbstractTestBase {
    @BeforeClass
    public static void setup() {
        SmallestGraphEverTest.createGraph("1 TO 2");
    }

    @Test
    public void testUnrestrictedTraversalCanFinishDepthFirst() throws Exception {
        this.execute(Traversal.description().depthFirst(), Uniqueness.NONE);
    }

    @Test
    public void testUnrestrictedTraversalCanFinishBreadthFirst() throws Exception {
        this.execute(Traversal.description().breadthFirst(), Uniqueness.NONE);
    }

    @Test
    public void testNodeGlobalTraversalCanFinishDepthFirst() throws Exception {
        this.execute(Traversal.description().depthFirst(), Uniqueness.NODE_GLOBAL);
    }

    @Test
    public void testNodeGlobalTraversalCanFinishBreadthFirst() throws Exception {
        this.execute(Traversal.description().breadthFirst(), Uniqueness.NODE_GLOBAL);
    }

    @Test
    public void testRelationshipGlobalTraversalCanFinishDepthFirst() throws Exception {
        this.execute(Traversal.description().depthFirst(), Uniqueness.RELATIONSHIP_GLOBAL);
    }

    @Test
    public void testRelationshipGlobalTraversalCanFinishBreadthFirst() throws Exception {
        this.execute(Traversal.description().breadthFirst(), Uniqueness.RELATIONSHIP_GLOBAL);
    }

    @Test
    public void testNodePathTraversalCanFinishDepthFirst() throws Exception {
        this.execute(Traversal.description().depthFirst(), Uniqueness.NODE_PATH);
    }

    @Test
    public void testNodePathTraversalCanFinishBreadthFirst() throws Exception {
        this.execute(Traversal.description().breadthFirst(), Uniqueness.NODE_PATH);
    }

    @Test
    public void testRelationshipPathTraversalCanFinishDepthFirst() throws Exception {
        this.execute(Traversal.description().depthFirst(), Uniqueness.RELATIONSHIP_PATH);
    }

    @Test
    public void testRelationshipPathTraversalCanFinishBreadthFirst() throws Exception {
        this.execute(Traversal.description().breadthFirst(), Uniqueness.RELATIONSHIP_PATH);
    }

    @Test
    public void testNodeRecentTraversalCanFinishDepthFirst() throws Exception {
        this.execute(Traversal.description().depthFirst(), Uniqueness.NODE_RECENT);
    }

    @Test
    public void testNodeRecentTraversalCanFinishBreadthFirst() throws Exception {
        this.execute(Traversal.description().breadthFirst(), Uniqueness.NODE_RECENT);
    }

    @Test
    public void testRelationshipRecentTraversalCanFinishDepthFirst() throws Exception {
        this.execute(Traversal.description().depthFirst(), Uniqueness.RELATIONSHIP_RECENT);
    }

    @Test
    public void testRelationshipRecentTraversalCanFinishBreadthFirst() throws Exception {
        this.execute(Traversal.description().breadthFirst(), Uniqueness.RELATIONSHIP_RECENT);
    }

    private void execute(TraversalDescription traversal, Uniqueness uniqueness) {
        Traverser traverser = traversal.uniqueness((UniquenessFactory)uniqueness).traverse(SmallestGraphEverTest.node("1"));
        Assert.assertFalse((String)"empty traversal", (IteratorUtil.count((Iterable)traverser) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTraverseRelationshipsWithStartNodeNotIncluded() throws Exception {
        TraversalDescription traversal = Traversal.description().filter(Traversal.returnAllButStartNode());
        int count = 0;
        for (Relationship rel : traversal.traverse(SmallestGraphEverTest.node("1")).relationships()) {
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }
}

