/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;

public class TestStringLogger {
    @Test
    public void makeSureLogsAreRotated() throws Exception {
        String path = "target/test-data/stringlogger";
        FileUtils.deleteRecursively((File)new File(path));
        File logFile = new File(path, "messages.log");
        File oldFile = new File(path, "messages.log.1");
        File oldestFile = new File(path, "messages.log.2");
        StringLogger logger = StringLogger.logger((String)path, (int)204800);
        Assert.assertFalse((boolean)oldFile.exists());
        int counter = 0;
        String prefix = "Bogus message ";
        while (!oldFile.exists()) {
            logger.logMessage(prefix + counter++, true);
        }
        int mark1 = counter - 1;
        logger.logMessage(prefix + counter++, true);
        Assert.assertTrue((boolean)this.firstLineOfFile(oldFile).contains(prefix + "0"));
        Assert.assertTrue((boolean)this.lastLineOfFile(oldFile).contains(prefix + mark1));
        Assert.assertTrue((boolean)this.firstLineOfFile(logFile).contains(prefix + (counter - 1)));
        while (!oldestFile.exists()) {
            logger.logMessage(prefix + counter++, true);
        }
        int mark2 = counter - 1;
        logger.logMessage(prefix + counter++, true);
        Assert.assertTrue((boolean)this.firstLineOfFile(oldestFile).contains(prefix + "0"));
        Assert.assertTrue((boolean)this.lastLineOfFile(oldestFile).contains(prefix + mark1));
        Assert.assertTrue((boolean)this.firstLineOfFile(oldFile).contains(prefix + (mark1 + 1)));
        Assert.assertTrue((boolean)this.lastLineOfFile(oldFile).contains(prefix + mark2));
        Assert.assertTrue((boolean)this.firstLineOfFile(logFile).contains(prefix + (counter - 1)));
        long previousSize = 0L;
        while (true) {
            logger.logMessage(prefix + counter++, true);
            if (logFile.length() < previousSize) break;
            previousSize = logFile.length();
        }
        Assert.assertFalse((boolean)new File(path, "messages.log.3").exists());
        Assert.assertTrue((boolean)this.firstLineOfFile(oldestFile).contains(prefix + (mark1 + 1)));
        Assert.assertTrue((boolean)this.lastLineOfFile(oldestFile).contains(prefix + mark2));
    }

    private String firstLineOfFile(File file) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String result = reader.readLine();
        reader.close();
        return result;
    }

    private String lastLineOfFile(File file) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        String result = null;
        while ((line = reader.readLine()) != null) {
            result = line;
        }
        reader.close();
        return result;
    }
}

