/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.tooling.GlobalGraphOperations;

public class DbRepresentation
implements Serializable {
    private final Map<Long, NodeRep> nodes = new TreeMap<Long, NodeRep>();
    private long highestNodeId;
    private long highestRelationshipId;

    public static DbRepresentation of(GraphDatabaseService db) {
        DbRepresentation result = new DbRepresentation();
        for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
            NodeRep nodeRep = new NodeRep(db, node);
            result.nodes.put(node.getId(), nodeRep);
            result.highestNodeId = Math.max(node.getId(), result.highestNodeId);
            result.highestRelationshipId = Math.max(nodeRep.highestRelationshipId, result.highestRelationshipId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbRepresentation of(String storeDir) {
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(storeDir);
        try {
            DbRepresentation dbRepresentation = DbRepresentation.of((GraphDatabaseService)db);
            return dbRepresentation;
        }
        finally {
            db.shutdown();
        }
    }

    public long getHighestNodeId() {
        return this.highestNodeId;
    }

    public long getHighestRelationshipId() {
        return this.highestRelationshipId;
    }

    public boolean equals(Object obj) {
        return ((Object)((DbRepresentation)obj).nodes).equals(this.nodes);
    }

    public int hashCode() {
        return ((Object)this.nodes).hashCode();
    }

    public String toString() {
        return this.nodes.toString();
    }

    private static class PropertiesRep
    implements Serializable {
        private final Map<String, Serializable> props = new HashMap<String, Serializable>();

        PropertiesRep(PropertyContainer entity) {
            for (String key : entity.getPropertyKeys()) {
                Serializable value = (Serializable)entity.getProperty(key, null);
                if (value == null) continue;
                if (value.getClass().isArray()) {
                    this.props.put(key, new ArrayList<Object>(Arrays.asList(IoPrimitiveUtils.asArray((Object)value))));
                    continue;
                }
                this.props.put(key, value);
            }
        }

        public boolean equals(Object obj) {
            return ((Object)((PropertiesRep)obj).props).equals(this.props);
        }

        public int hashCode() {
            return ((Object)this.props).hashCode();
        }

        public String toString() {
            return this.props.toString();
        }
    }

    private static class NodeRep
    implements Serializable {
        private final PropertiesRep properties;
        private final Map<Long, PropertiesRep> outRelationships = new HashMap<Long, PropertiesRep>();
        private final long highestRelationshipId;
        private final long myId;
        private final Map<String, Map<String, Serializable>> index;

        NodeRep(GraphDatabaseService db, Node node) {
            this.myId = node.getId();
            this.properties = new PropertiesRep((PropertyContainer)node);
            long highestRel = 0L;
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                this.outRelationships.put(rel.getId(), new PropertiesRep((PropertyContainer)rel));
                highestRel = Math.max(highestRel, rel.getId());
            }
            this.highestRelationshipId = highestRel;
            this.index = new HashMap<String, Map<String, Serializable>>();
            this.fillIndex(db);
        }

        private void fillIndex(GraphDatabaseService db) {
            for (String indexName : db.index().nodeIndexNames()) {
                HashMap thisIndex = new HashMap();
                Index tempIndex = db.index().forNodes(indexName);
                block1: for (Map.Entry property : this.properties.props.entrySet()) {
                    IndexHits content = tempIndex.get((String)property.getKey(), property.getValue());
                    if (!content.hasNext()) continue;
                    for (Node hit : content) {
                        if (hit.getId() != this.myId) continue;
                        thisIndex.put(property.getKey(), property.getValue());
                        continue block1;
                    }
                }
                this.index.put(indexName, thisIndex);
            }
        }

        private boolean checkEqualsForIndex(NodeRep other) {
            if (other.index == this.index) {
                return true;
            }
            for (Map.Entry<String, Map<String, Serializable>> entry : this.index.entrySet()) {
                if (other.index.get(entry.getKey()) == null) {
                    return false;
                }
                Map<String, Serializable> thisIndex = entry.getValue();
                Map<String, Serializable> otherIndex = other.index.get(entry.getKey());
                if (thisIndex.size() != otherIndex.size()) {
                    return false;
                }
                for (Map.Entry<String, Serializable> indexEntry : thisIndex.entrySet()) {
                    if (indexEntry.getValue().equals(otherIndex.get(indexEntry.getKey()))) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean equals(Object obj) {
            NodeRep o = (NodeRep)obj;
            return o.myId == this.myId && o.properties.equals(this.properties) && ((Object)o.outRelationships).equals(this.outRelationships) && this.checkEqualsForIndex(o);
        }

        public int hashCode() {
            int result = 7;
            result += this.properties.hashCode() * 7;
            result += ((Object)this.outRelationships).hashCode() * 13;
            result = (int)((long)result + this.myId * 17L);
            return result += ((Object)this.index).hashCode() * 19;
        }

        public String toString() {
            return "<props: " + this.properties + ", rels: " + this.outRelationships + ">";
        }
    }
}

