/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.GraphDatabaseTestAccess;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;
import org.neo4j.test.impl.EphemeralIdGenerator;
import org.neo4j.tooling.GlobalGraphOperations;

public class ImpermanentGraphDatabase
extends GraphDatabaseTestAccess {
    private static final File PATH = new File("target/test-data/impermanent-db");
    private static final AtomicInteger ID = new AtomicInteger();

    public ImpermanentGraphDatabase(Map<String, String> params) {
        super(ImpermanentGraphDatabase.path(), ImpermanentGraphDatabase.withoutMemmap(params), new EphemeralIdGenerator.Factory(), new EphemeralFileSystemAbstraction());
    }

    private static Map<String, String> withoutMemmap(Map<String, String> params) {
        HashMap<String, String> result = new HashMap<String, String>(params);
        result.put("use_memory_mapped_buffers", "false");
        return result;
    }

    public ImpermanentGraphDatabase() {
        this(new HashMap<String, String>());
    }

    protected boolean isEphemeral() {
        return true;
    }

    protected StringLogger createStringLogger() {
        return StringLogger.DEV_NULL;
    }

    private static String path() {
        File path = null;
        do {
            if (!(path = new File(PATH, String.valueOf(ID.get()))).exists()) continue;
            ID.incrementAndGet();
        } while (path.exists());
        return path.getAbsolutePath();
    }

    private static void clearDirectory(File path) {
        try {
            FileUtils.deleteRecursively((File)path);
        }
        catch (IOException e) {
            if (Config.osIsWindows()) {
                System.err.println("Couldn't clear directory, and that's ok because this is Windows. Next " + ImpermanentGraphDatabase.class.getSimpleName() + " will get a new directory");
                e.printStackTrace();
                ID.incrementAndGet();
            }
            throw new RuntimeException("Couldn't not clear directory");
        }
    }

    @Override
    protected void close() {
        super.close();
        ((EphemeralFileSystemAbstraction)this.fileSystem).dispose();
        ImpermanentGraphDatabase.clearDirectory(new File(this.getStoreDir()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanContent(boolean retainReferenceNode) {
        Transaction tx = this.beginTx();
        try {
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)this).getAllNodes()) {
                for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                    rel.delete();
                }
                if (node.hasRelationship()) continue;
                if (retainReferenceNode) {
                    try {
                        Node referenceNode = this.getReferenceNode();
                        if (node.equals(referenceNode)) continue;
                        node.delete();
                    }
                    catch (NotFoundException nfe) {}
                    continue;
                }
                node.delete();
            }
            tx.success();
        }
        catch (Exception e) {
            tx.failure();
        }
        finally {
            tx.finish();
        }
    }

    public void cleanContent() {
        this.cleanContent(false);
    }

    static {
        try {
            FileUtils.deleteRecursively((File)PATH);
        }
        catch (IOException e) {
            throw new Error("Couldn't clear directory");
        }
    }
}

