/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class OtherThreadExecutor<T>
implements ThreadFactory {
    private static final AtomicLong THREADID = new AtomicLong();
    private final ExecutorService commandExecutor = Executors.newSingleThreadExecutor(this);
    private final T state;
    private volatile Thread thread;

    public OtherThreadExecutor(T initialState) {
        this.state = initialState;
    }

    public <R> Future<R> executeDontWait(final WorkerCommand<T, R> cmd) throws Exception {
        return this.commandExecutor.submit(new Callable<R>(){

            @Override
            public R call() {
                return cmd.doWork(OtherThreadExecutor.this.state);
            }
        });
    }

    public <R> R execute(WorkerCommand<T, R> cmd) throws Exception {
        return this.executeDontWait(cmd).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R execute(WorkerCommand<T, R> cmd, long timeout) throws Exception {
        Future<R> future = this.executeDontWait(cmd);
        boolean success = false;
        try {
            R result = future.get(timeout, TimeUnit.MILLISECONDS);
            success = true;
            R r = result;
            return r;
        }
        finally {
            if (!success) {
                future.cancel(true);
            }
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread;
        this.thread = thread = new Thread(r, this.getClass().getName() + ":" + THREADID.getAndIncrement()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    super.run();
                }
                finally {
                    OtherThreadExecutor.this.thread = null;
                }
            }
        };
        return thread;
    }

    public void waitUntilWaiting() {
        Thread thread = this.getThread();
        while (thread.getState() != Thread.State.WAITING) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private Thread getThread() {
        Thread thread = null;
        while (thread == null) {
            thread = this.thread;
        }
        return thread;
    }

    public static interface WorkerCommand<T, R> {
        public R doWork(T var1);
    }
}

