/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Random;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.impl.core.NodeManager;

public class RandomNode {
    private static final Random random = new Random();
    private final AbstractGraphDatabase graphdb;
    private final NodeManager nm;

    public RandomNode(AbstractGraphDatabase graphdb) {
        this.graphdb = graphdb;
        this.nm = graphdb.getConfig().getGraphDbModule().getNodeManager();
    }

    public Node get() {
        Node node = null;
        do {
            try {
                node = this.graphdb.getNodeById(this.id());
            }
            catch (NotFoundException loop) {
                // empty catch block
            }
        } while (node == null);
        return node;
    }

    private long id() {
        return random.nextLong() % this.nm.getHighestPossibleIdInUse(Node.class);
    }
}

