/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.indexprovider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.neo4j.collections.indexprovider.NodeIndexHits;
import org.neo4j.collections.timeline.Timeline;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;

public class TimelineNodeIndex
implements Index<Node> {
    public static final String TIMESTAMP = "timestamp";
    public static final String START_NODE_ID = "start_node_id";
    private Timeline timeline;
    private final String indexName;

    public TimelineNodeIndex(String indexName, GraphDatabaseService db, Map<String, String> config) {
        this.indexName = indexName;
        Transaction tx = db.beginTx();
        Node underlyingNode = this.getOrCreateStartNode(db, config);
        this.timeline = new Timeline(indexName, underlyingNode, false, db);
        tx.success();
        tx.finish();
    }

    private Node getOrCreateStartNode(GraphDatabaseService db, Map<String, String> config) {
        if (this.underlyingNodeWasProvided(config)) {
            return db.getNodeById(Long.parseLong(config.get(START_NODE_ID)));
        }
        return db.getReferenceNode();
    }

    private boolean underlyingNodeWasProvided(Map<String, String> config) {
        return config.containsKey(START_NODE_ID);
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public boolean isWriteable() {
        return true;
    }

    public String getName() {
        return this.indexName;
    }

    public Class<Node> getEntityType() {
        return Node.class;
    }

    public IndexHits<Node> get(String key, Object value) {
        return new NodeIndexHits(this.toList(this.timeline.getNodes((Long)value)));
    }

    private List<Node> toList(Iterable<Node> nodes) {
        ArrayList<Node> results = new ArrayList<Node>();
        for (Node node : nodes) {
            results.add(node);
        }
        return results;
    }

    public IndexHits<Node> query(String key, Object queryOrQueryObject) {
        return null;
    }

    public IndexHits<Node> query(Object queryString) {
        String query = (String)queryString;
        Long from = Long.parseLong(query.substring(1, query.indexOf("TO")).trim());
        Long to = Long.parseLong(query.substring(query.indexOf("TO") + 2, query.indexOf("]")).trim());
        return new NodeIndexHits(this.toList(this.timeline.getAllNodesBetween(from, to)));
    }

    public void add(Node entity, String key, Object value) {
        if (!key.equals(TIMESTAMP)) {
            throw new RuntimeException("need a timestamp key and a LONG value");
        }
        this.timeline.addNode(entity, (Long)value);
    }

    public void remove(Node entity, String key, Object value) {
        this.timeline.removeNode(entity);
    }

    public void remove(Node entity, String key) {
        this.remove(entity);
    }

    public void remove(Node entity) {
        this.timeline.removeNode(entity);
    }

    public void delete() {
        this.timeline.delete();
    }

    public GraphDatabaseService getGraphDatabase() {
        return this.timeline.getUnderlyingNode().getGraphDatabase();
    }

    public Node putIfAbsent(Node entity, String key, Object value) {
        return entity;
    }
}

