/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collections.radixtree;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.collections.radixtree.RadixTree;
import org.neo4j.collections.radixtree.RadixTreeRelationshipTypes;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class RadixTreeImpl
implements RadixTree {
    private final GraphDatabaseService database;
    private final Node refNode;
    private Node rootNode;
    public static final String RADIXTREE_LABEL = "radixtree_label";

    public RadixTreeImpl(GraphDatabaseService database, Node refNode) {
        this.database = database;
        this.refNode = refNode;
        this.rootNode = database.createNode();
        this.rootNode.setProperty(RADIXTREE_LABEL, (Object)"");
        refNode.createRelationshipTo(this.rootNode, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_ROOT);
    }

    @Override
    public void insert(String key, Node node) {
        if (key.length() == 0) {
            throw new IllegalArgumentException("Key must have a length greater than zero");
        }
        this.insert(key, node, this.rootNode, "", false);
    }

    @Override
    public List<Node> get(String key) {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        this.getRelationships(key, this.rootNode, relationships);
        ArrayList<Node> results = new ArrayList<Node>(relationships.size());
        for (Relationship rel : relationships) {
            results.add(rel.getEndNode());
        }
        return results;
    }

    @Override
    public boolean insertUnique(String key, Node node) {
        if (key.length() == 0) {
            throw new IllegalArgumentException("Key must have a length greater than zero");
        }
        return this.insert(key, node, this.rootNode, "", true);
    }

    @Override
    public Node getUnique(String key) {
        List<Node> result = this.get(key);
        if (result != null && result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    @Override
    public int remove(String key, boolean deleteIndexedNodes) {
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        this.getRelationships(key, this.rootNode, results);
        for (Relationship rel : results) {
            Node indexedNode = rel.getEndNode();
            rel.delete();
            if (!deleteIndexedNodes) continue;
            indexedNode.delete();
        }
        return results.size();
    }

    private boolean isRoot(Node treeNode) {
        return treeNode.hasRelationship((RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_ROOT, Direction.INCOMING);
    }

    private String getLabel(Node treeNode) {
        return (String)treeNode.getProperty(RADIXTREE_LABEL);
    }

    private void setLabel(Node treeNode, String label) {
        treeNode.setProperty(RADIXTREE_LABEL, (Object)label);
    }

    private boolean insertInRootWithNoMatchingCharacters(String key, Node value, Node tree, boolean unique) {
        if (!this.isRoot(tree)) {
            throw new IllegalStateException();
        }
        String completeLabel = this.getLabel(tree);
        if (!tree.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RadixTreeRelationshipTypes.RADIXTREE_TREE}) && !tree.hasRelationship(Direction.OUTGOING, new RelationshipType[]{RadixTreeRelationshipTypes.RADIXTREE_LEAF})) {
            this.setLabel(tree, key);
            tree.createRelationshipTo(value, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_LEAF);
        } else if (completeLabel.equals("")) {
            Node child = this.searchNodeForNewKey(key, tree, completeLabel);
            if (child != null) {
                return this.insert(key, value, child, completeLabel, unique);
            }
            Node newTreeNode = this.createNode(key);
            newTreeNode.createRelationshipTo(value, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_LEAF);
            tree.createRelationshipTo(newTreeNode, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE);
        } else {
            Node newRootNode = this.createNode("");
            Node newTreeNode = this.createNode(key);
            newTreeNode.createRelationshipTo(value, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_LEAF);
            this.refNode.createRelationshipTo(newRootNode, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_ROOT);
            this.rootNode = newRootNode;
            tree.getSingleRelationship((RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_ROOT, Direction.INCOMING).delete();
            newRootNode.createRelationshipTo(tree, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE);
            newRootNode.createRelationshipTo(newTreeNode, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE);
        }
        return true;
    }

    private void getLeafsRelationships(Node tree, List<Relationship> results) {
        for (Relationship r : tree.getRelationships(Direction.OUTGOING, new RelationshipType[]{RadixTreeRelationshipTypes.RADIXTREE_LEAF})) {
            results.add(r);
        }
    }

    private void getRelationships(String key, Node tree, List<Relationship> results) {
        String label = this.getLabel(tree);
        if (label.length() > key.length()) {
            return;
        }
        if (label.equals(key)) {
            this.getLeafsRelationships(tree, results);
        } else {
            int matchingCharacters = this.countMatchingCharacters(key, label);
            if (matchingCharacters > 0 || this.isRoot(tree)) {
                key = key.substring(matchingCharacters);
                for (Relationship r : tree.getRelationships(Direction.OUTGOING, new RelationshipType[]{RadixTreeRelationshipTypes.RADIXTREE_TREE})) {
                    this.getRelationships(key, r.getEndNode(), results);
                    if (results.size() <= 0) continue;
                    break;
                }
            }
        }
    }

    private boolean insert(String key, Node value, Node tree, String labelPrefix, boolean unique) {
        String label = this.getLabel(tree);
        String completeLabel = labelPrefix + label;
        int matchingCharacters = this.countMatchingCharacters(key, completeLabel);
        if (completeLabel.equals(key)) {
            if (unique && this.treeNodeContainsLeaf(tree)) {
                return false;
            }
            tree.createRelationshipTo(value, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_LEAF);
        } else {
            if (matchingCharacters == 0) {
                return this.insertInRootWithNoMatchingCharacters(key, value, tree, unique);
            }
            if (matchingCharacters == completeLabel.length() && completeLabel.length() < key.length()) {
                Node child = this.searchNodeForNewKey(key, tree, completeLabel);
                if (child != null) {
                    return this.insert(key, value, child, completeLabel, unique);
                }
                Node newChild = this.createNode(key.substring(matchingCharacters));
                newChild.createRelationshipTo(value, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_LEAF);
                tree.createRelationshipTo(newChild, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE);
            } else if (matchingCharacters == labelPrefix.length()) {
                Node newParentNode = this.createNode(key.substring(0, matchingCharacters));
                this.getParent(tree).createRelationshipTo(newParentNode, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE);
                Node newTreeNode = this.createNode(key.substring(matchingCharacters));
                newTreeNode.createRelationshipTo(value, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_LEAF);
                this.setLabel(tree, completeLabel.substring(matchingCharacters));
                tree.getSingleRelationship((RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE, Direction.INCOMING).delete();
                newParentNode.createRelationshipTo(tree, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE);
                newParentNode.createRelationshipTo(newTreeNode, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE);
            } else if (matchingCharacters == key.length()) {
                Node newParentNode = this.createNode(key.substring(labelPrefix.length()));
                newParentNode.createRelationshipTo(value, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_LEAF);
                this.getParent(tree).createRelationshipTo(newParentNode, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE);
                this.setLabel(tree, completeLabel.substring(matchingCharacters));
                tree.getSingleRelationship((RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE, Direction.INCOMING).delete();
                newParentNode.createRelationshipTo(tree, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE);
            } else {
                boolean newRootNeeded = this.isRoot(tree);
                Node newParentNode = this.createNode(completeLabel.substring(0, matchingCharacters).substring(labelPrefix.length()));
                if (newRootNeeded) {
                    this.refNode.createRelationshipTo(newParentNode, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_ROOT);
                    this.rootNode = newParentNode;
                } else {
                    this.getParent(tree).createRelationshipTo(newParentNode, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE);
                }
                this.setLabel(tree, completeLabel.substring(matchingCharacters));
                if (newRootNeeded) {
                    tree.getSingleRelationship((RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_ROOT, Direction.INCOMING).delete();
                } else {
                    tree.getSingleRelationship((RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE, Direction.INCOMING).delete();
                }
                Node newTreeNode = this.createNode(key.substring(matchingCharacters));
                newTreeNode.createRelationshipTo(value, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_LEAF);
                newParentNode.createRelationshipTo(tree, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE);
                newParentNode.createRelationshipTo(newTreeNode, (RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE);
            }
        }
        return true;
    }

    private Node createNode(String label) {
        Node treeNode = this.database.createNode();
        this.setLabel(treeNode, label);
        return treeNode;
    }

    private Node searchNodeForNewKey(String key, Node tree, String labelPrefix) {
        Iterable rels = tree.getRelationships((RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE, Direction.OUTGOING);
        for (Relationship rel : rels) {
            Node child = rel.getEndNode();
            String completeChildLabel = labelPrefix + this.getLabel(child);
            if (this.countMatchingCharacters(key, completeChildLabel) <= labelPrefix.length()) continue;
            return child;
        }
        return null;
    }

    private Node getParent(Node treeNode) {
        return treeNode.getSingleRelationship((RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_TREE, Direction.INCOMING).getStartNode();
    }

    private boolean treeNodeContainsLeaf(Node treeNode) {
        return treeNode.hasRelationship((RelationshipType)RadixTreeRelationshipTypes.RADIXTREE_LEAF, Direction.OUTGOING);
    }

    private int countMatchingCharacters(String key, String treeLabel) {
        int count;
        for (count = 0; count < key.length() && count < treeLabel.length() && key.charAt(count) == treeLabel.charAt(count); ++count) {
        }
        return count;
    }
}

