/*
 * Decompiled with CFR 0.152.
 */
package play.modules.neo4j.util;

import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.server.WrappingNeoServerBootstrapper;
import play.Logger;
import play.Play;
import play.modules.neo4j.exception.Neo4jPlayException;

public class Neo4j {
    private static volatile GraphDatabaseService graphDb;
    private static volatile WrappingNeoServerBootstrapper bootstrapperDb;
    private static volatile SpatialDatabaseService spatialDb;

    public static void initialize() throws Neo4jPlayException {
        Boolean isSpatial;
        if (graphDb != null) {
            throw new Neo4jPlayException("The graphDb is already initialize.");
        }
        String DBPath = Play.configuration.getProperty("neo4j.path");
        Logger.debug((String)("Neo4j database path is :" + DBPath), (Object[])new Object[0]);
        EmbeddedGraphDatabase graph = new EmbeddedGraphDatabase(DBPath);
        graphDb = graph;
        if (Play.mode == Play.Mode.DEV) {
            WrappingNeoServerBootstrapper bootstrapper = new WrappingNeoServerBootstrapper((AbstractGraphDatabase)graph);
            bootstrapper.start();
            bootstrapperDb = bootstrapper;
        }
        if ((isSpatial = Boolean.valueOf(Play.configuration.getProperty("neo4j.spatial", "false"))).booleanValue()) {
            SpatialDatabaseService spatial;
            spatialDb = spatial = new SpatialDatabaseService((GraphDatabaseService)graph);
        }
    }

    public static void destroy() {
        if (Play.mode == Play.Mode.DEV && bootstrapperDb != null) {
            bootstrapperDb.stop();
        }
        if (graphDb != null) {
            graphDb.shutdown();
        }
    }

    public static GraphDatabaseService db() {
        if (graphDb == null) {
            Logger.debug((String)"Can't get DB from local thread !!!", (Object[])new Object[0]);
        }
        Logger.debug((String)("Cuurent thread is " + Thread.currentThread().getName() + " " + Thread.currentThread().getId()), (Object[])new Object[0]);
        return graphDb;
    }

    public static SpatialDatabaseService spatial() {
        return spatialDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Transaction tx = Neo4j.db().beginTx();
        try {
            for (Node node : Neo4j.db().getAllNodes()) {
                Logger.debug((String)("Deleting node " + node.getId()), (Object[])new Object[0]);
                for (Relationship relation : node.getRelationships()) {
                    Logger.debug((String)("Deleting relation " + relation.getId() + " for node " + node.getId()), (Object[])new Object[0]);
                    relation.delete();
                }
                if (node.getGraphDatabase().getReferenceNode().equals(node)) {
                    for (String property : node.getPropertyKeys()) {
                        node.removeProperty(property);
                    }
                    continue;
                }
                node.delete();
            }
            String[] nodeIndexNames = Neo4j.db().index().nodeIndexNames();
            for (int i = 0; i < nodeIndexNames.length; ++i) {
                Logger.debug((String)("Deleting node index  " + nodeIndexNames[i]), (Object[])new Object[0]);
                Neo4j.db().index().forNodes(nodeIndexNames[i]).delete();
            }
            String[] relationIdexNames = Neo4j.db().index().relationshipIndexNames();
            for (int j = 0; j < relationIdexNames.length; ++j) {
                Logger.debug((String)("Deleting relation index  " + nodeIndexNames[j]), (Object[])new Object[0]);
                Neo4j.db().index().forNodes(relationIdexNames[j]).delete();
            }
            tx.success();
            Logger.debug((String)"Deletion commiting", (Object[])new Object[0]);
        }
        finally {
            tx.finish();
        }
    }
}

