/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.neo4j;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.AbstractFeatureLocking;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.TransactionStateDiff;
import org.geotools.data.neo4j.DefaultResourceInfo;
import org.geotools.data.neo4j.Neo4jFeatureBuilder;
import org.geotools.data.neo4j.Neo4jSpatialFeatureReader;
import org.geotools.data.neo4j.Neo4jSpatialFeatureWriter;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.filter.FidFilterImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryImpl;
import org.neo4j.collections.rtree.filter.SearchAll;
import org.neo4j.collections.rtree.filter.SearchFilter;
import org.neo4j.gis.spatial.Constants;
import org.neo4j.gis.spatial.EditableLayer;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.SpatialDatabaseRecord;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.gis.spatial.Utilities;
import org.neo4j.gis.spatial.filter.SearchCQL;
import org.neo4j.gis.spatial.filter.SearchRecords;
import org.neo4j.graphdb.GraphDatabaseService;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Neo4jSpatialDataStore
extends AbstractDataStore
implements Constants {
    private String[] typeNames;
    private Map<String, SimpleFeatureType> simpleFeatureTypeIndex = Collections.synchronizedMap(new HashMap());
    private Map<String, CoordinateReferenceSystem> crsIndex = Collections.synchronizedMap(new HashMap());
    private Map<String, Style> styleIndex = Collections.synchronizedMap(new HashMap());
    private Map<String, ReferencedEnvelope> boundsIndex = Collections.synchronizedMap(new HashMap());
    private Map<String, SimpleFeatureSource> featureSourceIndex = Collections.synchronizedMap(new HashMap());
    private GraphDatabaseService database;
    private SpatialDatabaseService spatialDatabase;
    private Map<String, Long> newSimpleFeatures = new HashMap<String, Long>();

    public Neo4jSpatialDataStore(GraphDatabaseService database) {
        super(true);
        this.database = database;
        this.spatialDatabase = new SpatialDatabaseService(database);
    }

    public String[] getTypeNames() throws IOException {
        if (this.typeNames == null) {
            ArrayList<String> notEmptyTypes = new ArrayList<String>();
            String[] allTypeNames = this.spatialDatabase.getLayerNames();
            for (int i = 0; i < allTypeNames.length; ++i) {
                System.out.print("loading layer " + allTypeNames[i]);
                Layer layer = this.spatialDatabase.getLayer(allTypeNames[i]);
                if (layer.getIndex().isEmpty()) continue;
                notEmptyTypes.add(allTypeNames[i]);
            }
            this.typeNames = notEmptyTypes.toArray(new String[0]);
        }
        return this.typeNames;
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        SimpleFeatureType result = this.simpleFeatureTypeIndex.get(typeName);
        if (result == null) {
            Layer layer = this.spatialDatabase.getLayer(typeName);
            if (layer == null) {
                throw new IOException("Layer not found: " + typeName);
            }
            result = Neo4jFeatureBuilder.getTypeFromLayer(layer);
            this.simpleFeatureTypeIndex.put(typeName, result);
        }
        return result;
    }

    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        Object result = this.featureSourceIndex.get(typeName);
        if (result == null) {
            final SimpleFeatureType featureType = this.getSchema(typeName);
            if (this.getLockingManager() != null) {
                System.out.println("getFeatureSource(" + typeName + ") - locking manager is present");
                result = new AbstractFeatureLocking(this.getSupportedHints()){

                    public DataStore getDataStore() {
                        return Neo4jSpatialDataStore.this;
                    }

                    public void addFeatureListener(FeatureListener listener) {
                        Neo4jSpatialDataStore.this.listenerManager.addFeatureListener((FeatureSource)this, listener);
                    }

                    public void removeFeatureListener(FeatureListener listener) {
                        Neo4jSpatialDataStore.this.listenerManager.removeFeatureListener((FeatureSource)this, listener);
                    }

                    public SimpleFeatureType getSchema() {
                        return featureType;
                    }

                    public ReferencedEnvelope getBounds() throws IOException {
                        return Neo4jSpatialDataStore.this.getBounds(featureType.getTypeName());
                    }

                    public ResourceInfo getInfo() {
                        return Neo4jSpatialDataStore.this.getInfo(featureType.getTypeName());
                    }
                };
            } else {
                System.out.println("getFeatureSource(" + typeName + ") - locking manager is NOT present");
                result = new AbstractFeatureStore(this.getSupportedHints()){

                    public DataStore getDataStore() {
                        return Neo4jSpatialDataStore.this;
                    }

                    public void addFeatureListener(FeatureListener listener) {
                        Neo4jSpatialDataStore.this.listenerManager.addFeatureListener((FeatureSource)this, listener);
                    }

                    public void removeFeatureListener(FeatureListener listener) {
                        Neo4jSpatialDataStore.this.listenerManager.removeFeatureListener((FeatureSource)this, listener);
                    }

                    public SimpleFeatureType getSchema() {
                        return featureType;
                    }

                    public ReferencedEnvelope getBounds() throws IOException {
                        return Neo4jSpatialDataStore.this.getBounds(featureType.getTypeName());
                    }

                    public ResourceInfo getInfo() {
                        return Neo4jSpatialDataStore.this.getInfo(featureType.getTypeName());
                    }
                };
            }
            this.featureSourceIndex.put(typeName, (SimpleFeatureSource)result);
        }
        return result;
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        FeatureWriter writer;
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.INCLUDE?");
        }
        if (transaction == null) {
            throw new NullPointerException("getFeatureWriter requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        System.out.println("getFeatureWriter(" + typeName + "," + filter.getClass() + " " + filter + "," + transaction + ")");
        if (transaction == Transaction.AUTO_COMMIT) {
            try {
                writer = this.createFeatureWriter(typeName, filter, transaction);
            }
            catch (UnsupportedOperationException e) {
                try {
                    writer = this.getFeatureWriter(typeName, transaction);
                }
                catch (UnsupportedOperationException eek) {
                    throw e;
                }
            }
        } else {
            TransactionStateDiff state = this.state(transaction);
            if (state != null) {
                writer = state.writer(typeName, filter);
            } else {
                throw new UnsupportedOperationException("not implemented...");
            }
        }
        if (this.getLockingManager() != null) {
            writer = ((InProcessLockingManager)this.getLockingManager()).checkedWriter(writer, transaction);
        }
        if (filter != Filter.INCLUDE) {
            writer = new FilteringFeatureWriter(writer, filter);
        }
        return writer;
    }

    public ReferencedEnvelope getBounds(String typeName) {
        ReferencedEnvelope result = this.boundsIndex.get(typeName);
        if (result == null) {
            Envelope bbox = Utilities.fromNeo4jToJts(this.spatialDatabase.getLayer(typeName).getIndex().getBoundingBox());
            result = this.convertEnvelopeToRefEnvelope(typeName, bbox);
            this.boundsIndex.put(typeName, result);
        }
        return result;
    }

    public SpatialDatabaseService getSpatialDatabaseService() {
        return this.spatialDatabase;
    }

    public org.neo4j.graphdb.Transaction beginTx() {
        return this.database.beginTx();
    }

    public void clearCache() {
        this.typeNames = null;
        this.simpleFeatureTypeIndex.clear();
        this.crsIndex.clear();
        this.styleIndex.clear();
        this.boundsIndex.clear();
        this.featureSourceIndex.clear();
    }

    public void dispose() {
        this.database.shutdown();
        super.dispose();
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName, Query query) throws IOException {
        System.out.println("getFeatureReader(" + typeName + "," + query.getFilter().getClass() + " " + query.getFilter() + ")");
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = null;
        if (query != null && query.getTypeName() != null) {
            Filter filter = query.getFilter();
            reader = this.getFeatureReader(typeName, filter);
        }
        if (reader == null) {
            reader = super.getFeatureReader(typeName, query);
        }
        return reader;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName, Filter filter) throws IOException {
        Iterator<SpatialDatabaseRecord> records;
        Layer layer = this.spatialDatabase.getLayer(typeName);
        if (filter.equals(Filter.EXCLUDE)) {
            records = null;
        } else if (filter instanceof FidFilterImpl) {
            List<SpatialDatabaseRecord> results = layer.getIndex().get(this.convertToGeomNodeIds((FidFilterImpl)filter));
            System.out.println("found results for FidFilter: " + results.size());
            records = results.iterator();
        } else {
            records = layer.getIndex().search(new SearchCQL(layer, filter));
        }
        return new Neo4jSpatialFeatureReader(layer, this.getSchema(typeName), records);
    }

    protected ResourceInfo getInfo(String typeName) {
        return new DefaultResourceInfo(typeName, this.getCRS(typeName), this.getBounds(typeName));
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName) throws IOException {
        System.out.println("getFeatureReader(" + typeName + ") SLOW QUERY :(");
        return this.getFeatureReader(typeName, (SearchFilter)new SearchAll());
    }

    private FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName, SearchFilter search) throws IOException {
        Layer layer = this.spatialDatabase.getLayer(typeName);
        SearchRecords results = layer.getIndex().search(search);
        return new Neo4jSpatialFeatureReader(layer, this.getSchema(typeName), results);
    }

    private ReferencedEnvelope convertEnvelopeToRefEnvelope(String typeName, Envelope bbox) {
        return new ReferencedEnvelope(bbox, this.getCRS(typeName));
    }

    private CoordinateReferenceSystem getCRS(String typeName) {
        CoordinateReferenceSystem result = this.crsIndex.get(typeName);
        if (result == null) {
            Layer layer = this.spatialDatabase.getLayer(typeName);
            result = layer.getCoordinateReferenceSystem();
            this.crsIndex.put(typeName, result);
        }
        return result;
    }

    public Style getStyle(String typeName) {
        Style result = this.styleIndex.get(typeName);
        Layer layer = this.spatialDatabase.getLayer(typeName);
        Object obj = layer.getStyle();
        if (!(obj instanceof Style) && (obj instanceof File || obj instanceof String)) {
            StyleFactoryImpl styleFactory = new StyleFactoryImpl();
            SLDParser parser = new SLDParser((StyleFactory)styleFactory);
            try {
                if (obj instanceof File) {
                    parser.setInput((Reader)new FileReader((File)obj));
                } else {
                    parser.setInput((Reader)new StringReader(obj.toString()));
                }
                Style[] styles = parser.readXML();
                result = styles[0];
            }
            catch (Exception e) {
                System.err.println("Error loading style '" + obj + "': " + e.getMessage());
                e.printStackTrace(System.err);
            }
        }
        this.styleIndex.put(typeName, result);
        return result;
    }

    private Integer getGeometryType(String typeName) {
        Layer layer = this.spatialDatabase.getLayer(typeName);
        return layer.getGeometryType();
    }

    private EditableLayer getEditableLayer(String typeName) throws IOException {
        Layer layer = this.spatialDatabase.getLayer(typeName);
        if (layer == null) {
            throw new IOException("Layer not found: " + typeName);
        }
        if (!(layer instanceof EditableLayer)) {
            throw new IOException("Cannot create a FeatureWriter on a read-only layer: " + layer);
        }
        return (EditableLayer)layer;
    }

    private Set<Long> convertToGeomNodeIds(FidFilterImpl fidFilter) {
        HashSet<Long> nodeIds = new HashSet<Long>();
        Set ids = fidFilter.getIDs();
        for (String id : ids) {
            if (this.newSimpleFeatures.containsKey(id)) {
                nodeIds.add(this.newSimpleFeatures.get(id));
                continue;
            }
            try {
                nodeIds.add(new Long(id));
            }
            catch (NumberFormatException e) {
                System.out.println("Neo4j Invalid FID: " + id);
            }
        }
        return nodeIds;
    }

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.getFeatureReader(typeName, filter);
        if (reader == null) {
            reader = this.getFeatureReader(typeName, (SearchFilter)new SearchAll());
        }
        return new Neo4jSpatialFeatureWriter(this.listenerManager, transaction, this.getEditableLayer(typeName), reader);
    }

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return new Neo4jSpatialFeatureWriter(this.listenerManager, transaction, this.getEditableLayer(typeName), this.getFeatureReader(typeName, (SearchFilter)new SearchAll()));
    }
}

