/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import com.vividsolutions.jts.geom.Geometry;
import org.apache.commons.lang.ArrayUtils;
import org.neo4j.collections.rtree.Envelope;
import org.neo4j.gis.spatial.Constants;
import org.neo4j.gis.spatial.GeometryEncoder;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.Utilities;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;

public abstract class AbstractGeometryEncoder
implements GeometryEncoder,
Constants {
    protected Layer layer;

    @Override
    public void init(Layer layer) {
        this.layer = layer;
    }

    public void encodeEnvelope(Envelope mbb, PropertyContainer container) {
        container.setProperty("bbox", (Object)new double[]{mbb.getMinX(), mbb.getMinY(), mbb.getMaxX(), mbb.getMaxY()});
    }

    @Override
    public void encodeGeometry(Geometry geometry, PropertyContainer container) {
        container.setProperty("gtype", (Object)this.encodeGeometryType(geometry.getGeometryType()));
        this.encodeEnvelope(Utilities.fromJtsToNeo4j(geometry.getEnvelopeInternal()), container);
        this.encodeGeometryShape(geometry, container);
    }

    public Envelope decodeEnvelope(PropertyContainer container) {
        double[] bbox = new double[]{0.0, 0.0, 0.0, 0.0};
        Object bboxProp = container.getProperty("bbox");
        if (bboxProp instanceof Double[]) {
            bbox = ArrayUtils.toPrimitive((Double[])((Double[])bboxProp));
        } else if (bboxProp instanceof double[]) {
            bbox = (double[])bboxProp;
        }
        return new Envelope(bbox[0], bbox[2], bbox[1], bbox[3]);
    }

    protected abstract void encodeGeometryShape(Geometry var1, PropertyContainer var2);

    protected Integer encodeGeometryType(String jtsGeometryType) {
        if ("Point".equals(jtsGeometryType)) {
            return 1;
        }
        if ("MultiPoint".equals(jtsGeometryType)) {
            return 4;
        }
        if ("LineString".equals(jtsGeometryType)) {
            return 2;
        }
        if ("MultiLineString".equals(jtsGeometryType)) {
            return 5;
        }
        if ("Polygon".equals(jtsGeometryType)) {
            return 3;
        }
        if ("MultiPolygon".equals(jtsGeometryType)) {
            return 6;
        }
        throw new IllegalArgumentException("unknown type:" + jtsGeometryType);
    }

    @Override
    public boolean hasAttribute(Node geomNode, String name) {
        return geomNode.hasProperty(name);
    }

    @Override
    public Object getAttribute(Node geomNode, String name) {
        return geomNode.getProperty(name, null);
    }
}

