/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import java.io.PrintStream;
import org.neo4j.collections.rtree.Listener;

public class ConsoleListener
implements Listener {
    private PrintStream out;
    private int total = 0;
    private int current = 0;

    public ConsoleListener() {
        this(System.out);
    }

    public ConsoleListener(PrintStream out) {
        this.out = out;
    }

    public void begin(int unitsOfWork) {
        this.total = unitsOfWork;
        this.current = 0;
    }

    public void worked(int workedSinceLastNotification) {
        this.current += workedSinceLastNotification;
        if (this.total < 1) {
            this.out.println("Completed " + this.current);
        } else if (this.total == 100) {
            this.out.println("" + this.current + "%: completed");
        } else {
            int perc = (int)(100.0 * (double)this.current / (double)this.total);
            this.out.println("" + perc + "%: completed " + this.current + " / " + this.total);
        }
    }

    public void done() {
    }
}

