/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.neo4j.gis.spatial.DynamicLayerConfig;
import org.neo4j.gis.spatial.EditableLayerImpl;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.SpatialDatabaseException;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.gis.spatial.SpatialRelationshipTypes;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;

public class DynamicLayer
extends EditableLayerImpl {
    private LinkedHashMap<String, Layer> layers;

    private synchronized Map<String, Layer> getLayerMap() {
        if (this.layers == null) {
            this.layers = new LinkedHashMap();
            this.layers.put(this.getName(), this);
            for (Relationship rel : this.layerNode.getRelationships((RelationshipType)SpatialRelationshipTypes.LAYER_CONFIG, Direction.OUTGOING)) {
                DynamicLayerConfig config = new DynamicLayerConfig(this, rel.getEndNode());
                this.layers.put(config.getName(), config);
            }
        }
        return this.layers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeLayerConfig(String name) {
        Layer layer = this.getLayerMap().get(name);
        if (layer != null && layer instanceof DynamicLayerConfig) {
            DynamicLayer dynamicLayer = this;
            synchronized (dynamicLayer) {
                DynamicLayerConfig config = (DynamicLayerConfig)layer;
                this.layers = null;
                Transaction tx = config.configNode.getGraphDatabase().beginTx();
                try {
                    config.configNode.getSingleRelationship((RelationshipType)SpatialRelationshipTypes.LAYER_CONFIG, Direction.INCOMING).delete();
                    config.configNode.delete();
                    tx.success();
                }
                finally {
                    tx.finish();
                }
                return true;
            }
        }
        if (layer == null) {
            System.out.println("Dynamic layer not found: " + name);
            return false;
        }
        System.out.println("Layer is not dynamic and cannot be deleted: " + name);
        return false;
    }

    private static String makeGeometryName(int gtype) {
        return SpatialDatabaseService.convertGeometryTypeToName(gtype);
    }

    private static String makeGeometryCQL(int gtype) {
        return "geometryType(the_geom) = '" + DynamicLayer.makeGeometryName(gtype) + "'";
    }

    public DynamicLayerConfig addCQLDynamicLayerOnGeometryType(int gtype) {
        return this.addLayerConfig("CQL:" + DynamicLayer.makeGeometryName(gtype), gtype, DynamicLayer.makeGeometryCQL(gtype));
    }

    public DynamicLayerConfig addCQLDynamicLayerOnAttribute(String key, String value, int gtype) {
        if (value == null) {
            return this.addLayerConfig("CQL:" + key, gtype, key + " IS NOT NULL AND " + DynamicLayer.makeGeometryCQL(gtype));
        }
        return this.addCQLDynamicLayerOnAttributes(new String[]{key, value}, gtype);
    }

    public DynamicLayerConfig addCQLDynamicLayerOnAttributes(String[] attributes, int gtype) {
        if (attributes == null) {
            return this.addCQLDynamicLayerOnGeometryType(gtype);
        }
        StringBuffer name = new StringBuffer();
        StringBuffer query = new StringBuffer();
        if (gtype != 0) {
            query.append(DynamicLayer.makeGeometryCQL(gtype));
        }
        for (int i = 0; i < attributes.length; i += 2) {
            String key = attributes[i];
            if (name.length() > 0) {
                name.append("-");
            }
            if (query.length() > 0) {
                query.append(" AND ");
            }
            if (attributes.length > i) {
                String value = attributes[i + 1];
                name.append(key).append("-").append(value);
                query.append(key).append(" = '").append(value).append("'");
                continue;
            }
            name.append(key);
            query.append(key).append(" IS NOT NULL");
        }
        return this.addLayerConfig("CQL:" + name.toString(), gtype, query.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicLayerConfig addLayerConfig(String name, int type, String query) {
        Layer layer;
        if (!query.startsWith("{")) {
            try {
                ECQL.toFilter((String)query);
            }
            catch (CQLException e) {
                throw new SpatialDatabaseException("DynamicLayer query is not JSON and not valid CQL: " + query, e);
            }
        }
        if ((layer = this.getLayerMap().get(name)) != null) {
            if (layer instanceof DynamicLayerConfig) {
                DynamicLayerConfig config = (DynamicLayerConfig)layer;
                if (config.getGeometryType() != type || !config.getQuery().equals(query)) {
                    System.err.println("Existing LayerConfig with different geometry type or query: " + config);
                    return null;
                }
                return config;
            }
            System.err.println("Existing Layer has same name as requested LayerConfig: " + layer.getName());
            return null;
        }
        DynamicLayer dynamicLayer = this;
        synchronized (dynamicLayer) {
            DynamicLayerConfig config = new DynamicLayerConfig(this, name, type, query);
            this.layers = null;
            return config;
        }
    }

    public DynamicLayerConfig restrictLayerProperties(String name, String[] names) {
        Layer layer = this.getLayerMap().get(name);
        if (layer != null) {
            if (layer instanceof DynamicLayerConfig) {
                DynamicLayerConfig config = (DynamicLayerConfig)layer;
                if (names == null) {
                    config.restrictLayerProperties();
                } else {
                    config.setExtraPropertyNames(names);
                }
                return config;
            }
            System.err.println("Existing Layer has same name as requested LayerConfig: " + layer.getName());
            return null;
        }
        System.err.println("No such layer: " + name);
        return null;
    }

    public DynamicLayerConfig restrictLayerProperties(String name) {
        return this.restrictLayerProperties(name, null);
    }

    public List<String> getLayerNames() {
        return new ArrayList<String>(this.getLayerMap().keySet());
    }

    public List<Layer> getLayers() {
        return new ArrayList<Layer>(this.getLayerMap().values());
    }

    public Layer getLayer(String name) {
        return this.getLayerMap().get(name);
    }
}

