/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.File;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import org.geotools.filter.text.cql2.CQLException;
import org.neo4j.collections.rtree.Envelope;
import org.neo4j.collections.rtree.Listener;
import org.neo4j.collections.rtree.filter.SearchFilter;
import org.neo4j.gis.spatial.Constants;
import org.neo4j.gis.spatial.DynamicLayer;
import org.neo4j.gis.spatial.GeometryEncoder;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.LayerIndexReader;
import org.neo4j.gis.spatial.LayerTreeIndexReader;
import org.neo4j.gis.spatial.SpatialDatabaseException;
import org.neo4j.gis.spatial.SpatialDatabaseRecord;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.gis.spatial.SpatialDataset;
import org.neo4j.gis.spatial.SpatialRelationshipTypes;
import org.neo4j.gis.spatial.attributes.PropertyMappingManager;
import org.neo4j.gis.spatial.indexfilter.CQLIndexReader;
import org.neo4j.gis.spatial.indexfilter.DynamicIndexReader;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DynamicLayerConfig
implements Layer,
Constants {
    private DynamicLayer parent;
    protected Node configNode;
    private String[] propertyNames;
    private PropertyMappingManager propertyMappingManager;

    public DynamicLayerConfig(DynamicLayer parent, Node configNode) {
        this.parent = parent;
        this.configNode = configNode;
        this.propertyNames = (String[])configNode.getProperty("propertyNames", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicLayerConfig(DynamicLayer parent, String name, int geometryType, String query) {
        this.parent = parent;
        GraphDatabaseService database = parent.getSpatialDatabase().getDatabase();
        Transaction tx = database.beginTx();
        try {
            Node node = database.createNode();
            node.setProperty("layer", (Object)name);
            node.setProperty("gtype", (Object)geometryType);
            node.setProperty("query", (Object)query);
            parent.getLayerNode().createRelationshipTo(node, (RelationshipType)SpatialRelationshipTypes.LAYER_CONFIG);
            tx.success();
            this.configNode = node;
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public String getName() {
        return (String)this.configNode.getProperty("layer");
    }

    public String getQuery() {
        return (String)this.configNode.getProperty("query");
    }

    @Override
    public SpatialDatabaseRecord add(Node geomNode) {
        throw new SpatialDatabaseException("Cannot add nodes to dynamic layers, add the node to the base layer instead");
    }

    @Override
    public void delete(Listener monitor) {
        throw new SpatialDatabaseException("Cannot delete dynamic layers, delete the base layer instead");
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.parent.getCoordinateReferenceSystem();
    }

    @Override
    public SpatialDataset getDataset() {
        return this.parent.getDataset();
    }

    @Override
    public String[] getExtraPropertyNames() {
        if (this.propertyNames != null && this.propertyNames.length > 0) {
            return this.propertyNames;
        }
        return this.parent.getExtraPropertyNames();
    }

    public void restrictLayerProperties() {
        if (this.propertyNames != null && this.propertyNames.length > 0) {
            System.out.println("Restricted property names already exists - will be overwritten");
        }
        System.out.println("Before property scan we have " + this.getExtraPropertyNames().length + " known attributes for layer " + this.getName());
        PropertyUsageSearch search = new PropertyUsageSearch(this);
        this.getIndex().searchIndex(search).count();
        this.setExtraPropertyNames(search.getNames());
        System.out.println("After property scan of " + search.getNodeCount() + " nodes, we have " + this.getExtraPropertyNames().length + " known attributes for layer " + this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtraPropertyNames(String[] names) {
        Transaction tx = this.configNode.getGraphDatabase().beginTx();
        try {
            this.configNode.setProperty("propertyNames", (Object)names);
            this.propertyNames = names;
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public GeometryEncoder getGeometryEncoder() {
        return this.parent.getGeometryEncoder();
    }

    @Override
    public GeometryFactory getGeometryFactory() {
        return this.parent.getGeometryFactory();
    }

    @Override
    public Integer getGeometryType() {
        return (Integer)this.configNode.getProperty("gtype");
    }

    @Override
    public LayerIndexReader getIndex() {
        if (this.parent.index instanceof LayerTreeIndexReader) {
            String query = this.getQuery();
            if (query.startsWith("{")) {
                return new DynamicIndexReader(this.parent.index, query);
            }
            try {
                return new CQLIndexReader(this.parent.index, this, query);
            }
            catch (CQLException e) {
                throw new SpatialDatabaseException("Error while creating CQL based DynamicLayer", e);
            }
        }
        throw new SpatialDatabaseException("Cannot make a DynamicLayer from a non-LayerTreeIndexReader Layer");
    }

    @Override
    public Node getLayerNode() {
        return this.parent.getLayerNode();
    }

    @Override
    public SpatialDatabaseService getSpatialDatabase() {
        return this.parent.getSpatialDatabase();
    }

    @Override
    public void initialize(SpatialDatabaseService spatialDatabase, String name, Node layerNode) {
        throw new SpatialDatabaseException("Cannot initialize the layer config, initialize only the dynamic layer node");
    }

    @Override
    public Object getStyle() {
        File parent;
        File newStyle;
        Object style = this.parent.getStyle();
        if (style != null && style instanceof File && (newStyle = new File(parent = ((File)style).getParentFile(), this.getName() + ".sld")).canRead()) {
            style = newStyle;
        }
        return style;
    }

    public Layer getParent() {
        return this.parent;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public PropertyMappingManager getPropertyMappingManager() {
        if (this.propertyMappingManager == null) {
            this.propertyMappingManager = new PropertyMappingManager(this);
        }
        return this.propertyMappingManager;
    }

    private class PropertyUsageSearch
    implements SearchFilter {
        private Layer layer;
        private LinkedHashMap<String, Integer> names = new LinkedHashMap();
        private int nodeCount = 0;
        private int MAX_COUNT = 10000;

        public PropertyUsageSearch(Layer layer) {
            this.layer = layer;
        }

        public boolean needsToVisit(Envelope indexNodeEnvelope) {
            return this.nodeCount < this.MAX_COUNT;
        }

        public boolean geometryMatches(Node geomNode) {
            if (this.nodeCount++ < this.MAX_COUNT) {
                SpatialDatabaseRecord record = new SpatialDatabaseRecord(this.layer, geomNode);
                for (String name : record.getPropertyNames()) {
                    Object value = record.getProperty(name);
                    if (value == null) continue;
                    Integer count = this.names.get(name);
                    if (count == null) {
                        count = 0;
                    }
                    this.names.put(name, count + 1);
                }
            }
            return false;
        }

        public String[] getNames() {
            return this.names.keySet().toArray(new String[0]);
        }

        public int getNodeCount() {
            return this.nodeCount;
        }

        public void describeUsage(PrintStream out) {
            for (String name : this.names.keySet()) {
                System.out.println(name + "\t" + this.names.get(name));
            }
        }
    }
}

