/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Iterator;
import org.neo4j.gis.spatial.DefaultLayer;
import org.neo4j.gis.spatial.EditableLayer;
import org.neo4j.gis.spatial.SpatialDatabaseRecord;
import org.neo4j.gis.spatial.SpatialRelationshipTypes;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.kernel.Traversal;

public class EditableLayerImpl
extends DefaultLayer
implements EditableLayer {
    private Node previousGeomNode;

    @Override
    public SpatialDatabaseRecord add(Geometry geometry) {
        return this.add(geometry, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpatialDatabaseRecord add(Geometry geometry, String[] fieldsName, Object[] fields) {
        Transaction tx = this.getDatabase().beginTx();
        try {
            Node geomNode = this.addGeomNode(geometry, fieldsName, fields);
            this.index.add(geomNode);
            tx.success();
            SpatialDatabaseRecord spatialDatabaseRecord = new SpatialDatabaseRecord(this, geomNode, geometry);
            return spatialDatabaseRecord;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(long geomNodeId, Geometry geometry) {
        Transaction tx = this.getDatabase().beginTx();
        try {
            this.index.remove(geomNodeId, false);
            Node geomNode = this.getDatabase().getNodeById(geomNodeId);
            this.getGeometryEncoder().encodeGeometry(geometry, (PropertyContainer)geomNode);
            this.index.add(geomNode);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(long geomNodeId) {
        Transaction tx = this.getDatabase().beginTx();
        try {
            this.index.remove(geomNodeId, true, false);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromIndex(long geomNodeId) {
        Transaction tx = this.getDatabase().beginTx();
        try {
            boolean deleteGeomNode = false;
            this.index.remove(geomNodeId, false, false);
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private Node addGeomNode(Geometry geom, String[] fieldsName, Object[] fields) {
        Node geomNode = this.getDatabase().createNode();
        if (this.previousGeomNode == null) {
            Iterator i$ = Traversal.description().order(Traversal.postorderBreadthFirst()).relationships((RelationshipType)SpatialRelationshipTypes.GEOMETRIES, Direction.INCOMING).relationships((RelationshipType)SpatialRelationshipTypes.NEXT_GEOM, Direction.INCOMING).evaluator(Evaluators.excludeStartPosition()).traverse(this.layerNode).nodes().iterator();
            while (i$.hasNext()) {
                Node node;
                this.previousGeomNode = node = (Node)i$.next();
            }
        }
        if (this.previousGeomNode != null) {
            this.previousGeomNode.createRelationshipTo(geomNode, (RelationshipType)SpatialRelationshipTypes.NEXT_GEOM);
        } else {
            this.layerNode.createRelationshipTo(geomNode, (RelationshipType)SpatialRelationshipTypes.GEOMETRIES);
        }
        this.previousGeomNode = geomNode;
        if (fieldsName != null) {
            for (int i = 0; i < fieldsName.length; ++i) {
                geomNode.setProperty(fieldsName[i], fields[i]);
            }
        }
        this.getGeometryEncoder().encodeGeometry(geom, (PropertyContainer)geomNode);
        return geomNode;
    }
}

