/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import org.neo4j.collections.rtree.filter.SearchFilter;
import org.neo4j.gis.spatial.EditableLayer;
import org.neo4j.gis.spatial.SpatialDatabaseRecord;
import org.neo4j.gis.spatial.SpatialRelationshipTypes;
import org.neo4j.gis.spatial.filter.SearchIntersect;
import org.neo4j.gis.spatial.filter.SearchRecords;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;

public class LineStringNetworkGenerator {
    private EditableLayer pointsLayer;
    private EditableLayer edgesLayer;
    private Double buffer;

    public LineStringNetworkGenerator(EditableLayer pointsLayer, EditableLayer edgesLayer) {
        this(pointsLayer, edgesLayer, null);
    }

    public LineStringNetworkGenerator(EditableLayer pointsLayer, EditableLayer edgesLayer, Double buffer) {
        this.pointsLayer = pointsLayer;
        this.edgesLayer = edgesLayer;
        this.buffer = buffer;
    }

    public void add(SpatialDatabaseRecord record) {
        Geometry geometry = record.getGeometry();
        if (geometry instanceof MultiLineString) {
            this.add((MultiLineString)geometry, record);
        } else if (geometry instanceof LineString) {
            this.add((LineString)geometry, record);
        } else {
            throw new IllegalArgumentException("geometry type not supported: " + geometry.getGeometryType());
        }
    }

    public void add(MultiLineString lines) {
        this.add(lines, null);
    }

    public void add(LineString line) {
        this.add(line, null);
    }

    protected void add(MultiLineString line, SpatialDatabaseRecord record) {
        for (int i = 0; i < line.getNumGeometries(); ++i) {
            this.add((LineString)line.getGeometryN(i), record);
        }
    }

    protected void add(LineString line, SpatialDatabaseRecord edge) {
        if (edge == null) {
            edge = this.edgesLayer.add((Geometry)line);
        }
        edge.setProperty("_network_length", edge.getGeometry().getLength());
        this.addEdgePoint(edge.getGeomNode(), (Geometry)line.getStartPoint());
        this.addEdgePoint(edge.getGeomNode(), (Geometry)line.getEndPoint());
    }

    protected void addEdgePoint(Node edge, Geometry edgePoint) {
        SearchRecords results;
        if (this.buffer != null) {
            edgePoint = edgePoint.buffer(this.buffer.doubleValue());
        }
        if (!(results = this.pointsLayer.getIndex().search((SearchFilter)new SearchIntersect(this.pointsLayer, edgePoint))).hasNext()) {
            SpatialDatabaseRecord point = this.pointsLayer.add(edgePoint);
            edge.createRelationshipTo(point.getGeomNode(), (RelationshipType)SpatialRelationshipTypes.NETWORK);
        } else {
            while (results.hasNext()) {
                edge.createRelationshipTo(((SpatialDatabaseRecord)results.next()).getGeomNode(), (RelationshipType)SpatialRelationshipTypes.NETWORK);
            }
        }
    }
}

