/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.geotools.data.FeatureStore;
import org.geotools.data.neo4j.Neo4jSpatialDataStore;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.FeatureCollection;
import org.neo4j.graphdb.GraphDatabaseService;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapefileExporter {
    Neo4jSpatialDataStore neo4jDataStore;
    File exportDir;

    public ShapefileExporter(GraphDatabaseService db) {
        this.neo4jDataStore = new Neo4jSpatialDataStore(db);
        this.exportDir = null;
    }

    public void setExportDir(String dir) {
        this.exportDir = dir == null || dir.length() == 0 ? null : new File(dir).getAbsoluteFile();
    }

    public File exportLayer(String layerName) throws Exception {
        String fileName = layerName.replace(" ", "-");
        return this.exportLayer(layerName, fileName + ".shp");
    }

    public File exportLayer(String layerName, String fileName) throws Exception {
        return this.exportLayer(layerName, new File(fileName));
    }

    private File checkFile(File file) {
        if (!file.isAbsolute() && this.exportDir != null) {
            file = new File(this.exportDir, file.getPath());
        }
        file = file.getAbsoluteFile();
        file.getParentFile().mkdirs();
        if (file.exists()) {
            System.out.println("Deleting previous file: " + file);
            file.delete();
        }
        return file;
    }

    public File exportLayer(String layerName, File file) throws Exception {
        file = this.checkFile(file);
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        HashMap<String, Object> create = new HashMap<String, Object>();
        URL url = file.toURI().toURL();
        create.put("url", url);
        create.put("create spatial index", Boolean.TRUE);
        create.put("charset", "UTF-8");
        ShapefileDataStore shpDataStore = (ShapefileDataStore)factory.createNewDataStore(create);
        SimpleFeatureType featureType = this.neo4jDataStore.getSchema(layerName);
        GeometryDescriptor geometryType = featureType.getGeometryDescriptor();
        CoordinateReferenceSystem crs = geometryType.getCoordinateReferenceSystem();
        shpDataStore.createSchema(featureType);
        FeatureStore store = (FeatureStore)shpDataStore.getFeatureSource();
        store.addFeatures((FeatureCollection)this.neo4jDataStore.getFeatureSource(layerName).getFeatures());
        if (crs != null) {
            shpDataStore.forceSchemaCRS(crs);
        }
        if (!file.exists()) {
            throw new Exception("Shapefile was not created: " + file);
        }
        if (file.length() < 10L) {
            throw new Exception("Shapefile was unexpectedly small, only " + file.length() + " bytes: " + file);
        }
        return file;
    }
}

