/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Iterator;
import org.geotools.filter.AndImpl;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.spatial.BBOXImpl;
import org.geotools.filter.spatial.ContainsImpl;
import org.geotools.filter.spatial.CrossesImpl;
import org.geotools.filter.spatial.EqualsImpl;
import org.geotools.filter.spatial.IntersectsImpl;
import org.geotools.filter.spatial.OverlapsImpl;
import org.geotools.filter.spatial.TouchesImpl;
import org.geotools.filter.spatial.WithinImpl;
import org.opengis.filter.Filter;

public class Utilities {
    public static org.neo4j.collections.rtree.Envelope fromJtsToNeo4j(Envelope envelope) {
        return new org.neo4j.collections.rtree.Envelope(envelope.getMinX(), envelope.getMaxX(), envelope.getMinY(), envelope.getMaxY());
    }

    public static Envelope fromNeo4jToJts(org.neo4j.collections.rtree.Envelope envelope) {
        return new Envelope(envelope.getMinX(), envelope.getMaxX(), envelope.getMinY(), envelope.getMaxY());
    }

    public static org.neo4j.collections.rtree.Envelope extractEnvelopeFromFilter(Filter filter) {
        return Utilities.extractEnvelopeFromFilter(filter, true);
    }

    private static org.neo4j.collections.rtree.Envelope extractEnvelopeFromFilter(Filter filter, boolean inspectAndFilters) {
        if (filter instanceof BBOXImpl) {
            return Utilities.extractEnvelopeFromBBox((BBOXImpl)filter);
        }
        if (filter instanceof IntersectsImpl || filter instanceof ContainsImpl || filter instanceof CrossesImpl || filter instanceof EqualsImpl || filter instanceof OverlapsImpl || filter instanceof TouchesImpl || filter instanceof WithinImpl) {
            return Utilities.extractEnvelopeFromGeometryFilter((GeometryFilter)filter);
        }
        if (filter instanceof AndImpl && inspectAndFilters) {
            AndImpl andFilter = (AndImpl)filter;
            Iterator children = andFilter.getFilterIterator();
            while (children.hasNext()) {
                Filter child = (Filter)children.next();
                org.neo4j.collections.rtree.Envelope result = Utilities.extractEnvelopeFromFilter(child, false);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private static org.neo4j.collections.rtree.Envelope extractEnvelopeFromGeometryFilter(GeometryFilter intersectFilter) {
        if (intersectFilter.getLeftGeometry() instanceof LiteralExpressionImpl) {
            return Utilities.extractEnvelopeFromLiteralExpression((LiteralExpressionImpl)intersectFilter.getLeftGeometry());
        }
        if (intersectFilter.getRightGeometry() instanceof LiteralExpressionImpl) {
            return Utilities.extractEnvelopeFromLiteralExpression((LiteralExpressionImpl)intersectFilter.getRightGeometry());
        }
        return null;
    }

    private static org.neo4j.collections.rtree.Envelope extractEnvelopeFromLiteralExpression(LiteralExpressionImpl exp) {
        if (exp.getValue() instanceof Geometry) {
            return Utilities.fromJtsToNeo4j(((Geometry)exp.getValue()).getEnvelopeInternal());
        }
        return null;
    }

    private static org.neo4j.collections.rtree.Envelope extractEnvelopeFromBBox(BBOXImpl bbox) {
        return new org.neo4j.collections.rtree.Envelope(bbox.getMinX(), bbox.getMaxX(), bbox.getMinY(), bbox.getMaxY());
    }
}

