/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.indexfilter;

import org.geotools.data.neo4j.Neo4jFeatureBuilder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.neo4j.collections.rtree.Envelope;
import org.neo4j.collections.rtree.SpatialIndexRecordCounter;
import org.neo4j.collections.rtree.SpatialIndexVisitor;
import org.neo4j.collections.rtree.filter.SearchFilter;
import org.neo4j.collections.rtree.filter.SearchResults;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.LayerTreeIndexReader;
import org.neo4j.gis.spatial.SpatialDatabaseRecord;
import org.neo4j.gis.spatial.Utilities;
import org.neo4j.gis.spatial.filter.SearchRecords;
import org.neo4j.gis.spatial.indexfilter.LayerIndexReaderWrapper;
import org.neo4j.graphdb.Node;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class CQLIndexReader
extends LayerIndexReaderWrapper {
    private final Filter filter;
    private final Envelope filterEnvelope;
    private final Neo4jFeatureBuilder builder;
    private final Layer layer;

    public CQLIndexReader(LayerTreeIndexReader index, Layer layer, String query) throws CQLException {
        super(index);
        this.filter = ECQL.toFilter((String)query);
        this.builder = new Neo4jFeatureBuilder(layer);
        this.layer = layer;
        this.filterEnvelope = Utilities.extractEnvelopeFromFilter(this.filter);
    }

    private boolean queryIndexNode(Envelope indexNodeEnvelope) {
        return this.filterEnvelope == null || this.filterEnvelope.intersects(indexNodeEnvelope);
    }

    private boolean queryLeafNode(Node indexNode) {
        SpatialDatabaseRecord dbRecord = new SpatialDatabaseRecord(this.layer, indexNode);
        SimpleFeature feature = this.builder.buildFeature(dbRecord);
        return this.filter.evaluate((Object)feature);
    }

    @Override
    public int count() {
        Counter counter = new Counter();
        this.index.visit((SpatialIndexVisitor)counter, this.index.getIndexRoot());
        return counter.getResult();
    }

    private SearchFilter wrapSearchFilter(final SearchFilter filter) {
        return new SearchFilter(){

            public boolean needsToVisit(Envelope envelope) {
                return CQLIndexReader.this.queryIndexNode(envelope) && filter.needsToVisit(envelope);
            }

            public boolean geometryMatches(Node geomNode) {
                return CQLIndexReader.this.queryLeafNode(geomNode) && filter.geometryMatches(geomNode);
            }
        };
    }

    @Override
    public SearchResults searchIndex(SearchFilter filter) {
        return this.index.searchIndex(this.wrapSearchFilter(filter));
    }

    @Override
    public SearchRecords search(SearchFilter filter) {
        return this.index.search(this.wrapSearchFilter(filter));
    }

    private class Counter
    extends SpatialIndexRecordCounter {
        private Counter() {
        }

        public boolean needsToVisit(Envelope indexNodeEnvelope) {
            return CQLIndexReader.this.queryIndexNode(indexNodeEnvelope);
        }

        public void onIndexReference(Node geomNode) {
            if (CQLIndexReader.this.queryLeafNode(geomNode)) {
                super.onIndexReference(geomNode);
            }
        }
    }
}

