/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.indexprovider;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.json.simple.parser.JSONParser;
import org.neo4j.gis.spatial.EditableLayer;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.SpatialDatabaseRecord;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.gis.spatial.SpatialRelationshipTypes;
import org.neo4j.gis.spatial.indexprovider.SpatialRecordHits;
import org.neo4j.gis.spatial.pipes.GeoPipeline;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.Traversal;

public class LayerNodeIndex
implements Index<Node> {
    public static final String LON_PROPERTY_KEY = "lon";
    public static final String LAT_PROPERTY_KEY = "lat";
    public static final String WITHIN_QUERY = "within";
    public static final String CQL_QUERY = "CQL";
    public static final String WITHIN_DISTANCE_QUERY = "withinDistance";
    public static final String BBOX_QUERY = "bbox";
    public static final String ENVELOPE_PARAMETER = "envelope";
    public static final String GEOMETRY_PARAMETER = "envelope";
    public static final String POINT_PARAMETER = "point";
    public static final String DISTANCE_IN_KM_PARAMETER = "distanceInKm";
    public static final String WKT_PROPERTY_KEY = "wkt";
    public static final String WITHIN_WKT_GEOMETRY_QUERY = "withinWKTGeometry";
    private final String layerName;
    private final GraphDatabaseService db;
    private SpatialDatabaseService spatialDB;
    private EditableLayer layer;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LayerNodeIndex(String indexName, GraphDatabaseService db, Map<String, String> config) {
        this.layerName = indexName;
        this.db = db;
        this.spatialDB = new SpatialDatabaseService(this.db);
        if (config.containsKey("geometry_type") && config.get("geometry_type").equals(POINT_PARAMETER)) {
            if (config.containsKey(LAT_PROPERTY_KEY) && config.containsKey(LON_PROPERTY_KEY)) {
                this.layer = this.spatialDB.getOrCreatePointLayer(indexName, config.get(LON_PROPERTY_KEY), config.get(LAT_PROPERTY_KEY));
                return;
            } else {
                if (!config.containsKey(WKT_PROPERTY_KEY)) throw new IllegalArgumentException("Need to provide lat/lon or wkt property config");
                this.layer = this.spatialDB.getOrCreateEditableLayer(indexName, config.get(WKT_PROPERTY_KEY));
            }
            return;
        } else {
            this.layer = this.spatialDB.getOrCreateEditableLayer(this.layerName);
        }
    }

    public String getName() {
        return this.layerName;
    }

    public Class<Node> getEntityType() {
        return Node.class;
    }

    public void add(Node geometry, String key, Object value) {
        Geometry decodeGeometry = this.layer.getGeometryEncoder().decodeGeometry((PropertyContainer)geometry);
        Node matchingNode = (Node)IteratorUtil.firstOrNull((Iterable)Traversal.description().breadthFirst().evaluator(Evaluators.excludeStartPosition()).evaluator((Evaluator)new NodeIdPropertyEqualsReturnableEvaluator(geometry.getId())).relationships((RelationshipType)SpatialRelationshipTypes.GEOMETRIES, Direction.OUTGOING).relationships((RelationshipType)SpatialRelationshipTypes.NEXT_GEOM, Direction.OUTGOING).traverse(this.layer.getLayerNode()).nodes());
        if (matchingNode == null) {
            this.layer.add(decodeGeometry, new String[]{"id"}, new Object[]{geometry.getId()});
        } else {
            this.layer.update(matchingNode.getId(), decodeGeometry);
        }
    }

    public void remove(Node entity, String key, Object value) {
        this.remove(entity);
    }

    public void delete() {
    }

    public IndexHits<Node> get(String key, Object value) {
        return this.query(key, value);
    }

    public IndexHits<Node> query(String key, Object params) {
        SpatialRecordHits results = new SpatialRecordHits(new ArrayList<SpatialDatabaseRecord>());
        if (key.equals(WITHIN_QUERY)) {
            Map p = (Map)params;
            Double[] bounds = (Double[])p.get("envelope");
            List<SpatialDatabaseRecord> res = GeoPipeline.startWithinSearch(this.layer, this.layer.getGeometryFactory().toGeometry(new Envelope(bounds[0].doubleValue(), bounds[1].doubleValue(), bounds[2].doubleValue(), bounds[3].doubleValue()))).toSpatialDatabaseRecordList();
            results = new SpatialRecordHits(res);
            return results;
        }
        if (key.equals(WITHIN_WKT_GEOMETRY_QUERY)) {
            WKTReader reader = new WKTReader(this.layer.getGeometryFactory());
            try {
                Geometry geometry = reader.read((String)params);
                List<SpatialDatabaseRecord> res = GeoPipeline.startWithinSearch(this.layer, geometry).toSpatialDatabaseRecordList();
                results = new SpatialRecordHits(res);
                return results;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            if (key.equals(WITHIN_DISTANCE_QUERY)) {
                Double[] point = null;
                Double distance = null;
                if (params.getClass() == String.class) {
                    try {
                        List coordsAndDistance = (List)new JSONParser().parse((String)params);
                        point = new Double[]{(Double)coordsAndDistance.get(0), (Double)coordsAndDistance.get(1)};
                        distance = (Double)coordsAndDistance.get(2);
                    }
                    catch (org.json.simple.parser.ParseException e) {
                        e.printStackTrace();
                    }
                } else {
                    Map p = (Map)params;
                    point = (Double[])p.get(POINT_PARAMETER);
                    distance = (Double)p.get(DISTANCE_IN_KM_PARAMETER);
                }
                List<SpatialDatabaseRecord> res = GeoPipeline.startNearestNeighborLatLonSearch((Layer)this.layer, new Coordinate(point[1].doubleValue(), point[0].doubleValue()), distance).sort("OrthodromicDistance").toSpatialDatabaseRecordList();
                results = new SpatialRecordHits(res);
                return results;
            }
            if (key.equals(BBOX_QUERY)) {
                try {
                    List coords = (List)new JSONParser().parse((String)params);
                    List<SpatialDatabaseRecord> res = GeoPipeline.startWithinSearch(this.layer, this.layer.getGeometryFactory().toGeometry(new Envelope(((Double)coords.get(0)).doubleValue(), ((Double)coords.get(1)).doubleValue(), ((Double)coords.get(2)).doubleValue(), ((Double)coords.get(3)).doubleValue()))).toSpatialDatabaseRecordList();
                    results = new SpatialRecordHits(res);
                    return results;
                }
                catch (org.json.simple.parser.ParseException e) {
                    e.printStackTrace();
                }
            } else {
                throw new UnsupportedOperationException(String.format("only %s, %S and %s are implemented.", WITHIN_QUERY, WITHIN_DISTANCE_QUERY, BBOX_QUERY));
            }
        }
        return null;
    }

    public IndexHits<Node> query(Object queryOrQueryObject) {
        String queryString = (String)queryOrQueryObject;
        return this.query(queryString.substring(0, queryString.indexOf(":")), queryString.substring(queryString.indexOf(":") + 1));
    }

    public void remove(Node node, String s) {
        this.remove(node);
    }

    public void remove(Node node) {
        try {
            this.layer.removeFromIndex(node.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isWriteable() {
        return true;
    }

    public GraphDatabaseService getGraphDatabase() {
        return this.db;
    }

    public Node putIfAbsent(Node entity, String key, Object value) {
        throw new NotImplementedException();
    }

    private class NodeIdPropertyEqualsReturnableEvaluator
    implements Evaluator,
    Predicate<Node> {
        private long nodeId;

        NodeIdPropertyEqualsReturnableEvaluator(long nodeId) {
            this.nodeId = nodeId;
        }

        public boolean accept(Node node) {
            return node.hasProperty("id") && node.getProperty("id").equals(this.nodeId);
        }

        public Evaluation evaluate(Path path) {
            if (this.accept(path.endNode())) {
                return Evaluation.INCLUDE_AND_PRUNE;
            }
            return Evaluation.EXCLUDE_AND_CONTINUE;
        }
    }
}

