/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.indexprovider;

import java.util.Collections;
import java.util.Map;
import org.neo4j.gis.spatial.indexprovider.LayerNodeIndex;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.IndexProvider;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.KernelData;

public class SpatialIndexProvider
extends IndexProvider {
    public static final String SERVICE_NAME = "spatial";
    public static final String GEOMETRY_TYPE = "geometry_type";
    public static final Map<String, String> SIMPLE_POINT_CONFIG = Collections.unmodifiableMap(MapUtil.stringMap((String[])new String[]{"provider", "spatial", "geometry_type", "point", "lat", "lat", "lon", "lon"}));
    public static final Map<String, String> SIMPLE_POINT_CONFIG_WKT = Collections.unmodifiableMap(MapUtil.stringMap((String[])new String[]{"provider", "spatial", "geometry_type", "point", "wkt", "wkt"}));

    public SpatialIndexProvider() {
        super(SERVICE_NAME);
    }

    public IndexImplementation load(KernelData kernelData) throws Exception {
        return new SpatialIndexImplementation(kernelData.graphDatabase());
    }

    private class SpatialIndexImplementation
    extends IndexImplementation {
        private GraphDatabaseService db;

        public SpatialIndexImplementation(GraphDatabaseService db) {
            this.db = db;
        }

        public String getDataSourceName() {
            return null;
        }

        public Index<Node> nodeIndex(String indexName, Map<String, String> config) {
            return new LayerNodeIndex(indexName, this.db, config);
        }

        public RelationshipIndex relationshipIndex(String indexName, Map<String, String> config) {
            throw new UnsupportedOperationException("Spatial relationship indexing is not supported at the moment. Please use the node index.");
        }

        public Map<String, String> fillInDefaults(Map<String, String> config) {
            return config;
        }

        public boolean configMatches(Map<String, String> stringStringMap, Map<String, String> stringStringMap1) {
            return false;
        }
    }
}

