/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.osm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.collections.MapUtils;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.neo4j.collections.rtree.Envelope;
import org.neo4j.collections.rtree.Listener;
import org.neo4j.collections.rtree.NullListener;
import org.neo4j.gis.spatial.Constants;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.gis.spatial.osm.OSMDataset;
import org.neo4j.gis.spatial.osm.OSMGeometryEncoder;
import org.neo4j.gis.spatial.osm.OSMLayer;
import org.neo4j.gis.spatial.osm.OSMRelation;
import org.neo4j.gis.spatial.osm.RoadDirection;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.Traverser;
import org.neo4j.graphdb.index.BatchInserterIndex;
import org.neo4j.graphdb.index.BatchInserterIndexProvider;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.LuceneBatchInserterIndexProvider;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.batchinsert.BatchInserter;
import org.neo4j.kernel.impl.batchinsert.BatchInserterImpl;
import org.neo4j.kernel.impl.batchinsert.SimpleRelationship;

public class OSMImporter
implements Constants {
    public static DefaultEllipsoid WGS84 = DefaultEllipsoid.WGS84;
    public static String INDEX_NAME_CHANGESET = "changeset";
    public static String INDEX_NAME_USER = "user";
    public static String INDEX_NAME_NODE = "node";
    public static String INDEX_NAME_WAY = "node";
    protected boolean nodesProcessingFinished = false;
    private String layerName;
    private StatsManager stats = new StatsManager();
    private long osm_dataset = -1L;
    private Listener monitor;
    private Charset charset = Charset.defaultCharset();
    private int progress = 0;
    private long progressTime = 0L;
    private String logContext = null;
    private int contextLine = 0;
    private DateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public OSMImporter(String layerName) {
        this(layerName, null);
    }

    public OSMImporter(String layerName, Listener monitor) {
        this.layerName = layerName;
        if (monitor == null) {
            monitor = new NullListener();
        }
        this.monitor = monitor;
    }

    public void reIndex(GraphDatabaseService database) {
        this.reIndex(database, 10000, true, false);
    }

    public void reIndex(GraphDatabaseService database, int commitInterval) {
        this.reIndex(database, commitInterval, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reIndex(GraphDatabaseService database, int commitInterval, boolean includePoints, boolean includeRelations) {
        if (commitInterval < 1) {
            throw new IllegalArgumentException("commitInterval must be >= 1");
        }
        System.out.println("Re-indexing with GraphDatabaseService: " + database + " (class: " + database.getClass() + ")");
        this.setLogContext("Index");
        SpatialDatabaseService spatialDatabase = new SpatialDatabaseService(database);
        OSMLayer layer = (OSMLayer)spatialDatabase.getOrCreateLayer(this.layerName, OSMGeometryEncoder.class, OSMLayer.class);
        OSMDataset dataset = layer.getDataset(this.osm_dataset);
        layer.clear();
        long startTime = System.currentTimeMillis();
        Traverser traverser = database.getNodeById(this.osm_dataset).traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL_BUT_START_NODE, (RelationshipType)OSMRelation.WAYS, Direction.OUTGOING, (RelationshipType)OSMRelation.NEXT, Direction.OUTGOING);
        Transaction tx = database.beginTx();
        boolean useWays = false;
        int count = 0;
        try {
            layer.setExtraPropertyNames(this.stats.getTagStats("all").getTags());
            if (useWays) {
                this.beginProgressMonitor(dataset.getWayCount());
                for (Node way : traverser) {
                    this.updateProgressMonitor(count);
                    this.incrLogContext();
                    this.stats.addGeomStats(layer.addWay(way, true));
                    if (includePoints) {
                        Node first = way.getSingleRelationship((RelationshipType)OSMRelation.FIRST_NODE, Direction.OUTGOING).getEndNode();
                        for (Node proxy : first.traverse(Traverser.Order.DEPTH_FIRST, StopEvaluator.END_OF_GRAPH, ReturnableEvaluator.ALL, (RelationshipType)OSMRelation.NEXT, Direction.OUTGOING)) {
                            Node node = proxy.getSingleRelationship((RelationshipType)OSMRelation.NODE, Direction.OUTGOING).getEndNode();
                            this.stats.addGeomStats(layer.addWay(node, true));
                        }
                    }
                    if (++count % commitInterval != 0) continue;
                    tx.success();
                    tx.finish();
                    tx = database.beginTx();
                }
            } else {
                this.beginProgressMonitor(dataset.getChangesetCount());
                for (Node changeset : dataset.getAllChangesetNodes()) {
                    this.updateProgressMonitor(count);
                    this.incrLogContext();
                    for (Relationship rel : changeset.getRelationships((RelationshipType)OSMRelation.CHANGESET, Direction.INCOMING)) {
                        this.stats.addGeomStats(layer.addWay(rel.getStartNode(), true));
                    }
                    if (++count % commitInterval != 0) continue;
                    tx.success();
                    tx.finish();
                    tx = database.beginTx();
                }
            }
            tx.success();
        }
        finally {
            this.endProgressMonitor();
            tx.finish();
        }
        long stopTime = System.currentTimeMillis();
        this.log("info | Re-indexing elapsed time in seconds: " + 1.0 * (double)(stopTime - startTime) / 1000.0);
        this.stats.dumpGeomStats();
    }

    public void importFile(GraphDatabaseService database, String dataset) throws IOException, XMLStreamException {
        this.importFile(database, dataset, false, 5000);
    }

    public void importFile(GraphDatabaseService database, String dataset, int txInterval) throws IOException, XMLStreamException {
        this.importFile(database, dataset, false, txInterval);
    }

    public void importFile(GraphDatabaseService database, String dataset, boolean allPoints, int txInterval) throws IOException, XMLStreamException {
        this.importFile(OSMWriter.fromGraphDatabase(database, this.stats, this, txInterval), dataset, allPoints, this.charset);
    }

    public void importFile(BatchInserter batchInserter, String dataset) throws IOException, XMLStreamException {
        this.importFile(batchInserter, dataset, false);
    }

    public void importFile(BatchInserter batchInserter, String dataset, boolean allPoints) throws IOException, XMLStreamException {
        this.importFile(OSMWriter.fromBatchInserter(batchInserter, this.stats, this), dataset, allPoints, this.charset);
    }

    private void beginProgressMonitor(int length) {
        this.monitor.begin(length);
        this.progress = 0;
        this.progressTime = System.currentTimeMillis();
    }

    private void updateProgressMonitor(int currentProgress) {
        long time;
        if (currentProgress > this.progress && (time = System.currentTimeMillis()) - this.progressTime > 1000L) {
            this.monitor.worked(currentProgress - this.progress);
            this.progress = currentProgress;
            this.progressTime = time;
        }
    }

    private void endProgressMonitor() {
        this.monitor.done();
        this.progress = 0;
        this.progressTime = 0L;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFile(OSMWriter<?> osmWriter, String dataset, boolean allPoints, Charset charset) throws IOException, XMLStreamException {
        System.out.println("Importing with osm-writer: " + osmWriter);
        osmWriter.getOrCreateOSMDataset(this.layerName);
        this.osm_dataset = osmWriter.getDatasetId();
        long startTime = System.currentTimeMillis();
        long[] times = new long[]{0L, 0L, 0L, 0L};
        XMLInputFactory factory = XMLInputFactory.newInstance();
        CountedFileReader reader = new CountedFileReader(dataset, charset);
        XMLStreamReader parser = factory.createXMLStreamReader(reader);
        int countXMLTags = 0;
        this.beginProgressMonitor(100);
        this.setLogContext(dataset);
        boolean startedWays = false;
        boolean startedRelations = false;
        try {
            ArrayList<String> currentXMLTags = new ArrayList<String>();
            int depth = 0;
            Map<String, Object> wayProperties = null;
            ArrayList<Long> wayNodes = new ArrayList<Long>();
            Map<String, Object> relationProperties = null;
            ArrayList<Map<String, Object>> relationMembers = new ArrayList<Map<String, Object>>();
            LinkedHashMap<String, Object> currentNodeTags = new LinkedHashMap<String, Object>();
            while (true) {
                this.updateProgressMonitor(reader.getPercentRead());
                this.incrLogContext();
                int event = parser.next();
                if (event == 8) {
                    break;
                }
                switch (event) {
                    case 1: {
                        currentXMLTags.add(depth, parser.getLocalName());
                        String tagPath = currentXMLTags.toString();
                        if (tagPath.equals("[osm]")) {
                            osmWriter.setDatasetProperties(this.extractProperties(parser));
                        } else if (tagPath.equals("[osm, bounds]")) {
                            osmWriter.addOSMBBox(this.extractProperties("bbox", parser));
                        } else if (tagPath.equals("[osm, node]")) {
                            osmWriter.createOSMNode(this.extractProperties("node", parser));
                        } else if (tagPath.equals("[osm, way]")) {
                            if (!startedWays) {
                                startedWays = true;
                                times[0] = System.currentTimeMillis();
                                osmWriter.optimize();
                                times[1] = System.currentTimeMillis();
                            }
                            wayProperties = this.extractProperties("way", parser);
                            wayNodes.clear();
                        } else if (tagPath.equals("[osm, way, nd]")) {
                            Map<String, Object> properties = this.extractProperties(parser);
                            wayNodes.add(Long.parseLong(properties.get("ref").toString()));
                        } else if (tagPath.endsWith("tag]")) {
                            Map<String, Object> properties = this.extractProperties(parser);
                            currentNodeTags.put(properties.get("k").toString(), properties.get("v").toString());
                        } else if (tagPath.equals("[osm, relation]")) {
                            if (!startedRelations) {
                                startedRelations = true;
                                times[2] = System.currentTimeMillis();
                                osmWriter.optimize();
                                times[3] = System.currentTimeMillis();
                            }
                            relationProperties = this.extractProperties("relation", parser);
                            relationMembers.clear();
                        } else if (tagPath.equals("[osm, relation, member]")) {
                            relationMembers.add(this.extractProperties(parser));
                        }
                        if (startedRelations) {
                            if (countXMLTags < 10) {
                                this.log("Starting tag at depth " + depth + ": " + (String)currentXMLTags.get(depth) + " - " + currentXMLTags.toString());
                                for (int i = 0; i < parser.getAttributeCount(); ++i) {
                                    this.log("\t" + currentXMLTags.toString() + ": " + parser.getAttributeLocalName(i) + "[" + parser.getAttributeNamespace(i) + "," + parser.getAttributePrefix(i) + "," + parser.getAttributeType(i) + "," + "] = " + parser.getAttributeValue(i));
                                }
                            }
                            ++countXMLTags;
                        }
                        ++depth;
                        break;
                    }
                    case 2: {
                        if (currentXMLTags.toString().equals("[osm, node]")) {
                            ((OSMWriter)osmWriter).addOSMNodeTags(allPoints, currentNodeTags);
                        } else if (currentXMLTags.toString().equals("[osm, way]")) {
                            osmWriter.createOSMWay(wayProperties, wayNodes, currentNodeTags);
                        } else if (currentXMLTags.toString().equals("[osm, relation]")) {
                            ((OSMWriter)osmWriter).createOSMRelation(relationProperties, relationMembers, currentNodeTags);
                        }
                        currentXMLTags.remove(--depth);
                        break;
                    }
                }
            }
        }
        finally {
            this.endProgressMonitor();
            parser.close();
            osmWriter.finish();
            this.osm_dataset = osmWriter.getDatasetId();
        }
        this.describeTimes(startTime, times);
        ((OSMWriter)osmWriter).describeMissing();
        osmWriter.describeLoaded();
        long stopTime = System.currentTimeMillis();
        this.log("info | Elapsed time in seconds: " + 1.0 * (double)(stopTime - startTime) / 1000.0);
        this.stats.dumpGeomStats();
        this.stats.printTagStats();
    }

    private void describeTimes(long startTime, long[] times) {
        long endTime = System.currentTimeMillis();
        this.log("Completed load in " + 1.0 * (double)(endTime - startTime) / 1000.0 + "s");
        this.log("\tImported nodes:  " + 1.0 * (double)(times[0] - startTime) / 1000.0 + "s");
        this.log("\tOptimized index: " + 1.0 * (double)(times[1] - times[0]) / 1000.0 + "s");
        this.log("\tImported ways:   " + 1.0 * (double)(times[2] - times[1]) / 1000.0 + "s");
        this.log("\tOptimized index: " + 1.0 * (double)(times[3] - times[2]) / 1000.0 + "s");
        this.log("\tImported rels:   " + 1.0 * (double)(endTime - times[3]) / 1000.0 + "s");
    }

    private Map<String, Object> extractProperties(XMLStreamReader parser) {
        return this.extractProperties(null, parser);
    }

    private Map<String, Object> extractProperties(String name, XMLStreamReader parser) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String prop = parser.getAttributeLocalName(i);
            String value = parser.getAttributeValue(i);
            if (name != null && prop.equals("id")) {
                prop = name + "_osm_id";
                name = null;
            }
            if (prop.equals("lat") || prop.equals("lon")) {
                properties.put(prop, Double.parseDouble(value));
                continue;
            }
            if (name != null && prop.equals("version")) {
                properties.put(prop, Integer.parseInt(value));
                continue;
            }
            if (prop.equals("visible")) {
                if (value.equals("true") || value.equals("1")) continue;
                properties.put(prop, false);
                continue;
            }
            if (prop.equals("timestamp")) {
                try {
                    Date timestamp = this.timestampFormat.parse(value);
                    properties.put(prop, timestamp.getTime());
                }
                catch (ParseException e) {
                    this.error("Error parsing timestamp", e);
                }
                continue;
            }
            properties.put(prop, value);
        }
        if (name != null) {
            properties.put("name", name);
        }
        return properties;
    }

    public static RoadDirection isOneway(Map<String, Object> wayProperties) {
        String oneway = (String)wayProperties.get("oneway");
        if (null != oneway) {
            if ("-1".equals(oneway)) {
                return RoadDirection.BACKWARD;
            }
            if ("1".equals(oneway) || "yes".equalsIgnoreCase(oneway) || "true".equalsIgnoreCase(oneway)) {
                return RoadDirection.FORWARD;
            }
        }
        return RoadDirection.BOTH;
    }

    public static double distance(double lonA, double latA, double lonB, double latB) {
        return WGS84.orthodromicDistance(lonA, latA, lonB, latB);
    }

    private void log(PrintStream out, String message, Exception e) {
        if (this.logContext != null) {
            message = this.logContext + "[" + this.contextLine + "]: " + message;
        }
        out.println(message);
        if (e != null) {
            e.printStackTrace(out);
        }
    }

    private void log(String message) {
        this.log(System.out, message, null);
    }

    private void error(String message) {
        this.log(System.err, message, null);
    }

    private void error(String message, Exception e) {
        this.log(System.err, message, e);
    }

    private void setLogContext(String context) {
        this.logContext = context;
        this.contextLine = 0;
    }

    private void incrLogContext() {
        ++this.contextLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: osmimporter databasedir osmfile <..osmfiles..>");
        } else {
            OSMImportManager importer = new OSMImportManager(args[0]);
            for (int i = 1; i < args.length; ++i) {
                try {
                    importer.loadTestOsmData(args[i], 5000);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error importing OSM file '" + args[i] + "': " + e);
                    e.printStackTrace();
                    continue;
                }
                finally {
                    importer.shutdown();
                }
            }
        }
    }

    private static class OSMImportManager {
        private GraphDatabaseService graphDb;
        private BatchInserter batchInserter;
        private File dbPath;
        private boolean useBatchInserter = false;

        public OSMImportManager(String path) {
            this.setDbPath(path);
        }

        public void setDbPath(String path) {
            this.dbPath = new File(path);
            if (this.dbPath.exists()) {
                if (!this.dbPath.isDirectory()) {
                    throw new RuntimeException("Database path is an existing file: " + this.dbPath.getAbsolutePath());
                }
            } else {
                this.dbPath.mkdirs();
            }
        }

        private void loadTestOsmData(String layerName, int commitInterval) throws Exception {
            String osmPath = layerName;
            System.out.println("\n=== Loading layer " + layerName + " from " + osmPath + " ===");
            long start = System.currentTimeMillis();
            if (this.useBatchInserter) {
                this.switchToBatchInserter();
                OSMImporter importer = new OSMImporter(layerName);
                importer.importFile(this.batchInserter, osmPath);
                this.switchToEmbeddedGraphDatabase();
                importer.reIndex(this.graphDb, commitInterval);
            } else {
                this.switchToEmbeddedGraphDatabase();
                OSMImporter importer = new OSMImporter(layerName);
                importer.importFile(this.graphDb, osmPath, false, commitInterval);
                importer.reIndex(this.graphDb, commitInterval);
            }
            this.shutdown();
            System.out.println("=== Completed loading " + layerName + " in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " seconds ===");
        }

        private void switchToEmbeddedGraphDatabase() {
            this.shutdown();
            this.graphDb = new EmbeddedGraphDatabase(this.dbPath.getAbsolutePath());
        }

        private void switchToBatchInserter() {
            this.shutdown();
            this.batchInserter = new BatchInserterImpl(this.dbPath.getAbsolutePath());
            this.graphDb = this.batchInserter.getGraphDbService();
        }

        protected void shutdown() {
            if (this.graphDb != null) {
                this.graphDb.shutdown();
                this.graphDb = null;
                this.batchInserter = null;
            }
        }
    }

    public static class CountedFileReader
    extends InputStreamReader {
        private long length = 0L;
        private long charsRead = 0L;

        public CountedFileReader(String path, Charset charset) throws FileNotFoundException {
            super((InputStream)new FileInputStream(path), charset);
            this.length = new File(path).length();
        }

        public CountedFileReader(File file, Charset charset) throws FileNotFoundException {
            super((InputStream)new FileInputStream(file), charset);
            this.length = file.length();
        }

        public long getCharsRead() {
            return this.charsRead;
        }

        public long getlength() {
            return this.length;
        }

        public double getProgress() {
            return this.length > 0L ? (double)this.charsRead / (double)this.length : 0.0;
        }

        public int getPercentRead() {
            return (int)(100.0 * this.getProgress());
        }

        @Override
        public int read(char[] cbuf, int offset, int length) throws IOException {
            int read = super.read(cbuf, offset, length);
            if (read > 0) {
                this.charsRead += (long)read;
            }
            return read;
        }
    }

    private static class OSMBatchWriter
    extends OSMWriter<Long> {
        private BatchInserter batchInserter;
        private BatchInserterIndexProvider batchIndexService;
        private HashMap<String, BatchInserterIndex> batchIndices = new HashMap();
        private long osm_root;
        private long currentChangesetId = -1L;
        private long currentChangesetNode = -1L;
        private long currentUserId = -1L;
        private long currentUserNode = -1L;
        private long usersNode = -1L;
        private HashMap<Long, Long> changesetNodes = new HashMap();

        private OSMBatchWriter(BatchInserter batchGraphDb, StatsManager statsManager, OSMImporter osmImporter) {
            super(statsManager, osmImporter);
            this.batchInserter = batchGraphDb;
            this.batchIndexService = new LuceneBatchInserterIndexProvider(batchGraphDb);
        }

        private BatchInserterIndex indexFor(String indexName) {
            BatchInserterIndex index = this.batchIndices.get(indexName);
            if (index == null) {
                index = this.batchIndexService.nodeIndex(indexName, MapUtil.stringMap((String[])new String[]{"type", "exact"}));
                this.batchIndices.put(indexName, index);
            }
            return index;
        }

        @Override
        public Long getOrCreateOSMDataset(String name) {
            if (this.osm_dataset == null || (Long)this.osm_dataset <= 0L) {
                this.osm_root = this.getOrCreateNode("osm_root", "osm", this.batchInserter.getReferenceNode(), (RelationshipType)OSMRelation.OSM);
                this.osm_dataset = this.getOrCreateNode(name, "osm", this.osm_root, (RelationshipType)OSMRelation.OSM);
            }
            return (Long)this.osm_dataset;
        }

        private long findNode(BatchInserter batchInserter, String name, long parent, RelationshipType relType) {
            for (SimpleRelationship relationship : batchInserter.getRelationships(parent)) {
                long node;
                Object nodeName;
                if (!relationship.getType().name().equals(relType.name()) || (nodeName = batchInserter.getNodeProperties(node = relationship.getEndNode()).get("name")) == null || !name.equals(nodeName.toString())) continue;
                return node;
            }
            return -1L;
        }

        @Override
        protected Long getOrCreateNode(String name, String type, Long parent, RelationshipType relType) {
            long node = this.findNode(this.batchInserter, name, parent, relType);
            if (node < 0L) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("name", name);
                properties.put("type", type);
                node = this.batchInserter.createNode(properties);
                this.batchInserter.createRelationship(parent.longValue(), node, relType, null);
            }
            return node;
        }

        public String toString() {
            return "OSMBatchWriter: BatchInserter[" + this.batchInserter.toString() + "]:IndexService[" + this.batchIndexService.toString() + "]";
        }

        @Override
        protected void setDatasetProperties(Map<String, Object> extraProperties) {
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.putAll(this.batchInserter.getNodeProperties(((Long)this.osm_dataset).longValue()));
            properties.putAll(extraProperties);
            this.batchInserter.setNodeProperties(((Long)this.osm_dataset).longValue(), properties);
        }

        @Override
        protected void addNodeTags(Long node, LinkedHashMap<String, Object> tags, String type) {
            this.logNodeAddition(tags, type);
            if (node > 0L && tags.size() > 0) {
                this.statsManager.addToTagStats(type, tags.keySet());
                long id = this.batchInserter.createNode(tags);
                this.batchInserter.createRelationship(node.longValue(), id, (RelationshipType)OSMRelation.TAGS, null);
                tags.clear();
            }
        }

        @Override
        protected void addNodeGeometry(Long node, int gtype, Envelope bbox, int vertices) {
            if (node > 0L && bbox.isValid() && vertices > 0) {
                LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
                if (gtype == 0) {
                    gtype = vertices > 1 ? 4 : 1;
                }
                properties.put("gtype", gtype);
                properties.put("vertices", vertices);
                properties.put("bbox", new double[]{bbox.getMinX(), bbox.getMaxX(), bbox.getMinY(), bbox.getMaxY()});
                long id = this.batchInserter.createNode(properties);
                this.batchInserter.createRelationship(node.longValue(), id, (RelationshipType)OSMRelation.GEOM, null);
                properties.clear();
                this.statsManager.addGeomStats(gtype);
            }
        }

        @Override
        protected Long addNode(String name, Map<String, Object> properties, String indexKey) {
            long id = -1L;
            if (indexKey != null && properties.containsKey(indexKey)) {
                HashMap<String, String> props = new HashMap<String, String>();
                props.put(indexKey, properties.get(indexKey).toString());
                properties.put(indexKey, Long.parseLong(properties.get(indexKey).toString()));
                id = this.batchInserter.createNode(properties);
                this.indexFor(name).add(id, props);
            } else {
                id = this.batchInserter.createNode(properties);
            }
            return id;
        }

        protected Long addNodeWithCheck(String name, Map<String, Object> properties, String indexKey) {
            Object indexValue;
            long id = -1L;
            Object object = indexValue = indexKey == null ? null : properties.get(indexKey);
            if (indexValue != null && (createdNodes + foundNodes < 100 || foundNodes > 10)) {
                id = (Long)this.indexFor(name).get(indexKey, properties.get(indexKey)).getSingle();
            }
            if (id < 0L) {
                id = this.batchInserter.createNode(properties);
                if (indexValue != null) {
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put(indexKey, properties.get(indexKey));
                    this.indexFor(name).add(id, props);
                }
                ++createdNodes;
            } else {
                ++foundNodes;
            }
            return id;
        }

        @Override
        protected void createRelationship(Long from, Long to, RelationshipType relType, LinkedHashMap<String, Object> relProps) {
            this.batchInserter.createRelationship(from.longValue(), to.longValue(), relType, relProps);
        }

        @Override
        protected void optimize() {
            for (String index : new String[]{"node", "way", "changeset", "user"}) {
                this.indexFor(index).flush();
            }
        }

        @Override
        protected long getDatasetId() {
            return (Long)this.osm_dataset;
        }

        @Override
        protected Long getSingleNode(String name, String string, Object value) {
            return (Long)this.indexFor(name).get(string, value).getSingle();
        }

        @Override
        protected Map<String, Object> getNodeProperties(Long member) {
            return this.batchInserter.getNodeProperties(member.longValue());
        }

        @Override
        protected Long getOSMNode(long osmId, Long changesetNode) {
            Long node;
            if (this.currentChangesetNode != changesetNode || this.changesetNodes.isEmpty()) {
                this.currentChangesetNode = changesetNode;
                this.changesetNodes.clear();
                for (SimpleRelationship rel : this.batchInserter.getRelationships(changesetNode.longValue())) {
                    Long node2;
                    Map props;
                    Long nodeOsmId;
                    if (!rel.getType().name().equals(OSMRelation.CHANGESET.name()) || (nodeOsmId = (Long)(props = this.batchInserter.getNodeProperties((node2 = Long.valueOf(rel.getStartNode())).longValue())).get("node_osm_id")) == null) continue;
                    this.changesetNodes.put(nodeOsmId, node2);
                }
            }
            if ((node = this.changesetNodes.get(osmId)) == null) {
                this.logNodeFoundFrom("node-index");
                return (Long)this.indexFor(INDEX_NAME_NODE).get("node_osm_id", (Object)osmId).getSingle();
            }
            this.logNodeFoundFrom("changeset");
            return node;
        }

        @Override
        protected void updateGeometryMetaDataFromMember(Long member, GeometryMetaData metaGeom, Map<String, Object> nodeProps) {
            for (SimpleRelationship rel : this.batchInserter.getRelationships(member.longValue())) {
                if (!rel.getType().equals((Object)OSMRelation.GEOM)) continue;
                nodeProps = this.getNodeProperties(rel.getEndNode());
                metaGeom.checkSupportedGeometry((Integer)nodeProps.get("gtype"));
                metaGeom.expandToIncludeBBox(nodeProps);
            }
        }

        @Override
        protected void finish() {
            HashMap<String, Object> dsProps = new HashMap<String, Object>(this.batchInserter.getNodeProperties(((Long)this.osm_dataset).longValue()));
            this.updateDSCounts(dsProps, "relationCount", this.relationCount);
            this.updateDSCounts(dsProps, "wayCount", this.wayCount);
            this.updateDSCounts(dsProps, "nodeCount", this.nodeCount);
            this.updateDSCounts(dsProps, "poiCount", this.poiCount);
            this.updateDSCounts(dsProps, "changesetCount", this.changesetCount);
            this.updateDSCounts(dsProps, "userCount", this.userCount);
            this.setDatasetProperties(dsProps);
            this.batchIndexService.shutdown();
            this.batchIndexService = null;
        }

        private void updateDSCounts(HashMap<String, Object> dsProps, String name, int count) {
            Integer current = (Integer)dsProps.get(name);
            dsProps.put(name, (current == null ? 0 : current) + count);
        }

        @Override
        protected Long createProxyNode() {
            return this.batchInserter.createNode(null);
        }

        @Override
        protected Long getChangesetNode(Map<String, Object> nodeProps) {
            long changeset = Long.parseLong(nodeProps.remove("changeset").toString());
            this.getUserNode((Map)nodeProps);
            if (changeset != this.currentChangesetId) {
                this.currentChangesetId = changeset;
                this.changesetNodes.clear();
                IndexHits results = this.indexFor("changeset").get("changeset", (Object)this.currentChangesetId);
                if (results.size() > 0) {
                    this.currentChangesetNode = (Long)results.getSingle();
                } else {
                    LinkedHashMap<String, Object> changesetProps = new LinkedHashMap<String, Object>();
                    changesetProps.put("changeset", this.currentChangesetId);
                    changesetProps.put("timestamp", nodeProps.get("timestamp"));
                    this.currentChangesetNode = (Long)this.addNode("changeset", changesetProps, "changeset");
                    this.indexFor("changeset").flush();
                    if (this.currentUserNode > 0L) {
                        this.createRelationship(this.currentChangesetNode, this.currentUserNode, OSMRelation.USER);
                    }
                }
                results.close();
            }
            return this.currentChangesetNode;
        }

        @Override
        protected Long getUserNode(Map<String, Object> nodeProps) {
            try {
                long uid = Long.parseLong(nodeProps.remove("uid").toString());
                String name = nodeProps.remove("user").toString();
                if (uid != this.currentUserId) {
                    this.currentUserId = uid;
                    IndexHits results = this.indexFor(INDEX_NAME_USER).get("uid", (Object)this.currentUserId);
                    if (results.size() > 0) {
                        this.currentUserNode = (Long)results.getSingle();
                    } else {
                        LinkedHashMap<String, Object> userProps = new LinkedHashMap<String, Object>();
                        userProps.put("uid", this.currentUserId);
                        userProps.put("name", name);
                        userProps.put("timestamp", nodeProps.get("timestamp"));
                        this.currentUserNode = (Long)this.addNode("user", userProps, "uid");
                        this.indexFor(INDEX_NAME_USER).flush();
                        if (this.usersNode < 0L) {
                            this.usersNode = this.batchInserter.createNode(MapUtils.EMPTY_MAP);
                            this.createRelationship(this.osm_dataset, this.usersNode, OSMRelation.USERS);
                        }
                        this.createRelationship(this.usersNode, this.currentUserNode, OSMRelation.OSM_USER);
                    }
                    results.close();
                }
            }
            catch (Exception e) {
                this.currentUserId = -1L;
                this.currentUserNode = -1L;
                this.logMissingUser(nodeProps);
            }
            return this.currentUserNode;
        }
    }

    private static class OSMGraphWriter
    extends OSMWriter<Node> {
        private GraphDatabaseService graphDb;
        private Node osm_root;
        private long currentChangesetId = -1L;
        private Node currentChangesetNode;
        private long currentUserId = -1L;
        private Node currentUserNode;
        private Node usersNode;
        private HashMap<Long, Node> changesetNodes = new HashMap();
        private Transaction tx;
        private int checkCount = 0;
        private int txInterval;

        private OSMGraphWriter(GraphDatabaseService graphDb, StatsManager statsManager, OSMImporter osmImporter, int txInterval) {
            super(statsManager, osmImporter);
            this.graphDb = graphDb;
            this.txInterval = txInterval;
            if (this.txInterval < 100) {
                System.err.println("Warning: Unusually short txInterval, expect bad insert performance");
            }
            this.checkTx();
        }

        private void successTx() {
            if (this.tx != null) {
                this.tx.success();
                this.tx.finish();
                this.tx = null;
                this.checkCount = 0;
            }
        }

        private void checkTx() {
            if (this.checkCount++ > this.txInterval || this.tx == null) {
                this.successTx();
                this.tx = this.graphDb.beginTx();
            }
        }

        private Index<Node> indexFor(String indexName) {
            return this.graphDb.index().forNodes(indexName);
        }

        private Node findNode(String name, Node parent, RelationshipType relType) {
            for (Relationship relationship : parent.getRelationships(relType, Direction.OUTGOING)) {
                Node node = relationship.getEndNode();
                if (!name.equals(node.getProperty("name"))) continue;
                return node;
            }
            return null;
        }

        @Override
        protected Node getOrCreateNode(String name, String type, Node parent, RelationshipType relType) {
            Node node = this.findNode(name, parent, relType);
            if (node == null) {
                node = this.graphDb.createNode();
                node.setProperty("name", (Object)name);
                node.setProperty("type", (Object)type);
                parent.createRelationshipTo(node, relType);
                this.checkTx();
            }
            return node;
        }

        @Override
        protected Node getOrCreateOSMDataset(String name) {
            if (this.osm_dataset == null) {
                this.osm_root = this.getOrCreateNode("osm_root", "osm", this.graphDb.getReferenceNode(), (RelationshipType)OSMRelation.OSM);
                this.osm_dataset = this.getOrCreateNode(name, "osm", this.osm_root, (RelationshipType)OSMRelation.OSM);
            }
            return (Node)this.osm_dataset;
        }

        @Override
        protected void setDatasetProperties(Map<String, Object> extractProperties) {
            for (String key : extractProperties.keySet()) {
                ((Node)this.osm_dataset).setProperty(key, extractProperties.get(key));
            }
        }

        private void addProperties(PropertyContainer node, Map<String, Object> properties) {
            for (String property : properties.keySet()) {
                node.setProperty(property, properties.get(property));
            }
        }

        @Override
        protected void addNodeTags(Node node, LinkedHashMap<String, Object> tags, String type) {
            this.logNodeAddition(tags, type);
            if (node != null && tags.size() > 0) {
                this.statsManager.addToTagStats(type, tags.keySet());
                Node tagsNode = this.graphDb.createNode();
                this.addProperties((PropertyContainer)tagsNode, tags);
                node.createRelationshipTo(tagsNode, (RelationshipType)OSMRelation.TAGS);
                tags.clear();
            }
        }

        @Override
        protected void addNodeGeometry(Node node, int gtype, Envelope bbox, int vertices) {
            if (node != null && bbox.isValid() && vertices > 0) {
                if (gtype == 0) {
                    gtype = vertices > 1 ? 4 : 1;
                }
                Node geomNode = this.graphDb.createNode();
                geomNode.setProperty("gtype", (Object)gtype);
                geomNode.setProperty("vertices", (Object)vertices);
                geomNode.setProperty("bbox", (Object)new double[]{bbox.getMinX(), bbox.getMaxX(), bbox.getMinY(), bbox.getMaxY()});
                node.createRelationshipTo(geomNode, (RelationshipType)OSMRelation.GEOM);
                this.statsManager.addGeomStats(gtype);
            }
        }

        @Override
        protected Node addNode(String name, Map<String, Object> properties, String indexKey) {
            Node node = this.graphDb.createNode();
            if (indexKey != null && properties.containsKey(indexKey)) {
                this.indexFor(name).add((PropertyContainer)node, indexKey, properties.get(indexKey));
                properties.put(indexKey, Long.parseLong(properties.get(indexKey).toString()));
            }
            this.addProperties((PropertyContainer)node, properties);
            this.checkTx();
            return node;
        }

        protected Node addNodeWithCheck(String name, Map<String, Object> properties, String indexKey) {
            Object indexValue;
            Node node = null;
            Object object = indexValue = indexKey == null ? null : properties.get(indexKey);
            if (indexValue != null && (createdNodes + foundNodes < 100 || foundNodes > 10)) {
                node = (Node)this.indexFor(name).get(indexKey, properties.get(indexKey)).getSingle();
            }
            if (node == null) {
                node = this.graphDb.createNode();
                this.addProperties((PropertyContainer)node, properties);
                if (indexValue != null) {
                    this.indexFor(name).add((PropertyContainer)node, indexKey, properties.get(indexKey));
                }
                ++createdNodes;
                this.checkTx();
            } else {
                ++foundNodes;
            }
            return node;
        }

        @Override
        protected void createRelationship(Node from, Node to, RelationshipType relType, LinkedHashMap<String, Object> relProps) {
            Relationship rel = from.createRelationshipTo(to, relType);
            if (relProps != null && relProps.size() > 0) {
                this.addProperties((PropertyContainer)rel, relProps);
            }
        }

        @Override
        protected long getDatasetId() {
            return ((Node)this.osm_dataset).getId();
        }

        @Override
        protected Node getSingleNode(String name, String string, Object value) {
            return (Node)this.indexFor(name).get(string, value).getSingle();
        }

        @Override
        protected Map<String, Object> getNodeProperties(Node node) {
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            for (String property : node.getPropertyKeys()) {
                properties.put(property, node.getProperty(property));
            }
            return properties;
        }

        @Override
        protected Node getOSMNode(long osmId, Node changesetNode) {
            Node node;
            if (this.currentChangesetNode != changesetNode || this.changesetNodes.isEmpty()) {
                this.currentChangesetNode = changesetNode;
                this.changesetNodes.clear();
                for (Relationship rel : changesetNode.getRelationships((RelationshipType)OSMRelation.CHANGESET, Direction.INCOMING)) {
                    Node node2 = rel.getStartNode();
                    Long nodeOsmId = (Long)node2.getProperty("node_osm_id", null);
                    if (nodeOsmId == null) continue;
                    this.changesetNodes.put(nodeOsmId, node2);
                }
            }
            if ((node = this.changesetNodes.get(osmId)) == null) {
                this.logNodeFoundFrom("node-index");
                return (Node)this.indexFor("node").get("node_osm_id", (Object)osmId).getSingle();
            }
            this.logNodeFoundFrom("changeset");
            return node;
        }

        @Override
        protected void updateGeometryMetaDataFromMember(Node member, GeometryMetaData metaGeom, Map<String, Object> nodeProps) {
            for (Relationship rel : member.getRelationships(new RelationshipType[]{OSMRelation.GEOM})) {
                nodeProps = this.getNodeProperties(rel.getEndNode());
                metaGeom.checkSupportedGeometry((Integer)nodeProps.get("gtype"));
                metaGeom.expandToIncludeBBox(nodeProps);
            }
        }

        @Override
        protected void finish() {
            ((Node)this.osm_dataset).setProperty("relationCount", (Object)((Integer)((Node)this.osm_dataset).getProperty("relationCount", (Object)0) + this.relationCount));
            ((Node)this.osm_dataset).setProperty("wayCount", (Object)((Integer)((Node)this.osm_dataset).getProperty("wayCount", (Object)0) + this.wayCount));
            ((Node)this.osm_dataset).setProperty("nodeCount", (Object)((Integer)((Node)this.osm_dataset).getProperty("nodeCount", (Object)0) + this.nodeCount));
            ((Node)this.osm_dataset).setProperty("poiCount", (Object)((Integer)((Node)this.osm_dataset).getProperty("poiCount", (Object)0) + this.poiCount));
            ((Node)this.osm_dataset).setProperty("changesetCount", (Object)((Integer)((Node)this.osm_dataset).getProperty("changesetCount", (Object)0) + this.changesetCount));
            ((Node)this.osm_dataset).setProperty("userCount", (Object)((Integer)((Node)this.osm_dataset).getProperty("userCount", (Object)0) + this.userCount));
            this.successTx();
        }

        @Override
        protected Node createProxyNode() {
            return this.graphDb.createNode();
        }

        @Override
        protected Node getChangesetNode(Map<String, Object> nodeProps) {
            long changeset = Long.parseLong(nodeProps.remove(INDEX_NAME_CHANGESET).toString());
            this.getUserNode(nodeProps);
            if (changeset != this.currentChangesetId) {
                this.currentChangesetId = changeset;
                IndexHits result = this.indexFor(INDEX_NAME_CHANGESET).get(INDEX_NAME_CHANGESET, (Object)this.currentChangesetId);
                if (result.size() > 0) {
                    this.currentChangesetNode = (Node)result.getSingle();
                } else {
                    LinkedHashMap<String, Object> changesetProps = new LinkedHashMap<String, Object>();
                    changesetProps.put(INDEX_NAME_CHANGESET, this.currentChangesetId);
                    changesetProps.put("timestamp", nodeProps.get("timestamp"));
                    this.currentChangesetNode = this.addNode(INDEX_NAME_CHANGESET, changesetProps, INDEX_NAME_CHANGESET);
                    ++this.changesetCount;
                    if (this.currentUserNode != null) {
                        this.createRelationship(this.currentChangesetNode, this.currentUserNode, OSMRelation.USER);
                    }
                }
                result.close();
            }
            return this.currentChangesetNode;
        }

        @Override
        protected Node getUserNode(Map<String, Object> nodeProps) {
            try {
                long uid = Long.parseLong(nodeProps.remove("uid").toString());
                String name = nodeProps.remove(INDEX_NAME_USER).toString();
                if (uid != this.currentUserId) {
                    this.currentUserId = uid;
                    IndexHits result = this.indexFor(INDEX_NAME_USER).get("uid", (Object)this.currentUserId);
                    if (result.size() > 0) {
                        this.currentUserNode = (Node)this.indexFor(INDEX_NAME_USER).get("uid", (Object)this.currentUserId).getSingle();
                    } else {
                        LinkedHashMap<String, Object> userProps = new LinkedHashMap<String, Object>();
                        userProps.put("uid", this.currentUserId);
                        userProps.put("name", name);
                        userProps.put("timestamp", nodeProps.get("timestamp"));
                        this.currentUserNode = this.addNode(INDEX_NAME_USER, userProps, "uid");
                        ++this.userCount;
                        if (this.usersNode == null) {
                            this.usersNode = this.graphDb.createNode();
                            ((Node)this.osm_dataset).createRelationshipTo(this.usersNode, (RelationshipType)OSMRelation.USERS);
                        }
                        this.usersNode.createRelationshipTo(this.currentUserNode, (RelationshipType)OSMRelation.OSM_USER);
                    }
                    result.close();
                }
            }
            catch (Exception e) {
                this.currentUserId = -1L;
                this.currentUserNode = null;
                this.logMissingUser(nodeProps);
            }
            return this.currentUserNode;
        }

        public String toString() {
            return "OSMGraphWriter: DatabaseService[" + this.graphDb + "]:txInterval[" + this.txInterval + "]";
        }
    }

    private static abstract class OSMWriter<T> {
        protected StatsManager statsManager;
        protected OSMImporter osmImporter;
        protected T osm_dataset;
        protected HashMap<String, Integer> stats = new HashMap();
        protected HashMap<String, LogCounter> nodeFindStats = new HashMap();
        protected long logTime = 0L;
        protected long findTime = 0L;
        protected long firstFindTime = 0L;
        protected long lastFindTime = 0L;
        protected long firstLogTime = 0L;
        protected static int foundNodes = 0;
        protected static int createdNodes = 0;
        protected int foundOSMNodes = 0;
        protected int missingUserCount = 0;
        private int missingNodeCount = 0;
        private int missingMemberCount = 0;
        protected T currentNode = null;
        protected T prev_way = null;
        protected T prev_relation = null;
        protected int nodeCount = 0;
        protected int poiCount = 0;
        protected int wayCount = 0;
        protected int relationCount = 0;
        protected int userCount = 0;
        protected int changesetCount = 0;

        private OSMWriter(StatsManager statsManager, OSMImporter osmImporter) {
            this.statsManager = statsManager;
            this.osmImporter = osmImporter;
        }

        public static OSMWriter<Long> fromBatchInserter(BatchInserter batchInserter, StatsManager stats, OSMImporter osmImporter) {
            return new OSMBatchWriter(batchInserter, stats, osmImporter);
        }

        public static OSMWriter<Node> fromGraphDatabase(GraphDatabaseService graphDb, StatsManager stats, OSMImporter osmImporter, int txInterval) {
            return new OSMGraphWriter(graphDb, stats, osmImporter, txInterval);
        }

        protected abstract T getOrCreateNode(String var1, String var2, T var3, RelationshipType var4);

        protected abstract T getOrCreateOSMDataset(String var1);

        protected abstract void setDatasetProperties(Map<String, Object> var1);

        protected abstract void addNodeTags(T var1, LinkedHashMap<String, Object> var2, String var3);

        protected abstract void addNodeGeometry(T var1, int var2, Envelope var3, int var4);

        protected abstract T addNode(String var1, Map<String, Object> var2, String var3);

        protected abstract void createRelationship(T var1, T var2, RelationshipType var3, LinkedHashMap<String, Object> var4);

        protected void createRelationship(T from, T to, RelationshipType relType) {
            this.createRelationship(from, to, relType, null);
        }

        protected void logMissingUser(Map<String, Object> nodeProps) {
            if (this.missingUserCount++ < 10) {
                System.err.println("Missing user or uid: " + nodeProps.toString());
            }
        }

        protected void logNodeFoundFrom(String key) {
            LogCounter counter = this.nodeFindStats.get(key);
            if (counter == null) {
                counter = new LogCounter();
                this.nodeFindStats.put(key, counter);
            }
            counter.count++;
            ++this.foundOSMNodes;
            long currentTime = System.currentTimeMillis();
            if (this.lastFindTime > 0L) {
                counter.totalTime += currentTime - this.lastFindTime;
            }
            this.lastFindTime = currentTime;
            this.logNodesFound(currentTime);
        }

        protected void logNodesFound(long currentTime) {
            if (this.firstFindTime == 0L) {
                this.firstFindTime = currentTime;
                this.findTime = currentTime;
            }
            if (currentTime == 0L || currentTime - this.findTime > 1432L) {
                int duration = 0;
                if (currentTime > 0L) {
                    duration = (int)((currentTime - this.firstFindTime) / 1000L);
                }
                System.out.println(new Date(currentTime) + ": Found " + this.foundOSMNodes + " nodes during " + duration + "s way creation: ");
                for (String type : this.nodeFindStats.keySet()) {
                    LogCounter found = this.nodeFindStats.get(type);
                    double rate = 0.0;
                    if (found.totalTime > 0L) {
                        rate = 1000.0 * (double)found.count / (double)found.totalTime;
                    }
                    System.out.println("\t" + type + ": \t" + found.count + "/" + found.totalTime / 1000L + "s" + " \t(" + rate + " nodes/second)");
                }
                this.findTime = currentTime;
            }
        }

        protected void logNodeAddition(LinkedHashMap<String, Object> tags, String type) {
            Integer count = this.stats.get(type);
            if (count == null) {
                count = 1;
            } else {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            this.stats.put(type, count);
            long currentTime = System.currentTimeMillis();
            if (this.firstLogTime == 0L) {
                this.firstLogTime = currentTime;
                this.logTime = currentTime;
            }
            if (currentTime - this.logTime > 1432L) {
                System.out.println(new Date(currentTime) + ": Saving " + type + " " + count + " \t(" + 1000.0 * (double)count.intValue() / (double)(currentTime - this.firstLogTime) + " " + type + "/second)");
                this.logTime = currentTime;
            }
        }

        void describeLoaded() {
            this.logNodesFound(0L);
            for (String type : new String[]{"node", "way", "relation"}) {
                Integer count = this.stats.get(type);
                if (count == null) continue;
                System.out.println("Loaded " + count + " " + type + "s");
            }
        }

        protected abstract long getDatasetId();

        private void missingNode(long ndRef) {
            if (this.missingNodeCount++ < 10) {
                this.osmImporter.error("Cannot find node for osm-id " + ndRef);
            }
        }

        private void describeMissing() {
            if (this.missingNodeCount > 0) {
                this.osmImporter.error("When processing the ways, there were " + this.missingNodeCount + " missing nodes");
            }
            if (this.missingMemberCount > 0) {
                this.osmImporter.error("When processing the relations, there were " + this.missingMemberCount + " missing members");
            }
        }

        private void missingMember(String description) {
            if (this.missingMemberCount++ < 10) {
                this.osmImporter.error("Cannot find member: " + description);
            }
        }

        protected void addOSMBBox(Map<String, Object> bboxProperties) {
            T bbox = this.addNode("bbox", bboxProperties, null);
            this.createRelationship(this.osm_dataset, bbox, OSMRelation.BBOX);
        }

        protected void createOSMNode(Map<String, Object> nodeProps) {
            T changesetNode = this.getChangesetNode(nodeProps);
            this.currentNode = this.addNode("node", nodeProps, "node_osm_id");
            this.createRelationship(this.currentNode, changesetNode, OSMRelation.CHANGESET);
            ++this.nodeCount;
            this.debugNodeWithId(this.currentNode, "node_osm_id", new long[]{8090260L, 273534207L});
        }

        private void addOSMNodeTags(boolean allPoints, LinkedHashMap<String, Object> currentNodeTags) {
            currentNodeTags.remove("created_by");
            if (allPoints || currentNodeTags.size() > 0) {
                Map<String, Object> nodeProps = this.getNodeProperties(this.currentNode);
                Envelope bbox = new Envelope();
                double[] location = new double[]{(Double)nodeProps.get("lon"), (Double)nodeProps.get("lat")};
                bbox.expandToInclude(location[0], location[1]);
                this.addNodeGeometry(this.currentNode, 1, bbox, 1);
                ++this.poiCount;
            }
            this.addNodeTags(this.currentNode, currentNodeTags, "node");
        }

        protected void debugNodeWithId(T node, String idName, long[] idValues) {
            Map<String, Object> nodeProperties = this.getNodeProperties(node);
            String node_osm_id = nodeProperties.get(idName).toString();
            for (long idValue : idValues) {
                if (!node_osm_id.equals(Long.toString(idValue))) continue;
                System.out.println("Debug node: " + node_osm_id);
            }
        }

        protected void createOSMWay(Map<String, Object> wayProperties, ArrayList<Long> wayNodes, LinkedHashMap<String, Object> wayTags) {
            String way_osm_id;
            RoadDirection direction = OSMImporter.isOneway(wayTags);
            String name = (String)wayTags.get("name");
            int geometry = 2;
            boolean isRoad = wayTags.containsKey("highway");
            if (isRoad) {
                wayProperties.put("oneway", direction.toString());
                wayProperties.put("highway", wayTags.get("highway"));
            }
            if (name != null) {
                wayProperties.put("name", name);
            }
            if ((way_osm_id = (String)wayProperties.get("way_osm_id")).equals("28338132")) {
                System.out.println("Debug way: " + way_osm_id);
            }
            T changesetNode = this.getChangesetNode(wayProperties);
            T way = this.addNode(INDEX_NAME_WAY, wayProperties, "way_osm_id");
            this.createRelationship(way, changesetNode, OSMRelation.CHANGESET);
            if (this.prev_way == null) {
                this.createRelationship(this.osm_dataset, way, OSMRelation.WAYS);
            } else {
                this.createRelationship(this.prev_way, way, OSMRelation.NEXT);
            }
            this.prev_way = way;
            this.addNodeTags(way, wayTags, "way");
            Envelope bbox = new Envelope();
            Object firstNode = null;
            Object prevNode = null;
            T prevProxy = null;
            Map<String, Object> prevProps = null;
            LinkedHashMap<String, Object> relProps = new LinkedHashMap<String, Object>();
            HashMap<String, Boolean> directionProps = new HashMap<String, Boolean>();
            directionProps.put("oneway", true);
            for (long nd_ref : wayNodes) {
                T pointNode = this.getOSMNode(nd_ref, changesetNode);
                if (pointNode == null) {
                    this.missingNode(nd_ref);
                    continue;
                }
                T proxyNode = this.createProxyNode();
                if (firstNode == null) {
                    firstNode = pointNode;
                }
                if (prevNode == pointNode) continue;
                this.createRelationship(proxyNode, pointNode, OSMRelation.NODE, null);
                Map<String, Object> nodeProps = this.getNodeProperties(pointNode);
                double[] location = new double[]{(Double)nodeProps.get("lon"), (Double)nodeProps.get("lat")};
                bbox.expandToInclude(location[0], location[1]);
                if (prevProxy == null) {
                    this.createRelationship(way, proxyNode, OSMRelation.FIRST_NODE);
                } else {
                    relProps.clear();
                    double[] prevLoc = new double[]{(Double)prevProps.get("lon"), (Double)prevProps.get("lat")};
                    double length = OSMImporter.distance(prevLoc[0], prevLoc[1], location[0], location[1]);
                    relProps.put("length", length);
                    if (direction == RoadDirection.BACKWARD) {
                        this.createRelationship(proxyNode, prevProxy, OSMRelation.NEXT, relProps);
                    } else {
                        this.createRelationship(prevProxy, proxyNode, OSMRelation.NEXT, relProps);
                    }
                }
                prevNode = pointNode;
                prevProxy = proxyNode;
                prevProps = nodeProps;
            }
            if (firstNode != null && prevNode == firstNode) {
                geometry = 3;
            }
            if (wayNodes.size() < 2) {
                geometry = 1;
            }
            this.addNodeGeometry(way, geometry, bbox, wayNodes.size());
            ++this.wayCount;
        }

        private void createOSMRelation(Map<String, Object> relationProperties, ArrayList<Map<String, Object>> relationMembers, LinkedHashMap<String, Object> relationTags) {
            String name = (String)relationTags.get("name");
            if (name != null) {
                relationProperties.put("name", name);
            }
            T relation = this.addNode("relation", relationProperties, "relation_osm_id");
            if (this.prev_relation == null) {
                this.createRelationship(this.osm_dataset, relation, OSMRelation.RELATIONS);
            } else {
                this.createRelationship(this.prev_relation, relation, OSMRelation.NEXT);
            }
            this.prev_relation = relation;
            this.addNodeTags(relation, relationTags, "relation");
            GeometryMetaData metaGeom = new GeometryMetaData(5);
            Object prevMember = null;
            LinkedHashMap<String, Object> relProps = new LinkedHashMap<String, Object>();
            for (Map<String, Object> memberProps : relationMembers) {
                String memberType = (String)memberProps.get("type");
                long member_ref = Long.parseLong(memberProps.get("ref").toString());
                if (memberType != null) {
                    T member = this.getSingleNode(memberType, memberType + "_osm_id", member_ref);
                    if (null == member || prevMember == member) {
                        this.missingMember(memberProps.toString());
                        continue;
                    }
                    if (member == relation) {
                        this.osmImporter.error("Cannot add relation to same member: relation[" + relationTags + "] - member[" + memberProps + "]");
                        continue;
                    }
                    Map<String, Object> nodeProps = this.getNodeProperties(member);
                    if (memberType.equals("node")) {
                        double[] location = new double[]{(Double)nodeProps.get("lon"), (Double)nodeProps.get("lat")};
                        metaGeom.expandToIncludePoint(location);
                    } else if (memberType.equals("nodes")) {
                        System.err.println("Unexpected 'nodes' member type");
                    } else {
                        this.updateGeometryMetaDataFromMember(member, metaGeom, nodeProps);
                    }
                    relProps.clear();
                    String role = (String)memberProps.get("role");
                    if (role != null && role.length() > 0) {
                        relProps.put("role", role);
                        if (role.equals("outer")) {
                            metaGeom.setPolygon();
                        }
                    }
                    this.createRelationship(relation, member, OSMRelation.MEMBER, relProps);
                    prevMember = member;
                    continue;
                }
                System.err.println("Cannot process invalid relation member: " + memberProps.toString());
            }
            if (metaGeom.isValid()) {
                this.addNodeGeometry(relation, metaGeom.getGeometryType(), metaGeom.getBBox(), metaGeom.getVertices());
            }
            ++this.relationCount;
        }

        protected void optimize() {
        }

        protected abstract T getSingleNode(String var1, String var2, Object var3);

        protected abstract Map<String, Object> getNodeProperties(T var1);

        protected abstract T getOSMNode(long var1, T var3);

        protected abstract void updateGeometryMetaDataFromMember(T var1, GeometryMetaData var2, Map<String, Object> var3);

        protected abstract void finish();

        protected abstract T createProxyNode();

        protected abstract T getChangesetNode(Map<String, Object> var1);

        protected abstract T getUserNode(Map<String, Object> var1);

        private class LogCounter {
            private long count = 0L;
            private long totalTime = 0L;

            private LogCounter() {
            }
        }
    }

    private static class GeometryMetaData {
        private Envelope bbox = new Envelope();
        private int vertices = 0;
        private int geometry = -1;

        public GeometryMetaData(int type) {
            this.geometry = type;
        }

        public int getGeometryType() {
            return this.geometry;
        }

        public void expandToIncludePoint(double[] location) {
            this.bbox.expandToInclude(location[0], location[1]);
            ++this.vertices;
            this.geometry = -1;
        }

        public void expandToIncludeBBox(Map<String, Object> nodeProps) {
            double[] sbb = (double[])nodeProps.get("bbox");
            this.bbox.expandToInclude(sbb[0], sbb[2]);
            this.bbox.expandToInclude(sbb[1], sbb[3]);
            this.vertices += ((Integer)nodeProps.get("vertices")).intValue();
        }

        public void checkSupportedGeometry(Integer memGType) {
            if ((memGType == null || memGType != 2) && this.geometry != 3) {
                this.geometry = -1;
            }
        }

        public void setPolygon() {
            this.geometry = 3;
        }

        public boolean isValid() {
            return this.geometry > 0;
        }

        public int getVertices() {
            return this.vertices;
        }

        public Envelope getBBox() {
            return this.bbox;
        }
    }

    private static class StatsManager {
        private HashMap<String, TagStats> tagStats = new HashMap();
        private HashMap<Integer, Integer> geomStats = new HashMap();

        private StatsManager() {
        }

        protected TagStats getTagStats(String type) {
            if (!this.tagStats.containsKey(type)) {
                this.tagStats.put(type, new TagStats(type));
            }
            return this.tagStats.get(type);
        }

        protected int addToTagStats(String type, String key) {
            this.getTagStats("all").add(key);
            return this.getTagStats(type).add(key);
        }

        protected int addToTagStats(String type, Collection<String> keys) {
            int count = 0;
            for (String key : keys) {
                count += this.addToTagStats(type, key);
            }
            return count;
        }

        protected void printTagStats() {
            System.out.println("Tag statistics for " + this.tagStats.size() + " types:");
            for (String key : this.tagStats.keySet()) {
                TagStats stats = this.tagStats.get(key);
                System.out.println("\t" + key + ": " + stats);
            }
        }

        protected void addGeomStats(Node geomNode) {
            if (geomNode != null) {
                this.addGeomStats((Integer)geomNode.getProperty("gtype", null));
            }
        }

        protected void addGeomStats(Integer geom) {
            Integer count = this.geomStats.get(geom);
            this.geomStats.put(geom, count == null ? 1 : count + 1);
        }

        protected void dumpGeomStats() {
            System.out.println("Geometry statistics for " + this.geomStats.size() + " geometry types:");
            for (Integer key : this.geomStats.keySet()) {
                Integer count = this.geomStats.get(key);
                System.out.println("\t" + SpatialDatabaseService.convertGeometryTypeToName(key) + ": " + count);
            }
            this.geomStats.clear();
        }
    }

    private static class TagStats {
        private String name;
        private int count = 0;
        private HashMap<String, Integer> stats = new HashMap();

        TagStats(String name) {
            this.name = name;
        }

        int add(String key) {
            ++this.count;
            if (this.stats.containsKey(key)) {
                int num = this.stats.get(key);
                this.stats.put(key, ++num);
                return num;
            }
            this.stats.put(key, 1);
            return 1;
        }

        public String[] getTags() {
            if (this.stats.size() > 0) {
                int threshold = this.count / (this.stats.size() * 20);
                ArrayList<String> tags = new ArrayList<String>();
                for (String key : this.stats.keySet()) {
                    if (key.equals("waterway")) {
                        System.out.println("debug[" + key + "]: " + this.stats.get(key));
                    }
                    if (this.stats.get(key) <= threshold) continue;
                    tags.add(key);
                }
                Collections.sort(tags);
                return tags.toArray(new String[tags.size()]);
            }
            return new String[0];
        }

        public String toString() {
            return "TagStats[" + this.name + "]: " + Arrays.asList(this.getTags());
        }
    }
}

