/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.osm;

import java.io.File;
import java.util.HashMap;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.json.simple.JSONObject;
import org.neo4j.collections.rtree.Listener;
import org.neo4j.collections.rtree.NullListener;
import org.neo4j.gis.spatial.DynamicLayer;
import org.neo4j.gis.spatial.DynamicLayerConfig;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.gis.spatial.SpatialDataset;
import org.neo4j.gis.spatial.osm.OSMDataset;
import org.neo4j.gis.spatial.osm.OSMRelation;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OSMLayer
extends DynamicLayer {
    private OSMDataset osmDataset;

    @Override
    public SpatialDataset getDataset() {
        if (this.osmDataset == null) {
            this.osmDataset = new OSMDataset(this.getSpatialDatabase(), this, this.layerNode);
        }
        return this.osmDataset;
    }

    public OSMDataset getDataset(long datasetId) {
        if (this.osmDataset == null) {
            this.osmDataset = new OSMDataset(this.getSpatialDatabase(), this, this.layerNode, datasetId);
        }
        return this.osmDataset;
    }

    @Override
    public Integer getGeometryType() {
        return 0;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        try {
            return DefaultGeographicCRS.WGS84;
        }
        catch (Exception e) {
            System.err.println("Failed to decode WGS84 CRS: " + e.getMessage());
            e.printStackTrace(System.err);
            return null;
        }
    }

    protected void clear() {
        this.index.clear((Listener)new NullListener());
    }

    public Node addWay(Node way) {
        return this.addWay(way, false);
    }

    public Node addWay(Node way, boolean verifyGeom) {
        Relationship geomRel = way.getSingleRelationship((RelationshipType)OSMRelation.GEOM, Direction.OUTGOING);
        if (geomRel != null) {
            Node geomNode = geomRel.getEndNode();
            try {
                if (verifyGeom) {
                    this.getGeometryEncoder().decodeGeometry((PropertyContainer)geomNode);
                }
                this.index.add(geomNode);
            }
            catch (Exception e) {
                System.err.println("Failed geometry test on node " + geomNode.getProperty("name", (Object)geomNode.toString()) + ": " + e.getMessage());
                for (String key : geomNode.getPropertyKeys()) {
                    System.err.println("\t" + key + ": " + geomNode.getProperty(key));
                }
                System.err.println("For way node " + way);
                for (String key : way.getPropertyKeys()) {
                    System.err.println("\t" + key + ": " + way.getProperty(key));
                }
            }
            return geomNode;
        }
        return null;
    }

    @Override
    public Iterable<Node> getAllGeometryNodes() {
        return this.index.getAllIndexedNodes();
    }

    public boolean removeDynamicLayer(String name) {
        return this.removeLayerConfig(name);
    }

    public DynamicLayerConfig addDynamicLayerOnWayTags(String name, int type, HashMap<?, ?> tags) {
        JSONObject query = new JSONObject();
        if (tags != null && !tags.isEmpty()) {
            JSONObject step2tags = new JSONObject();
            JSONObject step2way = new JSONObject();
            JSONObject properties = new JSONObject();
            for (Object key : tags.keySet()) {
                Object value = tags.get(key);
                if (value != null && (value.toString().length() < 1 || value.equals("*"))) {
                    value = null;
                }
                properties.put((Object)key.toString(), value);
            }
            step2tags.put((Object)"properties", (Object)properties);
            step2tags.put((Object)"type", (Object)"TAGS");
            step2tags.put((Object)"direction", (Object)"OUTGOING");
            step2way.put((Object)"step", (Object)step2tags);
            step2way.put((Object)"type", (Object)"GEOM");
            step2way.put((Object)"direction", (Object)"INCOMING");
            query.put((Object)"step", (Object)step2way);
        }
        if (type > 0) {
            JSONObject properties = new JSONObject();
            properties.put((Object)"gtype", (Object)type);
            query.put((Object)"properties", (Object)properties);
        }
        System.out.println("Created dynamic layer query: " + query.toJSONString());
        return this.addLayerConfig(name, type, query.toJSONString());
    }

    public DynamicLayerConfig addSimpleDynamicLayer(String key, String value) {
        return this.addSimpleDynamicLayer(key, value, 2);
    }

    public DynamicLayerConfig addSimpleDynamicLayer(String key, String value, int gtype) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(key, value);
        return this.addDynamicLayerOnWayTags(value == null ? key : key + "-" + value, gtype, tags);
    }

    public DynamicLayerConfig addSimpleDynamicLayer(int gtype, String tagsQuery) {
        HashMap<String, String> tags = new HashMap<String, String>();
        StringBuffer name = new StringBuffer();
        for (String query : tagsQuery.split("\\s*\\,\\s*")) {
            String[] fields = query.split("\\s*\\=+\\s*");
            String key = fields[0];
            String value = fields.length > 1 ? fields[1] : "*";
            tags.put(key, value);
            if (name.length() > 0) {
                name.append("-");
            }
            name.append(key);
            name.append("-");
            if (value.equals("*")) continue;
            name.append(value);
        }
        return this.addDynamicLayerOnWayTags(name.toString(), gtype, tags);
    }

    public DynamicLayerConfig addSimpleDynamicLayer(String tagsQuery) {
        return this.addSimpleDynamicLayer(2, tagsQuery);
    }

    public DynamicLayerConfig addSimpleDynamicLayer(int gtype) {
        return this.addDynamicLayerOnWayTags(SpatialDatabaseService.convertGeometryTypeToName(gtype), gtype, null);
    }

    @Override
    public File getStyle() {
        return new File("dev/neo4j/neo4j-spatial/src/main/resources/sld/osm/osm.sld");
    }
}

