/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.osm;

import java.io.File;
import java.util.HashMap;
import org.neo4j.gis.spatial.ShapefileExporter;
import org.neo4j.gis.spatial.SpatialDatabaseService;
import org.neo4j.gis.spatial.osm.OSMLayer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.EmbeddedGraphDatabase;

public class OSMLayerToShapefileExporter {
    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage: osmtoshp databasedir exportdir osmdataset layerspec <..layerspecs..>");
        } else {
            EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(new File(args[0]).getAbsolutePath());
            SpatialDatabaseService spatial = new SpatialDatabaseService((GraphDatabaseService)db);
            OSMLayer layer = (OSMLayer)spatial.getLayer(args[2]);
            if (layer != null) {
                ShapefileExporter exporter = new ShapefileExporter((GraphDatabaseService)db);
                exporter.setExportDir(args[1] + File.separator + layer.getName());
                for (int i = 3; i < args.length; ++i) {
                    String key;
                    String[] fields = args[i].split("[\\.\\-]");
                    HashMap<String, String> tags = new HashMap<String, String>();
                    String name = key = fields[0];
                    if (fields.length > 1) {
                        String value = fields.length > 1 ? fields[1] : null;
                        name = key + "-" + value;
                        tags.put(key, value);
                    }
                    try {
                        if (layer.getLayerNames().contains(name)) {
                            System.out.println("Exporting previously existing layer: " + name);
                            exporter.exportLayer(name);
                            continue;
                        }
                        System.out.println("Creating and exporting new layer: " + name);
                        layer.addDynamicLayerOnWayTags(name, 2, tags);
                        exporter.exportLayer(name);
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println("Failed to export dynamic layer " + name + ": " + e);
                        e.printStackTrace(System.err);
                    }
                }
            } else {
                System.err.println("No such layer: " + args[2]);
            }
            db.shutdown();
        }
    }
}

