/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.pipes;

import com.tinkerpop.gremlin.groovy.GremlinGroovyPipeline;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.filter.FilterPipe;
import com.tinkerpop.pipes.util.StartPipe;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.neo4j.Neo4jFeatureBuilder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.neo4j.collections.rtree.filter.SearchAll;
import org.neo4j.collections.rtree.filter.SearchFilter;
import org.neo4j.gis.spatial.Layer;
import org.neo4j.gis.spatial.SpatialDatabaseRecord;
import org.neo4j.gis.spatial.SpatialRecord;
import org.neo4j.gis.spatial.SpatialTopologyUtils;
import org.neo4j.gis.spatial.filter.SearchIntersectWindow;
import org.neo4j.gis.spatial.filter.SearchRecords;
import org.neo4j.gis.spatial.pipes.AbstractGeoPipe;
import org.neo4j.gis.spatial.pipes.GeoPipeFlow;
import org.neo4j.gis.spatial.pipes.filtering.FilterCQL;
import org.neo4j.gis.spatial.pipes.filtering.FilterContain;
import org.neo4j.gis.spatial.pipes.filtering.FilterCover;
import org.neo4j.gis.spatial.pipes.filtering.FilterCoveredBy;
import org.neo4j.gis.spatial.pipes.filtering.FilterCross;
import org.neo4j.gis.spatial.pipes.filtering.FilterDisjoint;
import org.neo4j.gis.spatial.pipes.filtering.FilterEmpty;
import org.neo4j.gis.spatial.pipes.filtering.FilterEqualExact;
import org.neo4j.gis.spatial.pipes.filtering.FilterEqualNorm;
import org.neo4j.gis.spatial.pipes.filtering.FilterEqualTopo;
import org.neo4j.gis.spatial.pipes.filtering.FilterInRelation;
import org.neo4j.gis.spatial.pipes.filtering.FilterIntersect;
import org.neo4j.gis.spatial.pipes.filtering.FilterIntersectWindow;
import org.neo4j.gis.spatial.pipes.filtering.FilterInvalid;
import org.neo4j.gis.spatial.pipes.filtering.FilterOverlap;
import org.neo4j.gis.spatial.pipes.filtering.FilterProperty;
import org.neo4j.gis.spatial.pipes.filtering.FilterPropertyNotNull;
import org.neo4j.gis.spatial.pipes.filtering.FilterPropertyNull;
import org.neo4j.gis.spatial.pipes.filtering.FilterTouch;
import org.neo4j.gis.spatial.pipes.filtering.FilterValid;
import org.neo4j.gis.spatial.pipes.filtering.FilterWithin;
import org.neo4j.gis.spatial.pipes.processing.ApplyAffineTransformation;
import org.neo4j.gis.spatial.pipes.processing.Area;
import org.neo4j.gis.spatial.pipes.processing.Boundary;
import org.neo4j.gis.spatial.pipes.processing.Buffer;
import org.neo4j.gis.spatial.pipes.processing.Centroid;
import org.neo4j.gis.spatial.pipes.processing.ConvexHull;
import org.neo4j.gis.spatial.pipes.processing.CopyDatabaseRecordProperties;
import org.neo4j.gis.spatial.pipes.processing.Densify;
import org.neo4j.gis.spatial.pipes.processing.DensityIslands;
import org.neo4j.gis.spatial.pipes.processing.Difference;
import org.neo4j.gis.spatial.pipes.processing.Dimension;
import org.neo4j.gis.spatial.pipes.processing.Distance;
import org.neo4j.gis.spatial.pipes.processing.EndPoint;
import org.neo4j.gis.spatial.pipes.processing.Envelope;
import org.neo4j.gis.spatial.pipes.processing.ExtractGeometries;
import org.neo4j.gis.spatial.pipes.processing.ExtractPoints;
import org.neo4j.gis.spatial.pipes.processing.GML;
import org.neo4j.gis.spatial.pipes.processing.GeoJSON;
import org.neo4j.gis.spatial.pipes.processing.GeometryType;
import org.neo4j.gis.spatial.pipes.processing.InteriorPoint;
import org.neo4j.gis.spatial.pipes.processing.IntersectAll;
import org.neo4j.gis.spatial.pipes.processing.Intersection;
import org.neo4j.gis.spatial.pipes.processing.KeyholeMarkupLanguage;
import org.neo4j.gis.spatial.pipes.processing.Length;
import org.neo4j.gis.spatial.pipes.processing.Max;
import org.neo4j.gis.spatial.pipes.processing.Min;
import org.neo4j.gis.spatial.pipes.processing.NumGeometries;
import org.neo4j.gis.spatial.pipes.processing.NumPoints;
import org.neo4j.gis.spatial.pipes.processing.OrthodromicDistance;
import org.neo4j.gis.spatial.pipes.processing.OrthodromicLength;
import org.neo4j.gis.spatial.pipes.processing.SimplifyPreservingTopology;
import org.neo4j.gis.spatial.pipes.processing.SimplifyWithDouglasPeucker;
import org.neo4j.gis.spatial.pipes.processing.Sort;
import org.neo4j.gis.spatial.pipes.processing.StartPoint;
import org.neo4j.gis.spatial.pipes.processing.SymDifference;
import org.neo4j.gis.spatial.pipes.processing.Union;
import org.neo4j.gis.spatial.pipes.processing.UnionAll;
import org.neo4j.gis.spatial.pipes.processing.WellKnownText;
import org.neo4j.graphdb.Node;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class GeoPipeline
extends GremlinGroovyPipeline<GeoPipeFlow, GeoPipeFlow> {
    protected Layer layer;

    protected GeoPipeline(Layer layer) {
        this.layer = layer;
    }

    protected static StartPipe<GeoPipeFlow> createStartPipe(List<SpatialDatabaseRecord> records) {
        return GeoPipeline.createStartPipe(records.iterator());
    }

    protected static StartPipe<GeoPipeFlow> createStartPipe(final Iterator<SpatialDatabaseRecord> records) {
        return new StartPipe((Object)new Iterator<GeoPipeFlow>(){

            @Override
            public boolean hasNext() {
                return records.hasNext();
            }

            @Override
            public GeoPipeFlow next() {
                return new GeoPipeFlow((SpatialDatabaseRecord)records.next());
            }

            @Override
            public void remove() {
                records.remove();
            }
        });
    }

    public static GeoPipeline start(Layer layer, Iterator<SpatialDatabaseRecord> records) {
        GeoPipeline pipeline = new GeoPipeline(layer);
        return (GeoPipeline)pipeline.add((Pipe)GeoPipeline.createStartPipe(records));
    }

    public static GeoPipeline start(Layer layer, List<SpatialDatabaseRecord> records) {
        GeoPipeline pipeline = new GeoPipeline(layer);
        return (GeoPipeline)pipeline.add((Pipe)GeoPipeline.createStartPipe(records));
    }

    public static GeoPipeline start(Layer layer, SearchRecords records) {
        GeoPipeline pipeline = new GeoPipeline(layer);
        return (GeoPipeline)pipeline.add((Pipe)GeoPipeline.createStartPipe(records));
    }

    public static GeoPipeline start(Layer layer, SearchFilter searchFilter) {
        return GeoPipeline.start(layer, layer.getIndex().search(searchFilter));
    }

    public static GeoPipeline start(Layer layer) {
        return GeoPipeline.start(layer, (SearchFilter)new SearchAll());
    }

    public static GeoPipeline startIntersectWindowSearch(Layer layer, com.vividsolutions.jts.geom.Envelope searchWindow) {
        return GeoPipeline.start(layer, layer.getIndex().search((SearchFilter)new SearchIntersectWindow(layer, searchWindow)));
    }

    public static GeoPipeline startContainSearch(Layer layer, Geometry geometry) {
        return GeoPipeline.startIntersectWindowSearch(layer, geometry.getEnvelopeInternal()).containFilter(geometry);
    }

    public static GeoPipeline startCoverSearch(Layer layer, Geometry geometry) {
        return GeoPipeline.startIntersectWindowSearch(layer, geometry.getEnvelopeInternal()).coverFilter(geometry);
    }

    public static GeoPipeline startCoveredBySearch(Layer layer, Geometry geometry) {
        return GeoPipeline.startIntersectWindowSearch(layer, geometry.getEnvelopeInternal()).coveredByFilter(geometry);
    }

    public static GeoPipeline startCrossSearch(Layer layer, Geometry geometry) {
        return GeoPipeline.startIntersectWindowSearch(layer, geometry.getEnvelopeInternal()).crossFilter(geometry);
    }

    public static GeoPipeline startEqualExactSearch(Layer layer, Geometry geometry, double tolerance) {
        return GeoPipeline.startIntersectWindowSearch(layer, geometry.getEnvelopeInternal()).equalExactFilter(geometry, tolerance);
    }

    public static GeoPipeline startIntersectSearch(Layer layer, Geometry geometry) {
        return GeoPipeline.startIntersectWindowSearch(layer, geometry.getEnvelopeInternal()).intersectionFilter(geometry);
    }

    public static GeoPipeline startOverlapSearch(Layer layer, Geometry geometry) {
        return GeoPipeline.startIntersectWindowSearch(layer, geometry.getEnvelopeInternal()).overlapFilter(geometry);
    }

    public static GeoPipeline startTouchSearch(Layer layer, Geometry geometry) {
        return GeoPipeline.startIntersectWindowSearch(layer, geometry.getEnvelopeInternal()).touchFilter(geometry);
    }

    public static GeoPipeline startWithinSearch(Layer layer, Geometry geometry) {
        return GeoPipeline.startIntersectWindowSearch(layer, geometry.getEnvelopeInternal()).withinFilter(geometry);
    }

    public static GeoPipeline startNearestNeighborLatLonSearch(Layer layer, Coordinate point, int numberOfItemsToFind) {
        com.vividsolutions.jts.geom.Envelope searchWindow = SpatialTopologyUtils.createEnvelopeForGeometryDensityEstimate(layer, point, numberOfItemsToFind);
        return GeoPipeline.startNearestNeighborLatLonSearch(layer, point, searchWindow);
    }

    public static GeoPipeline startNearestNeighborLatLonSearch(Layer layer, Coordinate point, com.vividsolutions.jts.geom.Envelope searchWindow) {
        return GeoPipeline.start(layer, (SearchFilter)new SearchIntersectWindow(layer, searchWindow)).calculateOrthodromicDistance(point);
    }

    public static GeoPipeline startNearestNeighborLatLonSearch(Layer layer, Coordinate point, double maxDistanceInKm) {
        com.vividsolutions.jts.geom.Envelope extent = OrthodromicDistance.suggestSearchWindow(point, maxDistanceInKm);
        return GeoPipeline.start(layer, (SearchFilter)new SearchIntersectWindow(layer, extent)).calculateOrthodromicDistance(point).propertyFilter("OrthodromicDistance", maxDistanceInKm, FilterPipe.Filter.LESS_THAN_EQUAL);
    }

    public static GeoPipeline startNearestNeighborSearch(Layer layer, Coordinate point, int numberOfItemsToFind) {
        com.vividsolutions.jts.geom.Envelope searchWindow = SpatialTopologyUtils.createEnvelopeForGeometryDensityEstimate(layer, point, numberOfItemsToFind);
        return GeoPipeline.startNearestNeighborSearch(layer, point, searchWindow);
    }

    public static GeoPipeline startNearestNeighborSearch(Layer layer, Coordinate point, com.vividsolutions.jts.geom.Envelope searchWindow) {
        return GeoPipeline.start(layer, (SearchFilter)new SearchIntersectWindow(layer, searchWindow)).calculateDistance((Geometry)layer.getGeometryFactory().createPoint(point));
    }

    public static GeoPipeline startNearestNeighborSearch(Layer layer, Coordinate point, double maxDistance) {
        com.vividsolutions.jts.geom.Envelope extent = new com.vividsolutions.jts.geom.Envelope(point.x - maxDistance, point.x + maxDistance, point.y - maxDistance, point.y + maxDistance);
        return GeoPipeline.start(layer, (SearchFilter)new SearchIntersectWindow(layer, extent)).calculateDistance((Geometry)layer.getGeometryFactory().createPoint(point)).propertyFilter("Distance", maxDistance, FilterPipe.Filter.LESS_THAN_EQUAL);
    }

    public GeoPipeline addPipe(AbstractGeoPipe geoPipe) {
        return (GeoPipeline)this.add((Pipe)geoPipe);
    }

    public GeoPipeline copyDatabaseRecordProperties() {
        return this.addPipe(new CopyDatabaseRecordProperties());
    }

    public GeoPipeline copyDatabaseRecordProperties(String[] keys) {
        return this.addPipe(new CopyDatabaseRecordProperties(keys));
    }

    public GeoPipeline copyDatabaseRecordProperties(String key) {
        return this.addPipe(new CopyDatabaseRecordProperties(key));
    }

    public GeoPipeline getMin(String property) {
        return this.addPipe(new Min(property));
    }

    public GeoPipeline getMax(String property) {
        return this.addPipe(new Max(property));
    }

    public GeoPipeline sort(String property) {
        return this.addPipe(new Sort(property, true));
    }

    public GeoPipeline sort(String property, boolean asc) {
        return this.addPipe(new Sort(property, asc));
    }

    public GeoPipeline sort(String property, Comparator<Object> comparator) {
        return this.addPipe(new Sort(property, comparator));
    }

    public GeoPipeline toBoundary() {
        return this.addPipe(new Boundary());
    }

    public GeoPipeline toBuffer(double distance) {
        return this.addPipe(new Buffer(distance));
    }

    public GeoPipeline toCentroid() {
        return this.addPipe(new Centroid());
    }

    public GeoPipeline toConvexHull() {
        return this.addPipe(new ConvexHull());
    }

    public GeoPipeline toEnvelope() {
        return this.addPipe(new Envelope());
    }

    public GeoPipeline toInteriorPoint() {
        return this.addPipe(new InteriorPoint());
    }

    public GeoPipeline toStartPoint() {
        return this.addPipe(new StartPoint(this.layer.getGeometryFactory()));
    }

    public GeoPipeline toEndPoint() {
        return this.addPipe(new EndPoint(this.layer.getGeometryFactory()));
    }

    public GeoPipeline countPoints() {
        return this.addPipe(new NumPoints());
    }

    public GeoPipeline union() {
        return this.addPipe(new Union());
    }

    public GeoPipeline union(Geometry geometry) {
        return this.addPipe(new Union(geometry));
    }

    public GeoPipeline unionAll() {
        return this.addPipe(new UnionAll());
    }

    public GeoPipeline intersect(Geometry geometry) {
        return this.addPipe(new Intersection(geometry));
    }

    public GeoPipeline intersectAll() {
        return this.addPipe(new IntersectAll());
    }

    public GeoPipeline difference(Geometry geometry) {
        return this.addPipe(new Difference(geometry));
    }

    public GeoPipeline symDifference(Geometry geometry) {
        return this.addPipe(new SymDifference(geometry));
    }

    public GeoPipeline simplifyWithDouglasPeucker(double distanceTolerance) {
        return this.addPipe(new SimplifyWithDouglasPeucker(distanceTolerance));
    }

    public GeoPipeline simplifyPreservingTopology(double distanceTolerance) {
        return this.addPipe(new SimplifyPreservingTopology(distanceTolerance));
    }

    public GeoPipeline applyAffineTransform(AffineTransformation t) {
        return this.addPipe(new ApplyAffineTransformation(t));
    }

    public GeoPipeline densify(double distanceTolerance) {
        return this.addPipe(new Densify(distanceTolerance));
    }

    public GeoPipeline calculateArea() {
        return this.addPipe(new Area());
    }

    public GeoPipeline calculateLength() {
        return this.addPipe(new Length());
    }

    public GeoPipeline calculateOrthodromicLength() {
        return this.addPipe(new OrthodromicLength(this.layer.getCoordinateReferenceSystem()));
    }

    public GeoPipeline calculateDistance(Geometry reference) {
        return this.addPipe(new Distance(reference));
    }

    public GeoPipeline calculateOrthodromicDistance(Coordinate reference) {
        return this.addPipe(new OrthodromicDistance(reference));
    }

    public GeoPipeline getDimension() {
        return this.addPipe(new Dimension());
    }

    public GeoPipeline getGeometryType() {
        return this.addPipe(new GeometryType());
    }

    public GeoPipeline getNumGeometries() {
        return this.addPipe(new NumGeometries());
    }

    public GeoPipeline createJson() {
        return this.addPipe(new GeoJSON());
    }

    public GeoPipeline createWellKnownText() {
        return this.addPipe(new WellKnownText());
    }

    public GeoPipeline createKML() {
        return this.addPipe(new KeyholeMarkupLanguage());
    }

    public GeoPipeline createGML() {
        return this.addPipe(new GML());
    }

    public GeoPipeline propertyFilter(String key, Object value) {
        return this.addPipe(new FilterProperty(key, value));
    }

    public GeoPipeline propertyFilter(String key, Object value, FilterPipe.Filter comparison) {
        return this.addPipe(new FilterProperty(key, value, comparison));
    }

    public GeoPipeline propertyNotNullFilter(String key) {
        return this.addPipe(new FilterPropertyNotNull(key));
    }

    public GeoPipeline propertyNullFilter(String key) {
        return this.addPipe(new FilterPropertyNull(key));
    }

    public GeoPipeline cqlFilter(String cql) throws CQLException {
        return this.addPipe(new FilterCQL(this.layer, cql));
    }

    public GeoPipeline intersectionFilter(Geometry geometry) {
        return this.addPipe(new FilterIntersect(geometry));
    }

    public GeoPipeline windowIntersectionFilter(double xmin, double ymin, double xmax, double ymax) {
        return this.addPipe(new FilterIntersectWindow(this.layer.getGeometryFactory(), xmin, ymin, xmax, ymax));
    }

    public GeoPipeline windowIntersectionFilter(com.vividsolutions.jts.geom.Envelope envelope) {
        return this.addPipe(new FilterIntersectWindow(this.layer.getGeometryFactory(), envelope));
    }

    public GeoPipeline containFilter(Geometry geometry) {
        return this.addPipe(new FilterContain(geometry));
    }

    public GeoPipeline coverFilter(Geometry geometry) {
        return this.addPipe(new FilterCover(geometry));
    }

    public GeoPipeline coveredByFilter(Geometry geometry) {
        return this.addPipe(new FilterCoveredBy(geometry));
    }

    public GeoPipeline crossFilter(Geometry geometry) {
        return this.addPipe(new FilterCross(geometry));
    }

    public GeoPipeline disjointFilter(Geometry geometry) {
        return this.addPipe(new FilterDisjoint(geometry));
    }

    public GeoPipeline emptyFilter() {
        return this.addPipe(new FilterEmpty());
    }

    public GeoPipeline equalExactFilter(Geometry geometry, double tolerance) {
        return this.addPipe(new FilterEqualExact(geometry, tolerance));
    }

    public GeoPipeline equalNormFilter(Geometry geometry, double tolerance) {
        return this.addPipe(new FilterEqualNorm(geometry, tolerance));
    }

    public GeoPipeline equalTopoFilter(Geometry geometry) {
        return this.addPipe(new FilterEqualTopo(geometry));
    }

    public GeoPipeline relationFilter(Geometry geometry, String intersectionPattern) {
        return this.addPipe(new FilterInRelation(geometry, intersectionPattern));
    }

    public GeoPipeline validFilter() {
        return this.addPipe(new FilterValid());
    }

    public GeoPipeline invalidFilter() {
        return this.addPipe(new FilterInvalid());
    }

    public GeoPipeline overlapFilter(Geometry geometry) {
        return this.addPipe(new FilterOverlap(geometry));
    }

    public GeoPipeline touchFilter(Geometry geometry) {
        return this.addPipe(new FilterTouch(geometry));
    }

    public GeoPipeline withinFilter(Geometry geometry) {
        return this.addPipe(new FilterWithin(geometry));
    }

    public GeoPipeline groupByDensityIslands(double density) {
        return this.addPipe(new DensityIslands(density));
    }

    public GeoPipeline extractPoints() {
        return this.addPipe(new ExtractPoints(this.layer.getGeometryFactory()));
    }

    public GeoPipeline extractGeometries() {
        return this.addPipe(new ExtractGeometries());
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> toStreamingFeatureCollection(com.vividsolutions.jts.geom.Envelope bounds) throws IOException {
        return this.toStreamingFeatureCollection(Neo4jFeatureBuilder.getTypeFromLayer(this.layer), bounds);
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> toStreamingFeatureCollection(SimpleFeatureType featureType, final com.vividsolutions.jts.geom.Envelope bounds) throws IOException {
        final Neo4jFeatureBuilder featureBuilder = new Neo4jFeatureBuilder(this.layer);
        return new AbstractFeatureCollection(featureType){

            public int size() {
                return Integer.MAX_VALUE;
            }

            protected Iterator<SimpleFeature> openIterator() {
                return new Iterator<SimpleFeature>(){

                    @Override
                    public boolean hasNext() {
                        return GeoPipeline.this.hasNext();
                    }

                    @Override
                    public SimpleFeature next() {
                        return featureBuilder.buildFeature(((GeoPipeFlow)GeoPipeline.this.next()).getRecord());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public ReferencedEnvelope getBounds() {
                return new ReferencedEnvelope(bounds, GeoPipeline.this.layer.getCoordinateReferenceSystem());
            }

            protected void closeIterator(Iterator<SimpleFeature> iterator) {
            }
        };
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> toFeatureCollection() throws IOException {
        return this.toFeatureCollection(Neo4jFeatureBuilder.getTypeFromLayer(this.layer));
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> toFeatureCollection(SimpleFeatureType featureType) throws IOException {
        final List records = this.toList();
        com.vividsolutions.jts.geom.Envelope bounds = null;
        for (GeoPipeFlow record : records) {
            if (bounds == null) {
                bounds = record.getGeometry().getEnvelopeInternal();
                continue;
            }
            bounds.expandToInclude(record.getGeometry().getEnvelopeInternal());
        }
        final Iterator recordsIterator = records.iterator();
        final ReferencedEnvelope refBounds = new ReferencedEnvelope(bounds, this.layer.getCoordinateReferenceSystem());
        final Neo4jFeatureBuilder featureBuilder = new Neo4jFeatureBuilder(featureType, Arrays.asList(this.layer.getExtraPropertyNames()));
        return new AbstractFeatureCollection(featureType){

            public int size() {
                return records.size();
            }

            protected Iterator<SimpleFeature> openIterator() {
                return new Iterator<SimpleFeature>(){

                    @Override
                    public boolean hasNext() {
                        return recordsIterator.hasNext();
                    }

                    @Override
                    public SimpleFeature next() {
                        return featureBuilder.buildFeature((SpatialRecord)recordsIterator.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public ReferencedEnvelope getBounds() {
                return refBounds;
            }

            protected void closeIterator(Iterator<SimpleFeature> iterator) {
            }
        };
    }

    public List<SpatialDatabaseRecord> toSpatialDatabaseRecordList() {
        ArrayList<SpatialDatabaseRecord> result = new ArrayList<SpatialDatabaseRecord>();
        try {
            while (true) {
                result.add(((GeoPipeFlow)this.next()).getRecord());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return result;
        }
    }

    public List<Node> toNodeList() {
        ArrayList<Node> result = new ArrayList<Node>();
        try {
            while (true) {
                result.add(((GeoPipeFlow)this.next()).getRecord().getGeomNode());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return result;
        }
    }
}

