/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.pipes.filtering;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import org.neo4j.gis.spatial.pipes.AbstractFilterGeoPipe;
import org.neo4j.gis.spatial.pipes.GeoPipeFlow;

public class FilterIntersectWindow
extends AbstractFilterGeoPipe {
    private Envelope envelope;
    private Geometry envelopeGeom;

    public FilterIntersectWindow(GeometryFactory geomFactory, double xmin, double ymin, double xmax, double ymax) {
        this(geomFactory, new Envelope(xmin, xmax, ymin, ymax));
    }

    public FilterIntersectWindow(GeometryFactory geomFactory, Envelope envelope) {
        this.envelope = envelope;
        this.envelopeGeom = geomFactory.toGeometry(envelope);
    }

    @Override
    protected boolean validate(GeoPipeFlow flow) {
        return this.envelope.intersects(flow.getEnvelope()) && this.envelopeGeom.intersects(flow.getGeometry());
    }
}

